/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.opentelemetry;

import io.jenkins.plugins.opentelemetry.semconv.JenkinsOtelSemanticAttributes;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.events.GlobalEventEmitterProvider;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.GuardedBy;

public final class GlobalOpenTelemetrySdk {
    private static final Logger logger = Logger.getLogger(GlobalOpenTelemetrySdk.class.getName());
    private static final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    static final AtomicInteger configurationCounter = new AtomicInteger();
    @GuardedBy(value="readWriteLock")
    private static volatile OpenTelemetrySdkState openTelemetrySdkState = new NoopOpenTelemetrySdkState();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configure(Map<String, String> configurationProperties, Map<String, String> resourceAttributes, boolean registerShutDownHook) {
        SdkConfigurationParameters sdkConfigurationParameters = new SdkConfigurationParameters(configurationProperties, resourceAttributes);
        Lock readLock = readWriteLock.readLock();
        readLock.lock();
        try {
            if (Objects.equals(sdkConfigurationParameters, openTelemetrySdkState.getSdkConfigurationParameters())) {
                logger.log(Level.FINEST, () -> "OpenTelemetry SDK configuration has NOT changed, don't reinitialize SDK");
                return;
            }
        }
        finally {
            readLock.unlock();
        }
        Lock writeLock = readWriteLock.writeLock();
        writeLock.lock();
        try {
            if (Objects.equals(sdkConfigurationParameters, openTelemetrySdkState.getSdkConfigurationParameters())) {
                logger.log(Level.FINEST, () -> "OpenTelemetry SDK configuration has NOT changed");
                return;
            }
            logger.log(Level.FINEST, () -> "Initialize/reinitialize OpenTelemetry SDK...");
            GlobalOpenTelemetrySdk.shutdown();
            AutoConfiguredOpenTelemetrySdkBuilder builder = AutoConfiguredOpenTelemetrySdk.builder().addPropertiesSupplier(sdkConfigurationParameters::getConfigurationProperties).addResourceCustomizer((resource, configProperties) -> {
                AttributesBuilder attributesBuilder = Attributes.builder();
                sdkConfigurationParameters.getResourceAttributes().forEach((arg_0, arg_1) -> ((AttributesBuilder)attributesBuilder).put(arg_0, arg_1));
                Attributes attributes = attributesBuilder.build();
                return Resource.builder().putAll(resource).putAll(attributes).build();
            });
            if (!registerShutDownHook) {
                builder.disableShutdownHook();
            }
            OpenTelemetrySdk openTelemetrySdk = builder.build().getOpenTelemetrySdk();
            openTelemetrySdkState = new OpenTelemetrySdkStateImpl(openTelemetrySdk, sdkConfigurationParameters);
            logger.log(Level.INFO, () -> "OpenTelemetry SDK initialized");
            configurationCounter.incrementAndGet();
        }
        finally {
            writeLock.unlock();
        }
    }

    public static CompletableResultCode shutdown() {
        Lock writeLock = readWriteLock.writeLock();
        writeLock.lock();
        try {
            CompletableResultCode result = openTelemetrySdkState.shutDown();
            openTelemetrySdkState = new NoopOpenTelemetrySdkState();
            CompletableResultCode completableResultCode = result;
            return completableResultCode;
        }
        finally {
            writeLock.unlock();
        }
    }

    public static io.opentelemetry.api.logs.Logger getOtelLogger() {
        Lock readLock = readWriteLock.readLock();
        readLock.lock();
        try {
            io.opentelemetry.api.logs.Logger logger = openTelemetrySdkState.getOtelLogger();
            return logger;
        }
        finally {
            readLock.unlock();
        }
    }

    public static Meter getMeter() {
        Lock readLock = readWriteLock.readLock();
        readLock.lock();
        try {
            Meter meter = openTelemetrySdkState.getMeter();
            return meter;
        }
        finally {
            readLock.unlock();
        }
    }

    public static Tracer getTracer() {
        Lock readLock = readWriteLock.readLock();
        readLock.lock();
        try {
            Tracer tracer = openTelemetrySdkState.getTracer();
            return tracer;
        }
        finally {
            readLock.unlock();
        }
    }

    static class SdkConfigurationParameters {
        private final Map<String, String> configurationProperties;
        private final Map<String, String> resourceAttributes;

        public SdkConfigurationParameters(Map<String, String> configurationProperties, Map<String, String> resourceAttributes) {
            this.configurationProperties = configurationProperties;
            this.resourceAttributes = resourceAttributes;
        }

        public Map<String, String> getConfigurationProperties() {
            return this.configurationProperties;
        }

        public Map<String, String> getResourceAttributes() {
            return this.resourceAttributes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SdkConfigurationParameters that = (SdkConfigurationParameters)o;
            return Objects.equals(this.configurationProperties, that.configurationProperties) && Objects.equals(this.resourceAttributes, that.resourceAttributes);
        }

        public int hashCode() {
            return Objects.hash(this.configurationProperties, this.resourceAttributes);
        }
    }

    private static interface OpenTelemetrySdkState {
        public io.opentelemetry.api.logs.Logger getOtelLogger();

        public Meter getMeter();

        public Tracer getTracer();

        public SdkConfigurationParameters getSdkConfigurationParameters();

        public CompletableResultCode shutDown();
    }

    private static class OpenTelemetrySdkStateImpl
    implements OpenTelemetrySdkState {
        private final OpenTelemetrySdk openTelemetrySdk;
        private final io.opentelemetry.api.logs.Logger otelLogger;
        private final Meter meter;
        private final Tracer tracer;
        private final SdkConfigurationParameters sdkConfigurationParameters;

        OpenTelemetrySdkStateImpl(OpenTelemetrySdk openTelemetrySdk, SdkConfigurationParameters sdkConfigurationParameters) {
            this.openTelemetrySdk = openTelemetrySdk;
            this.sdkConfigurationParameters = sdkConfigurationParameters;
            String jenkinsPluginVersion = Optional.ofNullable(sdkConfigurationParameters.resourceAttributes.get(JenkinsOtelSemanticAttributes.JENKINS_OPEN_TELEMETRY_PLUGIN_VERSION.getKey())).orElse("#unknown#");
            this.otelLogger = openTelemetrySdk.getSdkLoggerProvider().loggerBuilder("io.jenkins.opentelemetry").setInstrumentationVersion(jenkinsPluginVersion).build();
            this.tracer = openTelemetrySdk.getTracerProvider().tracerBuilder("io.jenkins.opentelemetry").setInstrumentationVersion(jenkinsPluginVersion).build();
            this.meter = openTelemetrySdk.getMeterProvider().meterBuilder("io.jenkins.opentelemetry").setInstrumentationVersion(jenkinsPluginVersion).build();
        }

        @Override
        public io.opentelemetry.api.logs.Logger getOtelLogger() {
            return this.otelLogger;
        }

        @Override
        public Meter getMeter() {
            return this.meter;
        }

        @Override
        public Tracer getTracer() {
            return this.tracer;
        }

        @Override
        public SdkConfigurationParameters getSdkConfigurationParameters() {
            return this.sdkConfigurationParameters;
        }

        @Override
        public CompletableResultCode shutDown() {
            logger.log(Level.FINE, "Shutdown OpenTelemetry...");
            CompletableResultCode result = this.openTelemetrySdk.shutdown();
            GlobalOpenTelemetry.resetForTest();
            GlobalEventEmitterProvider.resetForTest();
            return result;
        }
    }

    private static class NoopOpenTelemetrySdkState
    implements OpenTelemetrySdkState {
        private NoopOpenTelemetrySdkState() {
        }

        @Override
        public io.opentelemetry.api.logs.Logger getOtelLogger() {
            return LoggerProvider.noop().get("io.jenkins.opentelemetry");
        }

        @Override
        public Meter getMeter() {
            return MeterProvider.noop().get("io.jenkins.opentelemetry");
        }

        @Override
        public Tracer getTracer() {
            return TracerProvider.noop().get("io.jenkins.opentelemetry");
        }

        @Override
        public SdkConfigurationParameters getSdkConfigurationParameters() {
            return new SdkConfigurationParameters(Collections.emptyMap(), Collections.emptyMap());
        }

        @Override
        public CompletableResultCode shutDown() {
            return CompletableResultCode.ofSuccess();
        }
    }
}

