/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.step;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.opentelemetry.job.step.AbstractGitStepHandler;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import jenkins.YesNoMaybe;
import jenkins.plugins.git.GitStep;
import org.jenkinsci.plugins.workflow.actions.ArgumentsAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

@Extension(optional=true, dynamicLoadable=YesNoMaybe.YES)
public class GitStepHandler
extends AbstractGitStepHandler {
    private static final Logger LOGGER = Logger.getLogger(GitStepHandler.class.getName());

    @Override
    public boolean canCreateSpanBuilder(@NonNull FlowNode flowNode, @NonNull WorkflowRun run) {
        return flowNode instanceof StepAtomNode && ((StepAtomNode)flowNode).getDescriptor() instanceof GitStep.DescriptorImpl;
    }

    @Override
    @NonNull
    public SpanBuilder createSpanBuilder(@NonNull FlowNode node, @NonNull WorkflowRun run, @NonNull Tracer tracer) {
        Map arguments = ArgumentsAction.getFilteredArguments((FlowNode)node);
        String gitUrl = Preconditions.checkNotNull(arguments.get("url")).toString();
        String gitBranch = Objects.toString(arguments.get("branch"), null);
        String credentialsId = (String)arguments.get("credentialsId");
        String stepFunctionName = node.getDisplayFunctionName();
        return this.createSpanBuilder(gitUrl, gitBranch, credentialsId, stepFunctionName, tracer, run);
    }
}

