/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.step;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.extensions.impl.CloneOption;
import hudson.scm.SCM;
import io.jenkins.plugins.opentelemetry.job.step.AbstractGitStepHandler;
import io.jenkins.plugins.opentelemetry.semconv.JenkinsOtelSemanticAttributes;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.YesNoMaybe;
import jenkins.branch.Branch;
import org.jenkinsci.plugins.workflow.actions.ArgumentsAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.multibranch.BranchJobProperty;
import org.jenkinsci.plugins.workflow.steps.scm.GenericSCMStep;

@Extension(optional=true, dynamicLoadable=YesNoMaybe.YES)
public class GitCheckoutStepHandler
extends AbstractGitStepHandler {
    private static final Logger LOGGER = Logger.getLogger(GitCheckoutStepHandler.class.getName());

    @Override
    public boolean canCreateSpanBuilder(@NonNull FlowNode flowNode, @NonNull WorkflowRun run) {
        if (!(flowNode instanceof StepAtomNode)) {
            return false;
        }
        StepAtomNode stepAtomNode = (StepAtomNode)flowNode;
        if (!(stepAtomNode.getDescriptor() instanceof GenericSCMStep.DescriptorImpl)) {
            return false;
        }
        WorkflowJob pipeline = (WorkflowJob)run.getParent();
        BranchJobProperty branchJobProperty = (BranchJobProperty)pipeline.getProperty(BranchJobProperty.class);
        if (branchJobProperty == null) {
            Map rootArguments = ArgumentsAction.getFilteredArguments((FlowNode)flowNode);
            Object scmAsObject = rootArguments.get("scm");
            if (scmAsObject == null) {
                return false;
            }
            if (!(scmAsObject instanceof Map)) {
                LOGGER.log(Level.FINE, () -> "Skip unexpected 'scm' type: " + scmAsObject.getClass().getSimpleName() + ": " + scmAsObject);
                return false;
            }
            Map scm = (Map)scmAsObject;
            Object clazz = scm.get("$class");
            return Objects.equal((Object)GitSCM.class.getSimpleName(), clazz);
        }
        SCM scm = branchJobProperty.getBranch().getScm();
        return scm instanceof GitSCM;
    }

    @Override
    @NonNull
    public SpanBuilder createSpanBuilder(@NonNull FlowNode node, @NonNull WorkflowRun run, @NonNull Tracer tracer) {
        Map rootArguments = ArgumentsAction.getFilteredArguments((FlowNode)node);
        String stepFunctionName = node.getDisplayFunctionName();
        LOGGER.log(Level.FINE, () -> stepFunctionName + " - begin " + rootArguments);
        boolean shallow = false;
        int depth = 0;
        BranchJobProperty branchJobProperty = (BranchJobProperty)((WorkflowJob)run.getParent()).getProperty(BranchJobProperty.class);
        if (branchJobProperty == null) {
            String gitBranch;
            List userRemoteConfigs;
            Map userRemoteConfig;
            Map scm = (Map)rootArguments.get("scm");
            if (scm == null) {
                return this.addCloneAttributes(tracer.spanBuilder(stepFunctionName), shallow, depth);
            }
            Object clazz = scm.get("$class");
            if (!Objects.equal((Object)GitSCM.class.getSimpleName(), clazz)) {
                return this.addCloneAttributes(tracer.spanBuilder(stepFunctionName), shallow, depth);
            }
            List extensions = (List)scm.get("extensions");
            Map cloneOption = (Map)Iterables.getFirst((Iterable)extensions, null);
            if (cloneOption != null) {
                shallow = cloneOption.containsKey("shallow") ? (Boolean)cloneOption.get("shallow") : shallow;
                int n = depth = cloneOption.containsKey("depth") ? (Integer)cloneOption.get("depth") : depth;
            }
            if ((userRemoteConfig = (Map)Iterables.getFirst((Iterable)(userRemoteConfigs = (List)scm.get("userRemoteConfigs")), null)) == null) {
                return this.addCloneAttributes(tracer.spanBuilder(stepFunctionName), shallow, depth);
            }
            String gitUrl = (String)userRemoteConfig.get("url");
            String credentialsId = (String)userRemoteConfig.get("credentialsId");
            List branches = (List)scm.get("branches");
            if (branches == null) {
                gitBranch = null;
            } else {
                Map branch = (Map)Iterables.getFirst((Iterable)branches, null);
                gitBranch = (String)branch.get("name");
            }
            return this.addCloneAttributes(super.createSpanBuilder(gitUrl, gitBranch, credentialsId, stepFunctionName, tracer, run), shallow, depth);
        }
        Branch branch = branchJobProperty.getBranch();
        String gitBranch = branch.getName();
        SCM scm = branch.getScm();
        if (scm instanceof GitSCM) {
            UserRemoteConfig userRemoteConfig;
            GitSCM gitScm = (GitSCM)scm;
            CloneOption clone = (CloneOption)gitScm.getExtensions().get(CloneOption.class);
            if (clone != null && clone.isShallow()) {
                if (clone.getDepth() != null) {
                    depth = clone.getDepth();
                }
                shallow = clone.isShallow();
            }
            if ((userRemoteConfig = (UserRemoteConfig)Iterables.getFirst((Iterable)gitScm.getUserRemoteConfigs(), null)) == null) {
                return this.addCloneAttributes(tracer.spanBuilder(stepFunctionName), shallow, depth);
            }
            String gitUrl = userRemoteConfig.getUrl();
            String credentialsId = userRemoteConfig.getCredentialsId();
            if (Strings.isNullOrEmpty((String)gitUrl)) {
                return this.addCloneAttributes(tracer.spanBuilder(stepFunctionName), shallow, depth);
            }
            return this.addCloneAttributes(super.createSpanBuilder(gitUrl, gitBranch, credentialsId, stepFunctionName, tracer, run), shallow, depth);
        }
        return this.addCloneAttributes(tracer.spanBuilder(stepFunctionName), shallow, depth);
    }

    private SpanBuilder addCloneAttributes(@NonNull SpanBuilder spanBuilder, @NonNull boolean shallow, @NonNull int depth) {
        return spanBuilder.setAttribute(JenkinsOtelSemanticAttributes.GIT_CLONE_DEPTH, (Object)depth).setAttribute(JenkinsOtelSemanticAttributes.GIT_CLONE_SHALLOW, (Object)shallow);
    }
}

