/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.step;

import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.opentelemetry.job.step.StepHandler;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import java.util.Map;
import java.util.Objects;
import jenkins.YesNoMaybe;
import org.jenkinsci.plugins.workflow.actions.ArgumentsAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.durable_task.DurableTaskStep;

@Extension(optional=true, dynamicLoadable=YesNoMaybe.YES)
public class DurableTaskHandler
implements StepHandler {
    @Override
    public boolean canCreateSpanBuilder(@NonNull FlowNode flowNode, @NonNull WorkflowRun run) {
        return flowNode instanceof StepAtomNode && ((StepAtomNode)flowNode).getDescriptor() instanceof DurableTaskStep.DurableTaskStepDescriptor;
    }

    @Override
    @NonNull
    public SpanBuilder createSpanBuilder(@NonNull FlowNode node, @NonNull WorkflowRun run, @NonNull Tracer tracer) {
        Map arguments = ArgumentsAction.getFilteredArguments((FlowNode)node);
        String displayFunctionName = node.getDisplayFunctionName();
        String label = Objects.toString(arguments.get("label"), null);
        String spanName = Strings.isNullOrEmpty((String)label) ? displayFunctionName : label;
        return tracer.spanBuilder(spanName);
    }
}

