/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.runhandler;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Run;
import io.jenkins.plugins.opentelemetry.job.runhandler.RunHandler;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.mixin.ChangeRequestSCMHead;

@Extension
public class DefaultRunHandler
implements RunHandler {
    private static final List<String> CHANGE_REQUEST_JOB_NAME_SUFFIXES = Collections.unmodifiableList(Arrays.asList("-" + ChangeRequestCheckoutStrategy.HEAD.name().toLowerCase(Locale.ENGLISH), "-" + ChangeRequestCheckoutStrategy.MERGE.name().toLowerCase(Locale.ENGLISH)));

    @Override
    public boolean canCreateSpanBuilder(@NonNull Run run) {
        return true;
    }

    @Override
    @NonNull
    public SpanBuilder createSpanBuilder(@NonNull Run run, @NonNull Tracer tracer) {
        SCMHead head = SCMHead.HeadByItem.findHead((Item)run.getParent());
        String spanName = head instanceof ChangeRequestSCMHead ? this.getChangeRequestRootSpanName(run.getParent().getFullName()) : run.getParent().getFullName();
        SpanBuilder spanBuilder = tracer.spanBuilder("BUILD " + spanName);
        return spanBuilder;
    }

    @VisibleForTesting
    @NonNull
    protected String getChangeRequestRootSpanName(@NonNull String jobFullName) {
        String rootSpanName = jobFullName;
        for (String changeRequestJobNameSuffix : CHANGE_REQUEST_JOB_NAME_SUFFIXES) {
            if (!rootSpanName.endsWith(changeRequestJobNameSuffix)) continue;
            rootSpanName = rootSpanName.substring(0, rootSpanName.length() - changeRequestJobNameSuffix.length());
            break;
        }
        while (Character.isDigit(rootSpanName.charAt(rootSpanName.length() - 1))) {
            rootSpanName = rootSpanName.substring(0, rootSpanName.length() - 1);
        }
        if ('-' == rootSpanName.charAt(rootSpanName.length() - 1)) {
            return rootSpanName + "{number}";
        }
        return jobFullName;
    }

    @Override
    public int ordinal() {
        return Integer.MAX_VALUE;
    }
}

