/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.opentelemetry;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Environment;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import io.jenkins.plugins.opentelemetry.OtelComponent;
import io.jenkins.plugins.opentelemetry.job.OtelTraceService;
import io.opentelemetry.api.events.EventEmitter;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.io.IOException;
import java.util.logging.Logger;
import javax.inject.Inject;

public abstract class OtelContextAwareAbstractRunListener
extends RunListener<Run>
implements OtelComponent {
    private static final Logger LOGGER = Logger.getLogger(OtelContextAwareAbstractRunListener.class.getName());
    private OtelTraceService otelTraceService;
    private Tracer tracer;

    @Inject
    public final void setOpenTelemetryTracerService(@NonNull OtelTraceService otelTraceService) {
        this.otelTraceService = otelTraceService;
    }

    @Override
    public void afterSdkInitialized(Meter meter, LoggerProvider loggerProvider, EventEmitter eventEmitter, Tracer tracer, ConfigProperties configProperties) {
        this.tracer = tracer;
    }

    public final void onCompleted(@NonNull Run run, @NonNull TaskListener listener) {
        try (Scope scope = this.getTraceService().setupContext(run);){
            this._onCompleted(run, listener);
        }
    }

    public void _onCompleted(@NonNull Run run, @NonNull TaskListener listener) {
    }

    public final void onFinalized(@NonNull Run run) {
        try (Scope scope = this.getTraceService().setupContext(run);){
            this._onFinalized(run);
        }
    }

    public void _onFinalized(Run run) {
    }

    public final void onInitialize(@NonNull Run run) {
        this._onInitialize(run);
    }

    public void _onInitialize(@NonNull Run run) {
    }

    public final void onStarted(@NonNull Run run, @NonNull TaskListener listener) {
        try (Scope scope = this.getTraceService().setupContext(run);){
            this._onStarted(run, listener);
        }
    }

    public void _onStarted(@NonNull Run run, @NonNull TaskListener listener) {
    }

    public final Environment setUpEnvironment(@NonNull AbstractBuild build, @NonNull Launcher launcher, @NonNull BuildListener listener) throws IOException, InterruptedException, Run.RunnerAbortedException {
        try (Scope ignored = this.getTraceService().setupContext((Run)build);){
            Environment environment = this._setUpEnvironment(build, launcher, listener);
            return environment;
        }
    }

    @NonNull
    public Environment _setUpEnvironment(@NonNull AbstractBuild build, @NonNull Launcher launcher, @NonNull BuildListener listener) throws IOException, InterruptedException, Run.RunnerAbortedException {
        return new Environment(){};
    }

    public final void onDeleted(@NonNull Run run) {
        try (Scope ignored = this.getTraceService().setupContext(run, false);){
            this._onDeleted(run);
        }
    }

    public void _onDeleted(@NonNull Run run) {
    }

    @NonNull
    public OtelTraceService getTraceService() {
        return this.otelTraceService;
    }

    @NonNull
    public Tracer getTracer() {
        return this.tracer;
    }
}

