/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.log.util;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.jenkins.plugins.opentelemetry.job.log.util.LineIterator;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.Scope;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LineIteratorInputStream
extends InputStream {
    private static final Logger logger = Logger.getLogger(LineIteratorInputStream.class.getName());
    private final LineIterator.LineBytesToLineNumberConverter lineBytesToLineNumberConverter;
    private final LineIterator lines;
    protected final Tracer tracer;
    private int cursorOnCurrentLine;
    private byte[] currentLine;
    private long readLines;
    private long readBytes;

    public LineIteratorInputStream(LineIterator lines, LineIterator.LineBytesToLineNumberConverter lineBytesToLineNumberConverter, Tracer tracer) {
        this.lines = lines;
        this.lineBytesToLineNumberConverter = lineBytesToLineNumberConverter;
        this.tracer = tracer;
    }

    @Override
    public int read() throws IOException {
        if (this.currentLine == null) {
            if (this.cursorOnCurrentLine != 0) {
                throw new IllegalStateException("Current line is null but cursorOnCurrentLine!=0: " + this.cursorOnCurrentLine);
            }
            this.currentLine = Optional.ofNullable(this.readLine()).map(line -> line + "\n").map(line -> line.getBytes(StandardCharsets.UTF_8)).orElse(null);
            if (this.currentLine == null) {
                return -1;
            }
        }
        if (this.cursorOnCurrentLine > this.currentLine.length) {
            throw new IllegalStateException();
        }
        byte result = this.currentLine[this.cursorOnCurrentLine++];
        if (this.cursorOnCurrentLine == this.currentLine.length) {
            this.currentLine = null;
            this.cursorOnCurrentLine = 0;
        }
        ++this.readBytes;
        return result;
    }

    @Nullable
    String readLine() throws IOException {
        if (this.lines.hasNext()) {
            ++this.readLines;
            return (String)this.lines.next();
        }
        return null;
    }

    @Override
    public long skip(long skipBytes) throws IOException {
        Tracer tracer = logger.isLoggable(Level.FINE) ? this.tracer : TracerProvider.noop().get("noop");
        Span span = tracer.spanBuilder("LineIteratorInputStream.skip").setAttribute("skipBytes", skipBytes).startSpan();
        try {
            long l;
            block11: {
                Scope scope = span.makeCurrent();
                try {
                    Long skipLogLines = this.lineBytesToLineNumberConverter.getLogLineFromLogBytes(skipBytes);
                    if (skipLogLines == null) {
                        span.addEvent("Line Bytes to Line Number conversion not found");
                    } else {
                        span.setAttribute("skipLines", skipLogLines.longValue());
                        this.lines.skipLines(skipLogLines);
                        this.readBytes += skipBytes;
                        this.readLines += skipLogLines.longValue();
                    }
                    l = skipBytes;
                    if (scope == null) break block11;
                }
                catch (Throwable throwable) {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                scope.close();
            }
            return l;
        }
        finally {
            span.end();
        }
    }

    @Override
    public int available() throws IOException {
        Tracer tracer = logger.isLoggable(Level.FINER) ? this.tracer : TracerProvider.noop().get("noop");
        Span span = tracer.spanBuilder("LineIteratorInputStream.available").startSpan();
        try {
            int n;
            block13: {
                Scope scope;
                block11: {
                    int n2;
                    block12: {
                        scope = span.makeCurrent();
                        try {
                            if (!this.lines.hasNext()) break block11;
                            n2 = 1;
                            if (scope == null) break block12;
                        }
                        catch (Throwable throwable) {
                            if (scope != null) {
                                try {
                                    scope.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        scope.close();
                    }
                    return n2;
                }
                n = 0;
                if (scope == null) break block13;
                scope.close();
            }
            return n;
        }
        finally {
            span.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Tracer tracer = logger.isLoggable(Level.FINER) ? this.tracer : TracerProvider.noop().get("noop");
        Span span = tracer.spanBuilder("LineIteratorInputStream.close").setAttribute("readBytes", this.readBytes).setAttribute("readLines", this.readLines).startSpan();
        try (Scope scope = span.makeCurrent();){
            this.lineBytesToLineNumberConverter.putLogBytesToLogLine(this.readBytes, this.readLines);
            if (this.lines instanceof Closeable) {
                ((Closeable)((Object)this.lines)).close();
            }
        }
        finally {
            span.end();
        }
    }
}

