/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.log.util;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.jenkins.plugins.opentelemetry.job.RunFlowNodeIdentifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public interface LineIterator
extends Iterator<String> {
    public void skipLines(long var1);

    public static class JenkinsHttpSessionLineBytesToLineNumberConverter
    implements LineBytesToLineNumberConverter {
        private static final Logger logger = Logger.getLogger(JenkinsHttpSessionLineBytesToLineNumberConverter.class.getName());
        public static final String HTTP_SESSION_KEY = "JenkinsHttpSessionLineBytesToLineNumberConverter";
        final String jobFullName;
        final int runNumber;
        final String flowNodeId;

        public JenkinsHttpSessionLineBytesToLineNumberConverter(String jobFullName, int runNumber, String flowNodeId) {
            this.jobFullName = jobFullName;
            this.runNumber = runNumber;
            this.flowNodeId = flowNodeId;
        }

        @Override
        @Nullable
        public Long getLogLineFromLogBytes(long bytes) {
            RunFlowNodeIdentifier contextKey = new RunFlowNodeIdentifier(this.jobFullName, this.runNumber, this.flowNodeId);
            return Optional.ofNullable(this.getContext().get(contextKey)).map(d -> (Long)d.get(bytes)).orElse(null);
        }

        @Override
        public void putLogBytesToLogLine(long bytes, long line) {
            RunFlowNodeIdentifier contextKey = new RunFlowNodeIdentifier(this.jobFullName, this.runNumber, this.flowNodeId);
            this.getContext().computeIfAbsent(contextKey, runFlowNodeIdentifier -> new HashMap()).put(bytes, line);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Map<RunFlowNodeIdentifier, Map<Long, Long>> getContext() {
            HttpSession session;
            StaplerRequest currentRequest = Stapler.getCurrentRequest();
            if (currentRequest == null) {
                logger.log(Level.WARNING, "No current request found, default to default LogLineNumber context");
                return new HashMap<RunFlowNodeIdentifier, Map<Long, Long>>();
            }
            HttpSession httpSession = session = currentRequest.getSession();
            synchronized (httpSession) {
                HashMap<RunFlowNodeIdentifier, Map<Long, Long>> context = (HashMap<RunFlowNodeIdentifier, Map<Long, Long>>)session.getAttribute(HTTP_SESSION_KEY);
                if (context == null) {
                    context = new HashMap<RunFlowNodeIdentifier, Map<Long, Long>>();
                    session.setAttribute(HTTP_SESSION_KEY, context);
                }
                return context;
            }
        }
    }

    public static interface LineBytesToLineNumberConverter {
        @Nullable
        public Long getLogLineFromLogBytes(long var1);

        public void putLogBytesToLogLine(long var1, long var3);
    }
}

