/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.log;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Queue;
import hudson.model.Run;
import io.jenkins.plugins.opentelemetry.OpenTelemetrySdkProvider;
import io.jenkins.plugins.opentelemetry.OtelComponent;
import io.jenkins.plugins.opentelemetry.job.MonitoringAction;
import io.jenkins.plugins.opentelemetry.job.log.BuildInfo;
import io.jenkins.plugins.opentelemetry.job.log.OtelLogStorage;
import io.opentelemetry.api.events.EventEmitter;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.log.BrokenLogStorage;
import org.jenkinsci.plugins.workflow.log.LogStorage;
import org.jenkinsci.plugins.workflow.log.LogStorageFactory;

@Extension
public final class OtelLogStorageFactory
implements LogStorageFactory,
OtelComponent {
    private static final Logger logger = Logger.getLogger(OtelLogStorageFactory.class.getName());
    OpenTelemetrySdkProvider openTelemetrySdkProvider;
    private Tracer tracer;

    static OtelLogStorageFactory get() {
        return (OtelLogStorageFactory)ExtensionList.lookupSingleton(OtelLogStorageFactory.class);
    }

    @Nullable
    public LogStorage forBuild(@NonNull FlowExecutionOwner owner) {
        if (!this.getOpenTelemetrySdkProvider().isOtelLogsEnabled()) {
            logger.log(Level.FINE, () -> "OTel Logs disabled");
            return null;
        }
        try {
            Queue.Executable exec = owner.getExecutable();
            if (exec instanceof Run) {
                Run run = (Run)exec;
                MonitoringAction monitoringAction = (MonitoringAction)run.getAction(MonitoringAction.class);
                if (monitoringAction == null) {
                    throw new IllegalStateException("No MonitoringAction found for " + run);
                }
                Map<String, String> rootContext = monitoringAction.getRootContext();
                if (rootContext == null) {
                    throw new IllegalStateException("MonitoringAction.rootContext is null for " + run);
                }
                HashMap<String, String> buildInfoContext = new HashMap<String, String>(rootContext);
                BuildInfo buildInfo = new BuildInfo(run.getParent().getFullName(), run.getNumber(), monitoringAction.getTraceId(), monitoringAction.getSpanId(), buildInfoContext);
                logger.log(Level.FINEST, () -> "forBuild(" + buildInfo + ")");
                return new OtelLogStorage(buildInfo, this.tracer, run.getRootDir().getPath());
            }
            return null;
        }
        catch (IOException x) {
            return new BrokenLogStorage((Throwable)x);
        }
    }

    private OpenTelemetrySdkProvider getOpenTelemetrySdkProvider() {
        if (this.openTelemetrySdkProvider == null) {
            this.openTelemetrySdkProvider = OpenTelemetrySdkProvider.get();
        }
        return this.openTelemetrySdkProvider;
    }

    @Override
    public void afterSdkInitialized(Meter meter, LoggerProvider loggerProvider, EventEmitter eventEmitter, Tracer tracer, ConfigProperties configProperties) {
        this.tracer = tracer;
    }

    static {
        System.setProperty("org.jenkinsci.plugins.workflow.steps.durable_task.DurableTaskStep.USE_WATCHING", "true");
    }
}

