/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.log;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.BuildListener;
import io.jenkins.plugins.opentelemetry.OpenTelemetrySdkProvider;
import io.jenkins.plugins.opentelemetry.job.log.BuildInfo;
import io.jenkins.plugins.opentelemetry.job.log.OtelLogOutputStream;
import io.jenkins.plugins.opentelemetry.opentelemetry.GlobalOpenTelemetrySdk;
import io.jenkins.plugins.opentelemetry.opentelemetry.common.OffsetClock;
import io.opentelemetry.sdk.common.Clock;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.JenkinsJVM;

abstract class OtelLogSenderBuildListener
implements BuildListener {
    protected static final Logger LOGGER = Logger.getLogger(OtelLogSenderBuildListener.class.getName());
    final BuildInfo buildInfo;
    @Nullable
    final String flowNodeId;
    final Map<String, String> w3cTraceContext;
    final Map<String, String> otelConfigProperties;
    final Map<String, String> otelResourceAttributes;
    transient Clock clock;
    @CheckForNull
    transient PrintStream logger;

    public OtelLogSenderBuildListener(@NonNull BuildInfo buildInfo, @NonNull Map<String, String> otelConfigProperties, @NonNull Map<String, String> otelResourceAttributes) {
        this(buildInfo, null, otelConfigProperties, otelResourceAttributes);
    }

    public OtelLogSenderBuildListener(@NonNull BuildInfo buildInfo, @Nullable String flowNodeId, @NonNull Map<String, String> otelConfigProperties, @NonNull Map<String, String> otelResourceAttributes) {
        this.buildInfo = new BuildInfo(buildInfo);
        this.w3cTraceContext = buildInfo.getW3cTraceContext();
        this.flowNodeId = flowNodeId;
        this.otelConfigProperties = otelConfigProperties;
        this.otelResourceAttributes = otelResourceAttributes;
        this.clock = Clock.getDefault();
        JenkinsJVM.checkJenkinsJVM();
    }

    @NonNull
    public final synchronized PrintStream getLogger() {
        if (this.logger == null) {
            this.logger = new PrintStream((OutputStream)((Object)new OtelLogOutputStream(this.buildInfo, this.flowNodeId, this.w3cTraceContext, this.getOtelLogger(), this.clock)), false, StandardCharsets.UTF_8);
        }
        return this.logger;
    }

    abstract io.opentelemetry.api.logs.Logger getOtelLogger();

    private static class OtelLogSenderBuildListenerOnAgent
    extends OtelLogSenderBuildListener {
        private static final long serialVersionUID = 1L;
        private static final Logger logger = Logger.getLogger(OtelLogSenderBuildListenerOnAgent.class.getName());
        private long instantInNanosOnJenkinsControllerBeforeSerialization;

        private OtelLogSenderBuildListenerOnAgent(@NonNull BuildInfo buildInfo, @Nullable String flowNodeId, @NonNull Map<String, String> otelConfigProperties, @NonNull Map<String, String> otelResourceAttributes) {
            super(buildInfo, flowNodeId, otelConfigProperties, otelResourceAttributes);
            logger.log(Level.FINEST, () -> "new OtelLogSenderBuildListenerOnAgent()");
            JenkinsJVM.checkJenkinsJVM();
        }

        @Override
        public io.opentelemetry.api.logs.Logger getOtelLogger() {
            JenkinsJVM.checkNotJenkinsJVM();
            return GlobalOpenTelemetrySdk.getOtelLogger();
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            logger.log(Level.FINEST, () -> "writeObject(): set instantInNanosOnJenkinsControllerBeforeSerialization");
            JenkinsJVM.checkJenkinsJVM();
            this.instantInNanosOnJenkinsControllerBeforeSerialization = Clock.getDefault().now();
            stream.defaultWriteObject();
        }

        private Object readResolve() {
            this.adjustClock();
            GlobalOpenTelemetrySdk.configure(this.otelConfigProperties, this.otelResourceAttributes, false);
            return this;
        }

        private void adjustClock() {
            JenkinsJVM.checkNotJenkinsJVM();
            if (this.instantInNanosOnJenkinsControllerBeforeSerialization == 0L) {
                logger.log(Level.INFO, () -> "adjustClock(): unexpected timeBeforeSerialization of 0ns, don't adjust the clock");
                this.clock = Clock.getDefault();
            } else {
                long instantInNanosOnJenkinsAgentAtDeserialization = Clock.getDefault().now();
                long offsetInNanosOnJenkinsAgent = this.instantInNanosOnJenkinsControllerBeforeSerialization - instantInNanosOnJenkinsAgentAtDeserialization;
                logger.log(Level.FINE, () -> "adjustClock(): offsetInNanos: " + TimeUnit.MILLISECONDS.convert(offsetInNanosOnJenkinsAgent, TimeUnit.NANOSECONDS) + "ms / " + offsetInNanosOnJenkinsAgent + "ns. A negative offset of few milliseconds is expected due to the latency of the communication from the Jenkins Controller to the Jenkins Agent. Higher offsets indicate a synchronization gap of the system clocks between the Jenkins Controller that will be work arounded by the clock adjustment.");
                this.clock = OffsetClock.offsetClock(offsetInNanosOnJenkinsAgent);
            }
        }
    }

    static final class OtelLogSenderBuildListenerOnController
    extends OtelLogSenderBuildListener {
        private static final long serialVersionUID = 1L;
        private static final Logger logger = Logger.getLogger(OtelLogSenderBuildListenerOnController.class.getName());

        public OtelLogSenderBuildListenerOnController(@NonNull BuildInfo buildInfo, @NonNull Map<String, String> otelConfigProperties, @NonNull Map<String, String> otelResourceAttributes) {
            this(buildInfo, null, otelConfigProperties, otelResourceAttributes);
        }

        public OtelLogSenderBuildListenerOnController(@NonNull BuildInfo buildInfo, @Nullable String flowNodeId, @NonNull Map<String, String> otelConfigProperties, @NonNull Map<String, String> otelResourceAttributes) {
            super(buildInfo, flowNodeId, otelConfigProperties, otelResourceAttributes);
            logger.log(Level.FINEST, () -> "new OtelLogSenderBuildListenerOnController()");
            JenkinsJVM.checkJenkinsJVM();
        }

        @Override
        public io.opentelemetry.api.logs.Logger getOtelLogger() {
            JenkinsJVM.checkJenkinsJVM();
            return OpenTelemetrySdkProvider.get().getLoggerProvider().get("io.jenkins.opentelemetry");
        }

        private Object writeReplace() throws IOException {
            logger.log(Level.FINEST, () -> "writeReplace()");
            JenkinsJVM.checkJenkinsJVM();
            return new OtelLogSenderBuildListenerOnAgent(this.buildInfo, this.flowNodeId, this.otelConfigProperties, this.otelResourceAttributes);
        }
    }
}

