/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.log;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class MergedPrintStream
extends PrintStream {
    final PrintStream primary;
    final PrintStream secondary;

    public MergedPrintStream(@NonNull PrintStream primary, @NonNull PrintStream secondary) throws IOException {
        super((OutputStream)primary, false, "UTF-8");
        this.primary = primary;
        this.secondary = secondary;
    }

    @Override
    public void flush() {
        super.flush();
        this.secondary.flush();
    }

    @Override
    public void close() {
        super.close();
        this.secondary.close();
    }

    @Override
    public boolean checkError() {
        return super.checkError() && this.secondary.checkError();
    }

    @Override
    public void write(int b) {
        super.write(b);
        this.secondary.write(b);
    }

    @Override
    public void write(@NonNull byte[] buf, int off, int len) {
        super.write(buf, off, len);
        this.secondary.write(buf, off, len);
    }
}

