/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.log;

import com.google.common.base.Objects;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.opentelemetry.semconv.JenkinsOtelSemanticAttributes;
import io.opentelemetry.api.common.Attributes;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class BuildInfo
implements Serializable {
    static final long serialVersionUID = 1L;
    final String jobFullName;
    final int runNumber;
    final String spanId;
    final String traceId;
    @Deprecated
    final Map<String, String> w3cTraceContext;

    public BuildInfo(String jobFullName, int runNumber, String traceId, String spanId, Map<String, String> w3cTraceContext) {
        this.jobFullName = jobFullName;
        this.runNumber = runNumber;
        this.traceId = traceId;
        this.spanId = spanId;
        this.w3cTraceContext = w3cTraceContext;
    }

    public BuildInfo(BuildInfo buildInfo) {
        this.jobFullName = buildInfo.jobFullName;
        this.runNumber = buildInfo.runNumber;
        this.traceId = buildInfo.traceId;
        this.spanId = buildInfo.spanId;
        this.w3cTraceContext = new HashMap<String, String>(buildInfo.w3cTraceContext);
    }

    @NonNull
    public Attributes toAttributes() {
        return Attributes.builder().put(JenkinsOtelSemanticAttributes.CI_PIPELINE_ID, (Object)this.jobFullName).put(JenkinsOtelSemanticAttributes.CI_PIPELINE_RUN_NUMBER, this.runNumber).build();
    }

    public String getJobFullName() {
        return this.jobFullName;
    }

    public int getRunNumber() {
        return this.runNumber;
    }

    @Deprecated
    public Map<String, String> getW3cTraceContext() {
        return Collections.unmodifiableMap(this.w3cTraceContext);
    }

    public String toString() {
        return "BuildInfo{jobFullName='" + this.jobFullName + "', runNumber='" + this.runNumber + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildInfo buildInfo = (BuildInfo)o;
        return this.runNumber == buildInfo.runNumber && Objects.equal((Object)this.jobFullName, (Object)buildInfo.jobFullName) && Objects.equal(this.w3cTraceContext, buildInfo.w3cTraceContext);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.jobFullName, this.runNumber, this.w3cTraceContext});
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getSpanId() {
        return this.spanId;
    }

    public void setFlowNode(String flowNodeId) {
        if (this.w3cTraceContext != null) {
            this.w3cTraceContext.put("flowNode", flowNodeId);
        }
    }
}

