/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job;

import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.errorprone.annotations.MustBeClosed;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.tasks.BuildStep;
import io.jenkins.plugins.opentelemetry.OtelComponent;
import io.jenkins.plugins.opentelemetry.job.RunIdentifier;
import io.opentelemetry.api.events.EventEmitter;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.Scope;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.jcip.annotations.Immutable;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.graph.AtomNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStep;

@Extension
public class OtelTraceService
implements OtelComponent {
    private static Logger LOGGER = Logger.getLogger(OtelTraceService.class.getName());
    private transient ConcurrentMap<RunIdentifier, RunSpans> spansByRun;
    private transient ConcurrentMap<RunIdentifier, FreestyleRunSpans> freestyleSpansByRun;
    private Tracer tracer;
    private final Tracer noOpTracer = TracerProvider.noop().get("jenkins");

    public OtelTraceService() {
        this.initialize();
    }

    protected Object readResolve() {
        this.initialize();
        return this;
    }

    private void initialize() {
        this.spansByRun = new ConcurrentHashMap<RunIdentifier, RunSpans>();
        this.freestyleSpansByRun = new ConcurrentHashMap<RunIdentifier, FreestyleRunSpans>();
    }

    @NonNull
    public Span getSpan(@NonNull Run run) {
        return this.getSpan(run, true);
    }

    @NonNull
    public Span getSpan(@NonNull Run run, boolean verifyIfRemainingSteps) throws VerifyException {
        RunIdentifier runIdentifier = RunIdentifier.fromRun(run);
        RunSpans runSpans = this.spansByRun.computeIfAbsent(runIdentifier, runIdentifier1 -> new RunSpans());
        if (verifyIfRemainingSteps) {
            Verify.verify((boolean)runSpans.pipelineStepSpansByFlowNodeId.isEmpty(), (String)(run.getFullDisplayName() + " - Can't access run phase span while there are remaining pipeline step spans: " + runSpans), (Object[])new Object[0]);
        }
        LOGGER.log(Level.FINEST, () -> "getSpan(" + run.getFullDisplayName() + ") - " + runSpans);
        Span span = (Span)Iterables.getLast(runSpans.runPhasesSpans, null);
        if (span == null) {
            LOGGER.log(Level.FINE, () -> "No span found for run " + run.getFullDisplayName() + ", Jenkins server may have restarted");
            return this.noOpTracer.spanBuilder("noop-recovery-run-span-for-" + run.getFullDisplayName()).startSpan();
        }
        return span;
    }

    @NonNull
    public Span getPipelineRootSpan(@NonNull Run run) {
        RunIdentifier runIdentifier = RunIdentifier.fromRun(run);
        RunSpans runSpans = this.spansByRun.computeIfAbsent(runIdentifier, runIdentifier1 -> new RunSpans());
        return runSpans.runPhasesSpans.stream().findFirst().orElse(Span.getInvalid());
    }

    @NonNull
    public Span getSpan(@NonNull Run run, FlowNode flowNode) {
        RunIdentifier runIdentifier = RunIdentifier.fromRun(run);
        RunSpans runSpans = this.spansByRun.computeIfAbsent(runIdentifier, runIdentifier1 -> new RunSpans());
        LOGGER.log(Level.FINEST, () -> "getSpan(" + run.getFullDisplayName() + ", FlowNode[name" + flowNode.getDisplayName() + ", function:" + flowNode.getDisplayFunctionName() + ", id=" + flowNode.getId() + "]) -  " + runSpans);
        LOGGER.log(Level.FINEST, () -> "parentFlowNodes: " + flowNode.getParents().stream().map(node -> node.getDisplayName() + ", id: " + node.getId()).collect(Collectors.toList()));
        Iterable<FlowNode> ancestors = this.getAncestors(flowNode);
        for (FlowNode ancestor : ancestors) {
            Collection pipelineSpanContexts = runSpans.pipelineStepSpansByFlowNodeId.get((Object)ancestor.getId());
            PipelineSpanContext pipelineSpanContext = (PipelineSpanContext)Iterables.getLast((Iterable)pipelineSpanContexts, null);
            if (pipelineSpanContext == null) continue;
            return pipelineSpanContext.getSpan();
        }
        Span span = (Span)Iterables.getLast(runSpans.runPhasesSpans, null);
        if (span == null) {
            LOGGER.log(Level.FINE, () -> "No span found for run " + run.getFullDisplayName() + ", Jenkins server may have restarted");
            return this.noOpTracer.spanBuilder("noop-recovery-run-span-for-" + run.getFullDisplayName()).startSpan();
        }
        LOGGER.log(Level.FINEST, () -> "getSpan(): " + span.getSpanContext().getSpanId());
        return span;
    }

    @NonNull
    public Span getSpan(@NonNull AbstractBuild build, @NonNull BuildStep buildStep) {
        RunIdentifier runIdentifier = RunIdentifier.fromBuild(build);
        FreestyleRunSpans freestyleRunSpans = this.freestyleSpansByRun.computeIfAbsent(runIdentifier, runIdentifier1 -> new FreestyleRunSpans());
        LOGGER.log(Level.FINEST, () -> "getSpan(" + build.getFullDisplayName() + ", BuildStep[name" + buildStep.getClass().getSimpleName() + ") -  " + freestyleRunSpans);
        Span span = (Span)Iterables.getLast(freestyleRunSpans.runPhasesSpans, null);
        if (span == null) {
            LOGGER.log(Level.FINE, () -> "No span found for run " + build.getFullDisplayName() + ", Jenkins server may have restarted");
            return this.noOpTracer.spanBuilder("noop-recovery-run-span-for-" + build.getFullDisplayName()).startSpan();
        }
        LOGGER.log(Level.FINEST, () -> "span: " + span.getSpanContext().getSpanId());
        return span;
    }

    @NonNull
    private Iterable<FlowNode> getAncestors(@NonNull FlowNode flowNode) {
        LOGGER.log(Level.FINEST, () -> "> getAncestorsV2([" + flowNode.getClass().getSimpleName() + ", " + flowNode.getId() + ", '" + flowNode.getDisplayFunctionName() + "'])");
        ArrayList<FlowNode> ancestors = new ArrayList<FlowNode>();
        Object startNode = flowNode instanceof StepEndNode ? ((StepEndNode)flowNode).getStartNode() : flowNode;
        ancestors.add((FlowNode)startNode);
        ancestors.addAll(startNode.getEnclosingBlocks());
        LOGGER.log(Level.FINEST, () -> "< getAncestorsV2([" + flowNode.getClass().getSimpleName() + ", " + flowNode.getId() + ", '" + flowNode.getDisplayFunctionName() + "']): " + ancestors.stream().map(fn -> "[" + fn.getId() + ", " + fn.getDisplayFunctionName() + "]").collect(Collectors.joining(", ")));
        return ancestors;
    }

    public void removePipelineStepSpan(@NonNull Run run, @NonNull FlowNode flowNode, @NonNull Span span) {
        FlowNode startSpanNode;
        RunIdentifier runIdentifier = RunIdentifier.fromRun(run);
        RunSpans runSpans = this.spansByRun.computeIfAbsent(runIdentifier, runIdentifier1 -> new RunSpans());
        if (flowNode instanceof AtomNode) {
            startSpanNode = flowNode;
        } else if (flowNode instanceof StepEndNode) {
            StepEndNode stepEndNode = (StepEndNode)flowNode;
            startSpanNode = stepEndNode.getStartNode();
        } else if (flowNode instanceof StepStartNode && ((StepStartNode)flowNode).getDescriptor() instanceof ExecutorStep.DescriptorImpl) {
            startSpanNode = (FlowNode)Iterables.getFirst((Iterable)flowNode.getParents(), null);
        } else {
            throw new VerifyException("Can't remove span from node of type" + flowNode.getClass() + " - " + flowNode);
        }
        Collection pipelineSpanContexts = runSpans.pipelineStepSpansByFlowNodeId.get((Object)startSpanNode.getId());
        PipelineSpanContext pipelineSpanContext = (PipelineSpanContext)Iterables.getLast((Iterable)pipelineSpanContexts, null);
        if (pipelineSpanContext == null) {
            LOGGER.log(Level.FINE, () -> "Silently ignore removing missing span context for node [id=" + flowNode.getId() + ", function: " + flowNode.getDisplayFunctionName() + "] of run " + run.getFullDisplayName() + ". Jenkins may have restarted");
            return;
        }
        boolean removed = pipelineSpanContexts.remove(pipelineSpanContext);
        Verify.verify((removed ? 1 : 0) != 0, (String)"%s - Failure to remove span %s for node %s: %s", (Object[])new Object[]{run, pipelineSpanContext, startSpanNode, span, runSpans});
    }

    public void removeJobPhaseSpan(@NonNull Run run, @NonNull Span span) {
        RunIdentifier runIdentifier = RunIdentifier.fromRun(run);
        RunSpans runSpans = this.spansByRun.computeIfAbsent(runIdentifier, runIdentifier1 -> new RunSpans());
        Verify.verify((boolean)runSpans.pipelineStepSpansByFlowNodeId.isEmpty(), (String)"%s - Try to remove span associated with a run phase even though there are remain spans associated with flow nodes: %s", (Object)run, (Object)runSpans);
        Span lastSpan = (Span)Iterables.getLast(runSpans.runPhasesSpans, null);
        if (lastSpan == null) {
            LOGGER.log(Level.FINE, () -> "No span found for run " + run.getFullDisplayName() + ", Jenkins server may have restarted");
            return;
        }
        if (Objects.equals(span, lastSpan)) {
            boolean removed = runSpans.runPhasesSpans.remove(span);
            Verify.verify((boolean)removed, (String)(run.getFullDisplayName() + "Failure to remove span from runPhasesSpans: " + span), (Object[])new Object[0]);
            return;
        }
        throw new VerifyException(run.getFullDisplayName() + " - Failure to remove span " + span + " - " + runSpans);
    }

    public void removeBuildStepSpan(@NonNull AbstractBuild build, @NonNull BuildStep buildStep, @NonNull Span span) {
        RunIdentifier runIdentifier = RunIdentifier.fromBuild(build);
        FreestyleRunSpans freestyleRunSpans = this.freestyleSpansByRun.computeIfAbsent(runIdentifier, runIdentifier1 -> new FreestyleRunSpans());
        Span lastSpan = (Span)Iterables.getLast(freestyleRunSpans.runPhasesSpans, null);
        if (lastSpan == null) {
            LOGGER.log(Level.FINE, () -> "No span found for run " + build.getFullDisplayName() + ", Jenkins server may have restarted");
            return;
        }
        if (Objects.equals(span, lastSpan)) {
            boolean removed = freestyleRunSpans.runPhasesSpans.remove(span);
            Verify.verify((boolean)removed, (String)(build.getFullDisplayName() + "Failure to remove span from runPhasesSpans: " + span), (Object[])new Object[0]);
            return;
        }
        throw new VerifyException(build.getFullDisplayName() + " - Failure to remove span " + span + " - " + freestyleRunSpans);
    }

    public void purgeRun(@NonNull Run run) {
        RunIdentifier runIdentifier = RunIdentifier.fromRun(run);
        RunSpans runSpans = (RunSpans)this.spansByRun.remove(runIdentifier);
        if (runSpans == null) {
            return;
        }
        if (!runSpans.runPhasesSpans.isEmpty() || !runSpans.pipelineStepSpansByFlowNodeId.isEmpty()) {
            throw new VerifyException(run.getFullDisplayName() + " - Some spans have not been ended and removed: " + runSpans);
        }
    }

    public void putSpan(@NonNull AbstractBuild build, @NonNull Span span) {
        RunIdentifier runIdentifier = RunIdentifier.fromBuild(build);
        FreestyleRunSpans runSpans = this.freestyleSpansByRun.computeIfAbsent(runIdentifier, runIdentifier1 -> new FreestyleRunSpans());
        runSpans.runPhasesSpans.add(span);
        LOGGER.log(Level.FINEST, () -> "putSpan(" + build.getFullDisplayName() + "," + span + ") - new stack: " + runSpans);
    }

    public void putSpan(@NonNull Run run, @NonNull Span span) {
        RunIdentifier runIdentifier = RunIdentifier.fromRun(run);
        RunSpans runSpans = this.spansByRun.computeIfAbsent(runIdentifier, runIdentifier1 -> new RunSpans());
        runSpans.runPhasesSpans.add(span);
        LOGGER.log(Level.FINEST, () -> "putSpan(" + run.getFullDisplayName() + "," + span + ") - new stack: " + runSpans);
    }

    public void putSpan(@NonNull Run run, @NonNull Span span, @NonNull FlowNode flowNode) {
        RunIdentifier runIdentifier = RunIdentifier.fromRun(run);
        RunSpans runSpans = this.spansByRun.computeIfAbsent(runIdentifier, runIdentifier1 -> new RunSpans());
        runSpans.pipelineStepSpansByFlowNodeId.put((Object)flowNode.getId(), (Object)new PipelineSpanContext(span, flowNode));
        LOGGER.log(Level.FINEST, () -> "putSpan(" + run.getFullDisplayName() + ", FlowNode[name: " + flowNode.getDisplayName() + ", function: " + flowNode.getDisplayFunctionName() + ", id: " + flowNode.getId() + "], Span[id: " + span.getSpanContext().getSpanId() + "]) -  " + runSpans);
    }

    @NonNull
    @MustBeClosed
    public Scope setupContext(@NonNull Run run) {
        return this.setupContext(run, true);
    }

    @NonNull
    @MustBeClosed
    public Scope setupContext(@NonNull Run run, boolean verifyIfRemainingSteps) {
        Span span = this.getSpan(run, verifyIfRemainingSteps);
        return span.makeCurrent();
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    @Override
    public void afterSdkInitialized(Meter meter, LoggerProvider loggerProvider, EventEmitter eventEmitter, Tracer tracer, ConfigProperties configProperties) {
        this.tracer = tracer;
    }

    @Override
    public void beforeSdkShutdown() {
    }

    @Immutable
    public static class RunSpans {
        final Multimap<String, PipelineSpanContext> pipelineStepSpansByFlowNodeId = ArrayListMultimap.create();
        final List<Span> runPhasesSpans = new ArrayList<Span>();

        public String toString() {
            return "RunSpans{runPhasesSpans=" + Collections.unmodifiableList(this.runPhasesSpans) + ", pipelineStepSpansByFlowNodeId=" + ArrayListMultimap.create(this.pipelineStepSpansByFlowNodeId) + "}";
        }
    }

    public static class PipelineSpanContext {
        final transient Span span;
        final String flowNodeId;
        final List<String> parentFlowNodeIds;

        public PipelineSpanContext(@NonNull Span span, @NonNull FlowNode flowNode) {
            this.span = span;
            this.flowNodeId = flowNode.getId();
            List parents = flowNode.getParents();
            this.parentFlowNodeIds = new ArrayList<String>(parents.size() + 1);
            this.parentFlowNodeIds.add(flowNode.getId());
            this.parentFlowNodeIds.addAll(parents.stream().map(FlowNode::getId).collect(Collectors.toList()));
        }

        @NonNull
        public List<String> getParentFlowNodeIds() {
            return this.parentFlowNodeIds;
        }

        @NonNull
        public Span getSpan() {
            return this.span;
        }

        public String toString() {
            return "PipelineSpanContext{span=" + this.span + "flowNodeId=" + this.flowNodeId + ", parentIds=" + this.parentFlowNodeIds + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PipelineSpanContext that = (PipelineSpanContext)o;
            return Objects.equals(this.span.getSpanContext().getSpanId(), that.span.getSpanContext().getSpanId()) && this.flowNodeId.equals(that.flowNodeId);
        }

        public int hashCode() {
            return Objects.hash(this.span.getSpanContext().getSpanId(), this.flowNodeId);
        }
    }

    @Immutable
    public static class FreestyleRunSpans {
        final Multimap<String, FreestyleSpanContext> buildStepSpans = ArrayListMultimap.create();
        final List<Span> runPhasesSpans = new ArrayList<Span>();

        public String toString() {
            return "FreestyleRunSpans{runPhasesSpans=" + Collections.unmodifiableList(this.runPhasesSpans) + ", buildStepSpans=" + ArrayListMultimap.create(this.buildStepSpans) + "}";
        }
    }

    public static class FreestyleSpanContext {
        final transient Span span;
        final String flowNodeId;

        public FreestyleSpanContext(@NonNull Span span, @NonNull BuildStep buildStep) {
            this.span = span;
            this.flowNodeId = buildStep.getClass().getSimpleName();
        }

        @NonNull
        public Span getSpan() {
            return this.span;
        }

        public String toString() {
            return "FreestyleSpanContext{span=" + this.span + ", flowNodeId=" + this.flowNodeId + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FreestyleSpanContext that = (FreestyleSpanContext)o;
            return Objects.equals(this.span.getSpanContext().getSpanId(), that.span.getSpanContext().getSpanId()) && this.flowNodeId.equals(that.flowNodeId);
        }

        public int hashCode() {
            return Objects.hash(this.span.getSpanContext().getSpanId(), this.flowNodeId);
        }
    }
}

