/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Run;
import io.jenkins.plugins.opentelemetry.JenkinsOpenTelemetryPluginConfiguration;
import io.jenkins.plugins.opentelemetry.job.MonitoringAction;
import io.jenkins.plugins.opentelemetry.semconv.JenkinsOtelSemanticAttributes;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.propagation.W3CBaggagePropagator;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;

@Extension
public class OtelEnvironmentContributorService {
    private static final Logger LOGGER = Logger.getLogger(OtelEnvironmentContributorService.class.getName());
    private JenkinsOpenTelemetryPluginConfiguration jenkinsOpenTelemetryPluginConfiguration;

    public void addEnvironmentVariables(@NonNull Run run, @NonNull EnvVars envs, @NonNull Span span) {
        String spanId = span.getSpanContext().getSpanId();
        String traceId = span.getSpanContext().getTraceId();
        envs.putIfAbsent((Object)"TRACE_ID", (Object)traceId);
        envs.put("SPAN_ID", spanId);
        try (Scope ignored = span.makeCurrent();){
            TextMapSetter setter = (carrier, key, value) -> carrier.put(key.toUpperCase(), value);
            W3CTraceContextPropagator.getInstance().inject(Context.current(), (Object)envs, setter);
        }
        Baggage baggage = Baggage.builder().put(JenkinsOtelSemanticAttributes.CI_PIPELINE_ID.getKey(), run.getParent().getFullName()).put(JenkinsOtelSemanticAttributes.CI_PIPELINE_RUN_NUMBER.getKey(), String.valueOf(run.getNumber())).build();
        try (Scope ignored = baggage.makeCurrent();){
            TextMapSetter setter = (carrier, key, value) -> carrier.put(key.toUpperCase(), value);
            W3CBaggagePropagator.getInstance().inject(Context.current(), (Object)envs, setter);
        }
        MonitoringAction monitoringAction = (MonitoringAction)run.getAction(MonitoringAction.class);
        if (monitoringAction == null) {
            LOGGER.log(Level.INFO, () -> "MonitoringAction NOT found on run " + run);
        } else {
            for (MonitoringAction.ObservabilityBackendLink link : monitoringAction.getLinks()) {
                if (link.getEnvironmentVariableName() == null) continue;
                envs.put(link.getEnvironmentVariableName(), link.getUrl());
            }
        }
        if (this.jenkinsOpenTelemetryPluginConfiguration.isExportOtelConfigurationAsEnvironmentVariables()) {
            Map<String, String> otelConfiguration = this.jenkinsOpenTelemetryPluginConfiguration.getOtelConfigurationAsEnvironmentVariables();
            for (Map.Entry<String, String> otelEnvironmentVariable : otelConfiguration.entrySet()) {
                String envVarValue = otelEnvironmentVariable.getValue();
                String envVarName = otelEnvironmentVariable.getKey();
                if (envVarValue == null) {
                    LOGGER.log(Level.FINE, () -> "No value found for environment variable '" + envVarName + "'");
                    continue;
                }
                String previousValue = envs.put(envVarName, envVarValue);
                if (previousValue == null) continue;
                LOGGER.log(Level.FINE, () -> "Overwrite environment variable '" + envVarName + "'");
            }
        }
    }

    @Inject
    public void setJenkinsOpenTelemetryPluginConfiguration(JenkinsOpenTelemetryPluginConfiguration jenkinsOpenTelemetryPluginConfiguration) {
        this.jenkinsOpenTelemetryPluginConfiguration = jenkinsOpenTelemetryPluginConfiguration;
    }
}

