/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import hudson.model.Run;
import io.jenkins.plugins.opentelemetry.JenkinsOpenTelemetryPluginConfiguration;
import io.jenkins.plugins.opentelemetry.OtelUtils;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.workflow.graph.FlowNode;

public class MonitoringAction
implements Action,
RunAction2,
SimpleBuildStep.LastBuildAction {
    private static final Logger LOGGER = Logger.getLogger(MonitoringAction.class.getName());
    final String traceId;
    final String spanId;
    final String rootSpanName;
    Map<String, Map<String, String>> contextPerNodeId = new HashMap<String, Map<String, String>>();
    Map<String, String> rootContext = new HashMap<String, String>();
    transient Run run;

    public MonitoringAction(String traceId, String spanId, String rootSpanName) {
        this.traceId = traceId;
        this.spanId = spanId;
        this.rootSpanName = rootSpanName;
    }

    public void onAttached(Run<?, ?> r) {
        this.run = r;
    }

    public void onLoad(Run<?, ?> r) {
        this.run = r;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "OpenTelemetry";
    }

    public Collection<? extends Action> getProjectActions() {
        return this.run.getParent().getLastSuccessfulBuild().getActions(MonitoringAction.class);
    }

    public String getUrlName() {
        return null;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getSpanId() {
        return this.spanId;
    }

    public void addContext(@NonNull FlowNode node, @NonNull Map<String, String> context) {
        if (this.contextPerNodeId == null) {
            this.contextPerNodeId = new HashMap<String, Map<String, String>>();
        }
        this.contextPerNodeId.put(node.getId(), context);
    }

    @CheckForNull
    public Map<String, String> getRootContext() {
        return this.rootContext;
    }

    public void addRootContext(@NonNull Map<String, String> context) {
        this.rootContext = context;
    }

    @CheckForNull
    public Map<String, String> getContext(@NonNull String flowNodeId) {
        return this.contextPerNodeId.get(flowNodeId);
    }

    @NonNull
    public List<ObservabilityBackendLink> getLinks() {
        List tracingCapableBackends = JenkinsOpenTelemetryPluginConfiguration.get().getObservabilityBackends().stream().filter(backend -> backend.getTraceVisualisationUrlTemplate() != null).collect(Collectors.toList());
        if (tracingCapableBackends.isEmpty()) {
            return Collections.singletonList(new ObservabilityBackendLink("Please define an OpenTelemetry Visualisation URL of pipelines in Jenkins configuration", Jenkins.get().getRootUrl() + "/configure", "icon-gear2", null));
        }
        HashMap<String, Object> binding = new HashMap<String, Object>();
        binding.put("serviceName", Objects.requireNonNull(JenkinsOpenTelemetryPluginConfiguration.get().getServiceName()));
        binding.put("rootSpanName", this.rootSpanName == null ? null : OtelUtils.urlEncode(this.rootSpanName));
        binding.put("traceId", this.traceId);
        binding.put("spanId", this.spanId);
        binding.put("startTime", Instant.ofEpochMilli(this.run.getStartTimeInMillis()));
        return tracingCapableBackends.stream().map(backend -> new ObservabilityBackendLink("View pipeline with " + backend.getName(), backend.getTraceVisualisationUrl(binding), backend.getIconPath(), backend.getEnvVariableName())).collect(Collectors.toList());
    }

    public String toString() {
        return "MonitoringAction{traceId='" + this.traceId + "', spanId='" + this.spanId + "', run='" + this.run + "'}";
    }

    public static class ObservabilityBackendLink {
        final String label;
        final String url;
        final String iconClass;
        final String environmentVariableName;

        public ObservabilityBackendLink(String label, String url, String iconClass, String environmentVariableName) {
            this.label = label;
            this.url = url;
            this.iconClass = iconClass;
            this.environmentVariableName = environmentVariableName;
        }

        public String getLabel() {
            return this.label;
        }

        public String getUrl() {
            return this.url;
        }

        public String getIconClass() {
            return this.iconClass;
        }

        public String getEnvironmentVariableName() {
            return this.environmentVariableName;
        }

        public String toString() {
            return "ObservabilityBackendLink{label='" + this.label + "', url='" + this.url + "', iconUrl='" + this.iconClass + "', environmentVariableName='" + this.environmentVariableName + "'}";
        }
    }
}

