/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.init;

import hudson.Extension;
import io.jenkins.plugins.opentelemetry.OtelComponent;
import io.opentelemetry.api.events.EventEmitter;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.YesNoMaybe;
import jenkins.scm.api.SCMEvent;

@Extension(dynamicLoadable=YesNoMaybe.YES, optional=true)
public class SCMEventMonitoringInitializer
implements OtelComponent {
    private static final Logger logger = Logger.getLogger(SCMEventMonitoringInitializer.class.getName());

    @Override
    public void afterSdkInitialized(Meter meter, LoggerProvider loggerProvider, EventEmitter eventEmitter, Tracer tracer, ConfigProperties configProperties) {
        meter.counterBuilder("jenkins.scm.event.pool_size").setDescription("Number of threads handling SCM Events").setUnit("1").buildWithCallback(valueObserver -> valueObserver.record((long)SCMEvent.getEventProcessingMetrics().getPoolSize()));
        meter.upDownCounterBuilder("jenkins.scm.event.active_threads").setDescription("Number of threads actively handling SCM Events").setUnit("1").buildWithCallback(valueObserver -> valueObserver.record((long)SCMEvent.getEventProcessingMetrics().getActiveThreads()));
        meter.upDownCounterBuilder("jenkins.scm.event.queued_tasks").setDescription("Number of queued SCM Event tasks").setUnit("1").buildWithCallback(valueObserver -> valueObserver.record((long)SCMEvent.getEventProcessingMetrics().getQueuedTasks()));
        meter.counterBuilder("jenkins.scm.event.completed_tasks").setDescription("Number of completed SCM Event tasks").setUnit("1").buildWithCallback(valueObserver -> valueObserver.record(SCMEvent.getEventProcessingMetrics().getCompletedTasks()));
        logger.log(Level.FINE, () -> "Start monitoring Jenkins SCM events...");
    }
}

