/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.backend.elastic;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ilm.GetLifecycleResponse;
import co.elastic.clients.elasticsearch.ilm.Phase;
import co.elastic.clients.elasticsearch.ilm.Phases;
import co.elastic.clients.elasticsearch.ilm.get_lifecycle.Lifecycle;
import co.elastic.clients.elasticsearch.indices.ElasticsearchIndicesClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.google.errorprone.annotations.MustBeClosed;
import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.text.Template;
import hudson.util.FormValidation;
import io.jenkins.plugins.opentelemetry.OpenTelemetrySdkProvider;
import io.jenkins.plugins.opentelemetry.TemplateBindingsProvider;
import io.jenkins.plugins.opentelemetry.backend.elastic.ElasticsearchBuildLogsLineIterator;
import io.jenkins.plugins.opentelemetry.jenkins.CredentialsNotFoundException;
import io.jenkins.plugins.opentelemetry.job.log.LogStorageRetriever;
import io.jenkins.plugins.opentelemetry.job.log.LogsQueryResult;
import io.jenkins.plugins.opentelemetry.job.log.LogsViewHeader;
import io.jenkins.plugins.opentelemetry.job.log.util.InputStreamByteBuffer;
import io.jenkins.plugins.opentelemetry.job.log.util.LineIterator;
import io.jenkins.plugins.opentelemetry.job.log.util.LineIteratorInputStream;
import io.jenkins.plugins.opentelemetry.semconv.JenkinsOtelSemanticAttributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.elasticsearch.client.RestClient;

public class ElasticsearchLogStorageRetriever
implements LogStorageRetriever,
Closeable {
    private static final Logger logger = Logger.getLogger(ElasticsearchLogStorageRetriever.class.getName());
    public static final String KEEPALIVE_INTERVAL_DEFAULT = "30000";
    public static final String KEEPALIVE_DEFAULT = "true";
    public static final String KEEPALIVE_INTERVAL_PROPERTY = ElasticsearchLogStorageRetriever.class.getName() + ".keepAlive.interval";
    public static final String KEEPALIVE_PROPERTY = ElasticsearchLogStorageRetriever.class.getName() + ".keepAlive.enabled";
    public static final int KEEPALIVE_INTERVAL = Integer.parseInt(System.getProperty(KEEPALIVE_INTERVAL_PROPERTY, "30000"));
    public static final boolean KEEPALIVE = Boolean.parseBoolean(System.getProperty(KEEPALIVE_PROPERTY, "true"));
    @NonNull
    private final Template buildLogsVisualizationUrlTemplate;
    private final TemplateBindingsProvider templateBindingsProvider;
    @NonNull
    final Credentials elasticsearchCredentials;
    @NonNull
    final String elasticsearchUrl;
    @NonNull
    final RestClient restClient;
    @NonNull
    final RestClientTransport elasticsearchTransport;
    @NonNull
    private final ElasticsearchClient esClient;
    private Tracer _tracer;

    @MustBeClosed
    public ElasticsearchLogStorageRetriever(@NonNull String elasticsearchUrl, boolean disableSslVerifications, @NonNull Credentials elasticsearchCredentials, @NonNull Template buildLogsVisualizationUrlTemplate, @NonNull TemplateBindingsProvider templateBindingsProvider) {
        if (StringUtils.isBlank((String)elasticsearchUrl)) {
            throw new IllegalArgumentException("Elasticsearch url cannot be blank");
        }
        this.elasticsearchUrl = elasticsearchUrl;
        this.elasticsearchCredentials = elasticsearchCredentials;
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, elasticsearchCredentials);
        this.restClient = RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)elasticsearchUrl)}).setHttpClientConfigCallback(httpClientBuilder -> {
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            httpClientBuilder.setDefaultIOReactorConfig(IOReactorConfig.custom().setSoKeepAlive(KEEPALIVE).build());
            httpClientBuilder.setKeepAliveStrategy((response, context) -> KEEPALIVE_INTERVAL);
            if (disableSslVerifications) {
                try {
                    SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new TrustAllStrategy()).build();
                    httpClientBuilder.setSSLContext(sslContext);
                }
                catch (GeneralSecurityException e) {
                    logger.log(Level.WARNING, "IllegalStateException: failure to disable SSL certs verification");
                }
                httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            return httpClientBuilder;
        }).build();
        this.elasticsearchTransport = new RestClientTransport(this.restClient, (JsonpMapper)new JacksonJsonpMapper());
        this.esClient = new ElasticsearchClient((ElasticsearchTransport)this.elasticsearchTransport);
        this.buildLogsVisualizationUrlTemplate = buildLogsVisualizationUrlTemplate;
        this.templateBindingsProvider = templateBindingsProvider;
    }

    @Override
    @NonNull
    public LogsQueryResult overallLog(@NonNull String jobFullName, int runNumber, @NonNull String traceId, @NonNull String spanId, boolean complete) {
        Charset charset = StandardCharsets.UTF_8;
        SpanBuilder spanBuilder = this.getTracer().spanBuilder("ElasticsearchLogStorageRetriever.overallLog").setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_ID, (Object)jobFullName).setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_RUN_NUMBER, (Object)runNumber).setAttribute("complete", complete);
        Span span = spanBuilder.startSpan();
        try {
            LogsQueryResult logsQueryResult;
            block9: {
                Scope scope = span.makeCurrent();
                try {
                    ElasticsearchBuildLogsLineIterator logLines = new ElasticsearchBuildLogsLineIterator(jobFullName, runNumber, traceId, this.esClient, this.getTracer());
                    LineIterator.JenkinsHttpSessionLineBytesToLineNumberConverter lineBytesToLineNumberConverter = new LineIterator.JenkinsHttpSessionLineBytesToLineNumberConverter(jobFullName, runNumber, null);
                    LineIteratorInputStream lineIteratorInputStream = new LineIteratorInputStream(logLines, lineBytesToLineNumberConverter, this.getTracer());
                    InputStreamByteBuffer byteBuffer = new InputStreamByteBuffer(lineIteratorInputStream, this.getTracer());
                    HashMap<String, String> localBindings = new HashMap<String, String>();
                    localBindings.put("traceId", traceId);
                    localBindings.put("spanId", spanId);
                    Map<String, String> bindings = TemplateBindingsProvider.compose(this.templateBindingsProvider, localBindings).getBindings();
                    String logsVisualizationUrl = this.buildLogsVisualizationUrlTemplate.make(bindings).toString();
                    logsQueryResult = new LogsQueryResult(byteBuffer, new LogsViewHeader(bindings.get("backendName"), logsVisualizationUrl, bindings.get("backend24x24IconUrl")), charset, complete);
                    if (scope == null) break block9;
                }
                catch (Throwable throwable) {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                scope.close();
            }
            return logsQueryResult;
        }
        finally {
            span.end();
        }
    }

    @Override
    @NonNull
    public LogsQueryResult stepLog(@NonNull String jobFullName, int runNumber, @NonNull String flowNodeId, @NonNull String traceId, @NonNull String spanId, boolean complete) {
        Charset charset = StandardCharsets.UTF_8;
        SpanBuilder spanBuilder = this.getTracer().spanBuilder("ElasticsearchLogStorageRetriever.stepLog").setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_ID, (Object)jobFullName).setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_RUN_NUMBER, (Object)runNumber).setAttribute(JenkinsOtelSemanticAttributes.JENKINS_STEP_ID, (Object)flowNodeId).setAttribute("complete", complete);
        Span span = spanBuilder.startSpan();
        try {
            LogsQueryResult logsQueryResult;
            block9: {
                Scope scope = span.makeCurrent();
                try {
                    ElasticsearchBuildLogsLineIterator logLines = new ElasticsearchBuildLogsLineIterator(jobFullName, runNumber, traceId, flowNodeId, this.esClient, this.getTracer());
                    LineIterator.JenkinsHttpSessionLineBytesToLineNumberConverter lineBytesToLineNumberConverter = new LineIterator.JenkinsHttpSessionLineBytesToLineNumberConverter(jobFullName, runNumber, flowNodeId);
                    LineIteratorInputStream lineIteratorInputStream = new LineIteratorInputStream(logLines, lineBytesToLineNumberConverter, this.getTracer());
                    InputStreamByteBuffer byteBuffer = new InputStreamByteBuffer(lineIteratorInputStream, this.getTracer());
                    HashMap<String, String> localBindings = new HashMap<String, String>();
                    localBindings.put("traceId", traceId);
                    localBindings.put("spanId", spanId);
                    Map<String, String> bindings = TemplateBindingsProvider.compose(this.templateBindingsProvider, localBindings).getBindings();
                    String logsVisualizationUrl = this.buildLogsVisualizationUrlTemplate.make(bindings).toString();
                    logsQueryResult = new LogsQueryResult(byteBuffer, new LogsViewHeader(bindings.get("backendName"), logsVisualizationUrl, bindings.get("backend24x24IconUrl")), charset, complete);
                    if (scope == null) break block9;
                }
                catch (Throwable throwable) {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                scope.close();
            }
            return logsQueryResult;
        }
        finally {
            span.end();
        }
    }

    public List<FormValidation> checkElasticsearchSetup() {
        GetLifecycleResponse getLifecycleResponse;
        boolean indexTemplateExists;
        String elasticsearchUsername;
        ArrayList<FormValidation> validations = new ArrayList<FormValidation>();
        ElasticsearchIndicesClient indicesClient = this.esClient.indices();
        try {
            elasticsearchUsername = Optional.ofNullable(this.elasticsearchCredentials.getUserPrincipal()).map(Principal::getName).orElse("No username for credentials type " + this.elasticsearchCredentials.getClass().getSimpleName());
        }
        catch (CredentialsNotFoundException e) {
            validations.add(FormValidation.error((String)"No credentials defined"));
            return validations;
        }
        validations.add(FormValidation.ok((String)"Verify existence of the Elasticsearch Index Template 'logs-apm.app' used to store Jenkins pipeline logs..."));
        try {
            indexTemplateExists = indicesClient.existsIndexTemplate(b -> b.name("logs-apm.app")).value();
        }
        catch (ElasticsearchException e) {
            ErrorCause errorCause = e.error();
            int status = e.status();
            if ("security_exception".equals(errorCause.type())) {
                if (status == 401) {
                    validations.add(FormValidation.error((String)("Authentication failure /" + status + " accessing Elasticsearch " + this.elasticsearchUrl + " with user '" + elasticsearchUsername + "'."), (Object[])new Object[]{e}));
                } else if (status == 403) {
                    validations.add(FormValidation.ok((String)("Connected to Elasticsearch " + this.elasticsearchUrl + " with user '" + elasticsearchUsername + "'.")));
                    validations.add(FormValidation.warning((String)(errorCause.type() + "/" + status + " accessing index template 'logs-apm.app' on '" + this.elasticsearchUrl + "'. Elasticsearch user '" + elasticsearchUsername + "' doesn't have read permission to the index template metadata - " + errorCause.reason() + ".")));
                } else {
                    validations.add(FormValidation.ok((String)("Connected to Elasticsearch " + this.elasticsearchUrl + " with user '" + elasticsearchUsername + "'.")));
                    validations.add(FormValidation.warning((String)(errorCause.type() + "/" + status + " accessing index template 'logs-apm.app' on '" + this.elasticsearchUrl + "' with Elasticsearch user '" + elasticsearchUsername + "' - " + errorCause.reason() + ".")));
                }
            } else {
                validations.add(FormValidation.warning((String)(errorCause.type() + "/" + status + " accessing index template 'logs-apm.app' on '" + this.elasticsearchUrl + "' with Elasticsearch user '" + elasticsearchUsername + "' - " + errorCause.reason() + ".")));
            }
            return validations;
        }
        catch (IOException e) {
            validations.add(FormValidation.warning((String)("Exception accessing Elasticsearch " + this.elasticsearchUrl + " with user '" + elasticsearchUsername + "'."), (Object[])new Object[]{e}));
            return validations;
        }
        validations.add(FormValidation.ok((String)("Connected to Elasticsearch " + this.elasticsearchUrl + " with user '" + elasticsearchUsername + "'.")));
        if (indexTemplateExists) {
            validations.add(FormValidation.ok((String)"Index Template 'logs-apm.app' found."));
        } else {
            validations.add(FormValidation.warning((String)"Index Template 'logs-apm.app' NOT found."));
        }
        validations.add(FormValidation.ok((String)"Verify existence of the Index Lifecycle Management (ILM) Policy 'logs-apm.app' associated with the Index Template 'logs-apm.app' to define the time to live of the Jenkins pipeline logs in Elasticsearch..."));
        try {
            getLifecycleResponse = this.esClient.ilm().getLifecycle(b -> b.name("logs-apm.app_logs-default_policy"));
        }
        catch (ElasticsearchException e) {
            ErrorCause errorCause = e.error();
            int status = e.status();
            if ("security_exception".equals(errorCause.type())) {
                if (status == 401) {
                    validations.add(FormValidation.error((String)("Authentication failure /" + status + " accessing Elasticsearch " + this.elasticsearchUrl + " with user '" + elasticsearchUsername + "'."), (Object[])new Object[]{e}));
                } else if (status == 403) {
                    validations.add(FormValidation.ok((String)("Time to live of the pipeline logs in Elasticsearch " + this.elasticsearchUrl + "not available. The Index Lifecycle Management (ILM) policy 'logs-apm.app_logs-default_policy' is not readable by the Elasticsearch user '" + elasticsearchUsername + ".  Details: " + errorCause.type() + " - " + errorCause.reason() + ".")));
                } else {
                    validations.add(FormValidation.warning((String)(errorCause.type() + "/" + status + " accessing lifecycle policy 'logs-apm.app_logs-default_policy': " + errorCause.reason() + ".")));
                }
            } else {
                validations.add(FormValidation.warning((String)(errorCause.type() + "/" + status + " accessing lifecycle policy 'logs-apm.app_logs-default_policy': " + errorCause.reason() + ".")));
            }
            return validations;
        }
        catch (IOException e) {
            validations.add(FormValidation.warning((String)"Exception accessing lifecycle policy 'logs-apm.app_logs-default_policy'.", (Object[])new Object[]{e}));
            return validations;
        }
        Lifecycle lifecyclePolicy = getLifecycleResponse.get("logs-apm.app_logs-default_policy");
        if (lifecyclePolicy == null) {
            validations.add(FormValidation.warning((String)"Index Lifecycle Policy 'logs-apm.app_logs-default_policy' NOT found."));
        } else {
            validations.add(FormValidation.ok((String)"Index Lifecycle Policy 'logs-apm.app_logs-default_policy' found."));
            Phases phases = lifecyclePolicy.policy().phases();
            ArrayList<String> retentionPolicy = new ArrayList<String>();
            retentionPolicy.add(ElasticsearchLogStorageRetriever.prettyPrintPhaseRetentionPolicy(phases.hot(), "hot"));
            retentionPolicy.add(ElasticsearchLogStorageRetriever.prettyPrintPhaseRetentionPolicy(phases.warm(), "warm"));
            retentionPolicy.add(ElasticsearchLogStorageRetriever.prettyPrintPhaseRetentionPolicy(phases.cold(), "cold"));
            retentionPolicy.add(ElasticsearchLogStorageRetriever.prettyPrintPhaseRetentionPolicy(phases.delete(), "delete"));
            validations.add(FormValidation.ok((String)("Logs retention policy: " + String.join((CharSequence)", ", retentionPolicy) + ".")));
        }
        return validations;
    }

    @NonNull
    protected static String prettyPrintPhaseRetentionPolicy(Phase phase, String phaseName) {
        if (phase == null) {
            return phaseName + " [phase not defined]";
        }
        ArrayList<CallSite> retentionPolicySpec = new ArrayList<CallSite>();
        JsonValue actionsAsJson = phase.actions().toJson();
        JsonObject hotPhaseActions = actionsAsJson.asJsonObject();
        if (hotPhaseActions.containsKey((Object)"rollover")) {
            JsonObject rollOver = hotPhaseActions.getJsonObject("rollover");
            String maxSize = rollOver.getString("max_size", "not defined");
            String maxAge = Optional.ofNullable(rollOver.getString("max_age", null)).map(a -> Time.of(b -> b.time(a))).map(Time::time).orElse("Not defined");
            retentionPolicySpec.add((CallSite)((Object)("rollover[maxAge=" + maxAge + ", maxSize=" + maxSize + "]")));
        }
        if (hotPhaseActions.containsKey((Object)"delete")) {
            String minAge = phase.minAge().time();
            retentionPolicySpec.add((CallSite)((Object)("delete[min_age=" + minAge + "]")));
        }
        return phaseName + "[" + String.join((CharSequence)",", retentionPolicySpec) + "]";
    }

    @Override
    public void close() throws IOException {
        logger.log(Level.FINE, () -> "Shutdown Elasticsearch client...");
        this.elasticsearchTransport.close();
        this.restClient.close();
    }

    public String toString() {
        return "ElasticsearchLogStorageRetriever{elasticsearchUrl=" + this.elasticsearchUrl + "}";
    }

    private Tracer getTracer() {
        if (this._tracer == null) {
            this._tracer = OpenTelemetrySdkProvider.get().getTracer();
        }
        return this._tracer;
    }
}

