/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.backend.elastic;

import com.google.errorprone.annotations.MustBeClosed;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Describable;
import hudson.model.Descriptor;
import io.jenkins.plugins.opentelemetry.TemplateBindingsProvider;
import io.jenkins.plugins.opentelemetry.backend.ObservabilityBackend;
import io.jenkins.plugins.opentelemetry.job.log.LogStorageRetriever;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

public abstract class ElasticLogsBackend
extends AbstractDescribableImpl<ElasticLogsBackend>
implements Describable<ElasticLogsBackend>,
ExtensionPoint {
    private static final Logger logger = Logger.getLogger(ElasticLogsBackend.class.getName());
    private transient Template buildLogsVisualizationUrlGTemplate;

    @CheckForNull
    @MustBeClosed
    public abstract LogStorageRetriever newLogStorageRetriever(TemplateBindingsProvider var1);

    public Template getBuildLogsVisualizationMessageTemplate() {
        try {
            return new GStringTemplateEngine().createTemplate("View build logs in ${backendName}");
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public Template getBuildLogsVisualizationUrlTemplate() {
        if (this.buildLogsVisualizationUrlGTemplate == null) {
            try {
                Object kibanaSpaceBaseUrl = StringUtils.isBlank((String)this.getKibanaSpaceIdentifier()) ? "${kibanaBaseUrl}" : "${kibanaBaseUrl}/s/" + URLEncoder.encode(this.getKibanaSpaceIdentifier(), StandardCharsets.UTF_8.name());
                String urlTemplate = (String)kibanaSpaceBaseUrl + "/app/logs/stream?logPosition=(end:now,start:now-40d,streamLive:!f)&logFilter=(language:kuery,query:%27trace.id:${traceId}%27)&";
                GStringTemplateEngine gStringTemplateEngine = new GStringTemplateEngine();
                try {
                    this.buildLogsVisualizationUrlGTemplate = gStringTemplateEngine.createTemplate(urlTemplate);
                }
                catch (IOException | ClassNotFoundException e) {
                    logger.log(Level.WARNING, "Invalid build logs Visualisation URL Template '" + urlTemplate + "'", e);
                    this.buildLogsVisualizationUrlGTemplate = ObservabilityBackend.ERROR_TEMPLATE;
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.buildLogsVisualizationUrlGTemplate;
    }

    public Map<String, String> getOtelConfigurationProperties() {
        return Collections.singletonMap("otel.logs.exporter", "otlp");
    }

    private String getKibanaSpaceIdentifier() {
        return "";
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static DescriptorExtensionList<ElasticLogsBackend, Descriptor<ElasticLogsBackend>> all() {
        return Jenkins.get().getDescriptorList(ElasticLogsBackend.class);
    }

    public static abstract class DescriptorImpl
    extends Descriptor<ElasticLogsBackend> {
    }
}

