/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.backend;

import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.google.errorprone.annotations.MustBeClosed;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.lang.MissingPropertyException;
import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Describable;
import hudson.model.Descriptor;
import io.jenkins.plugins.opentelemetry.TemplateBindingsProvider;
import io.jenkins.plugins.opentelemetry.job.log.LogStorageRetriever;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.resources.Resource;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class ObservabilityBackend
implements Describable<ObservabilityBackend>,
ExtensionPoint,
TemplateBindingsProvider {
    private static final Logger LOGGER = Logger.getLogger(ObservabilityBackend.class.getName());
    public static final String ICONS_PREFIX = "plugin/opentelemetry/images/svgs/";
    private String name;
    private transient Template traceVisualisationUrlGTemplate;
    private transient Template metricsVisualizationUrlGTemplate;
    public static final Template ERROR_TEMPLATE;

    @CheckForNull
    public abstract String getTraceVisualisationUrlTemplate();

    @CheckForNull
    public abstract String getMetricsVisualizationUrlTemplate();

    @CheckForNull
    public abstract String getIconPath();

    @CheckForNull
    public abstract String getEnvVariableName();

    @CheckForNull
    public abstract String getDefaultName();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @CheckForNull
    @MustBeClosed
    public LogStorageRetriever newLogStorageRetriever(TemplateBindingsProvider templateBindingsProvider) {
        return null;
    }

    public abstract Map<String, Object> mergeBindings(Map<String, Object> var1);

    public String getName() {
        return Strings.isNullOrEmpty((String)this.name) ? this.getDefaultName() : this.name;
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    @CheckForNull
    public String getTraceVisualisationUrl(Map<String, Object> bindings) {
        if (Strings.isNullOrEmpty((String)this.getTraceVisualisationUrlTemplate())) {
            return null;
        }
        if (this.traceVisualisationUrlGTemplate == ERROR_TEMPLATE) {
            return null;
        }
        if (this.traceVisualisationUrlGTemplate == null) {
            GStringTemplateEngine gStringTemplateEngine = new GStringTemplateEngine();
            try {
                this.traceVisualisationUrlGTemplate = gStringTemplateEngine.createTemplate(this.getTraceVisualisationUrlTemplate());
            }
            catch (IOException | ClassNotFoundException e) {
                LOGGER.log(Level.WARNING, "Invalid Trace Visualisation URL Template '" + this.getTraceVisualisationUrlTemplate() + "'", e);
                this.traceVisualisationUrlGTemplate = ERROR_TEMPLATE;
            }
        }
        Map<String, Object> mergedBindings = this.mergeBindings(bindings);
        return this.traceVisualisationUrlGTemplate.make(mergedBindings).toString();
    }

    public String getMetricsVisualizationUrl(Resource resource) {
        if (Strings.isNullOrEmpty((String)this.getMetricsVisualizationUrlTemplate())) {
            return null;
        }
        if (this.metricsVisualizationUrlGTemplate == ERROR_TEMPLATE) {
            return null;
        }
        if (this.metricsVisualizationUrlGTemplate == null) {
            GStringTemplateEngine gStringTemplateEngine = new GStringTemplateEngine();
            try {
                this.metricsVisualizationUrlGTemplate = gStringTemplateEngine.createTemplate(this.getMetricsVisualizationUrlTemplate());
            }
            catch (IOException | ClassNotFoundException e) {
                LOGGER.log(Level.WARNING, "Invalid Metrics Visualisation URL Template '" + this.getMetricsVisualizationUrlTemplate() + "'", e);
                this.metricsVisualizationUrlGTemplate = ERROR_TEMPLATE;
            }
        }
        Map<String, String> resourceMap = resource.getAttributes().asMap().entrySet().stream().collect(Collectors.toMap(entry -> ((AttributeKey)entry.getKey()).getKey(), entry -> Objects.toString(entry.getValue())));
        Map<String, Object> mergedBindings = this.mergeBindings(Collections.singletonMap("resource", resourceMap));
        try {
            return this.metricsVisualizationUrlGTemplate.make(mergedBindings).toString();
        }
        catch (MissingPropertyException e) {
            this.metricsVisualizationUrlGTemplate = ERROR_TEMPLATE;
            LOGGER.log(Level.WARNING, "Failure to generate MetricsVisualizationUrl, missing binding for property '" + e.getProperty() + "' in template " + this.getMetricsVisualizationUrlTemplate());
            return null;
        }
    }

    @Override
    public abstract Map<String, String> getBindings();

    public Descriptor<ObservabilityBackend> getDescriptor() {
        return Jenkins.get().getDescriptorOrDie(this.getClass());
    }

    public static DescriptorExtensionList<ObservabilityBackend, ObservabilityBackendDescriptor> allDescriptors() {
        return Jenkins.get().getDescriptorList(ObservabilityBackend.class);
    }

    @NonNull
    public Map<String, String> getOtelConfigurationProperties() {
        return Collections.emptyMap();
    }

    static {
        try {
            ERROR_TEMPLATE = new GStringTemplateEngine().createTemplate("#ERROR#");
        }
        catch (Exception e) {
            throw new IllegalStateException("failure to create error template");
        }
    }

    public static abstract class ObservabilityBackendDescriptor
    extends Descriptor<ObservabilityBackend>
    implements Comparable<ObservabilityBackendDescriptor> {
        public int ordinal() {
            return 0;
        }

        @Override
        public int compareTo(ObservabilityBackendDescriptor o) {
            return ComparisonChain.start().compare(this.ordinal(), o.ordinal()).compare((Comparable)((Object)this.getDisplayName()), (Comparable)((Object)o.getDisplayName())).result();
        }
    }

    public static interface TemplateBindings {
        public static final String BACKEND_NAME = "backendName";
        public static final String BACKEND_24_24_ICON_URL = "backend24x24IconUrl";
    }
}

