/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.backend;

import com.google.errorprone.annotations.MustBeClosed;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.util.FormValidation;
import io.jenkins.plugins.opentelemetry.TemplateBindingsProvider;
import io.jenkins.plugins.opentelemetry.backend.ObservabilityBackend;
import io.jenkins.plugins.opentelemetry.backend.elastic.ElasticLogsBackend;
import io.jenkins.plugins.opentelemetry.job.log.LogStorageRetriever;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ElasticBackend
extends ObservabilityBackend
implements TemplateBindingsProvider {
    private static final Logger LOGGER = Logger.getLogger(ElasticBackend.class.getName());
    public static final String OTEL_ELASTIC_URL = "OTEL_ELASTIC_URL";
    public static final String DEFAULT_BACKEND_NAME = "Elastic Observability";
    public static final String DEFAULT_KIBANA_DASHBOARD_TITLE = "Jenkins Overview";
    public static final String DEFAULT_KIBANA_SPACE_IDENTIFIER = "";
    public static final String DEFAULT_KIBANA_DASHBOARD_QUERY_PARAMETERS = "title=${kibanaDashboardTitle}&_g=(filters:!(),refreshInterval:(pause:!t,value:0),time:(from:now-24h%2Fh,to:now))";
    private boolean displayKibanaDashboardLink;
    private String kibanaBaseUrl;
    private String kibanaSpaceIdentifier;
    private String kibanaDashboardTitle;
    private String kibanaDashboardUrlParameters;
    private ElasticLogsBackend elasticLogsBackend;

    @DataBoundConstructor
    public ElasticBackend() {
    }

    @Override
    public Map<String, Object> mergeBindings(Map<String, Object> bindings) {
        HashMap<String, Object> mergedBindings = new HashMap<String, Object>(bindings);
        mergedBindings.putAll(this.getBindings());
        return mergedBindings;
    }

    @Override
    public Map<String, String> getBindings() {
        LinkedHashMap<String, String> bindings = new LinkedHashMap<String, String>();
        bindings.put("backendName", this.getName());
        bindings.put("backend24x24IconUrl", "/plugin/opentelemetry/images/24x24/elastic.png");
        bindings.put("kibanaBaseUrl", this.getKibanaBaseUrl());
        bindings.put("kibanaDashboardTitle", this.kibanaDashboardTitle);
        bindings.put("kibanaSpaceIdentifier", this.kibanaSpaceIdentifier);
        return bindings;
    }

    @Override
    @CheckForNull
    public String getTraceVisualisationUrlTemplate() {
        return "${kibanaBaseUrl}/app/apm/services/${serviceName}/transactions/view?rangeFrom=${startTime.minusSeconds(600)}&rangeTo=${startTime.plusSeconds(600)}&transactionName=${rootSpanName}&transactionType=job&latencyAggregationType=avg&traceId=${traceId}&transactionId=${spanId}";
    }

    public String getKibanaBaseUrl() {
        if (this.kibanaBaseUrl != null && this.kibanaBaseUrl.endsWith("/")) {
            this.kibanaBaseUrl = this.kibanaBaseUrl.substring(0, this.kibanaBaseUrl.length() - 1);
        }
        return this.kibanaBaseUrl;
    }

    @DataBoundSetter
    public void setKibanaBaseUrl(String kibanaBaseUrl) {
        this.kibanaBaseUrl = kibanaBaseUrl;
    }

    @Override
    @CheckForNull
    public String getIconPath() {
        return "icon-otel-elastic";
    }

    @Override
    @CheckForNull
    public String getEnvVariableName() {
        return OTEL_ELASTIC_URL;
    }

    @Override
    @CheckForNull
    public String getDefaultName() {
        return DEFAULT_BACKEND_NAME;
    }

    @Override
    @CheckForNull
    public String getMetricsVisualizationUrlTemplate() {
        if (!this.displayKibanaDashboardLink) {
            return null;
        }
        try {
            Object kibanaSpaceBaseUrl = StringUtils.isBlank((String)this.getKibanaSpaceIdentifier()) ? "${kibanaBaseUrl}" : "${kibanaBaseUrl}/s/" + URLEncoder.encode(this.getKibanaSpaceIdentifier(), StandardCharsets.UTF_8.name());
            return (String)kibanaSpaceBaseUrl + "/app/kibana#/dashboards?title=" + URLEncoder.encode(this.getKibanaDashboardTitle(), StandardCharsets.UTF_8.name()) + "&_g=(filters:!(),refreshInterval:(pause:!t,value:0),time:(from:now-24h%2Fh,to:now))";
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.INFO, "Exception formatting Kibana URL with kibanaSpaceIdentifier=" + this.getKibanaSpaceIdentifier() + ", kibanaDashboardName=" + this.getKibanaDashboardTitle() + ": " + e);
            return null;
        }
    }

    public ElasticLogsBackend getElasticLogsBackend() {
        return this.elasticLogsBackend;
    }

    @DataBoundSetter
    public void setElasticLogsBackend(ElasticLogsBackend elasticLogsBackend) {
        this.elasticLogsBackend = elasticLogsBackend;
    }

    @Override
    @Nullable
    @MustBeClosed
    public LogStorageRetriever newLogStorageRetriever(TemplateBindingsProvider templateBindingsProvider) {
        if (this.elasticLogsBackend == null) {
            return null;
        }
        return this.elasticLogsBackend.newLogStorageRetriever(templateBindingsProvider);
    }

    @Override
    public Map<String, String> getOtelConfigurationProperties() {
        if (this.elasticLogsBackend == null) {
            return Collections.emptyMap();
        }
        return this.elasticLogsBackend.getOtelConfigurationProperties();
    }

    public String getKibanaSpaceIdentifier() {
        return Objects.toString(this.kibanaSpaceIdentifier, DEFAULT_KIBANA_SPACE_IDENTIFIER);
    }

    @DataBoundSetter
    public void setKibanaSpaceIdentifier(String kibanaSpaceIdentifier) {
        this.kibanaSpaceIdentifier = kibanaSpaceIdentifier;
    }

    public String getKibanaDashboardTitle() {
        return Objects.toString(this.kibanaDashboardTitle, DEFAULT_KIBANA_DASHBOARD_TITLE);
    }

    @DataBoundSetter
    public void setKibanaDashboardTitle(String kibanaDashboardTitle) {
        this.kibanaDashboardTitle = kibanaDashboardTitle;
    }

    public String getKibanaDashboardUrlParameters() {
        return Objects.toString(this.kibanaDashboardUrlParameters, DEFAULT_KIBANA_DASHBOARD_QUERY_PARAMETERS);
    }

    @DataBoundSetter
    public void setKibanaDashboardUrlParameters(String kibanaDashboardUrlParameters) {
        this.kibanaDashboardUrlParameters = kibanaDashboardUrlParameters;
    }

    public boolean isDisplayKibanaDashboardLink() {
        return this.displayKibanaDashboardLink;
    }

    @DataBoundSetter
    public void setDisplayKibanaDashboardLink(boolean displayKibanaDashboardLink) {
        this.displayKibanaDashboardLink = displayKibanaDashboardLink;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElasticBackend that = (ElasticBackend)o;
        return this.displayKibanaDashboardLink == that.displayKibanaDashboardLink && Objects.equals(this.kibanaBaseUrl, that.kibanaBaseUrl) && Objects.equals(this.kibanaSpaceIdentifier, that.kibanaSpaceIdentifier) && Objects.equals(this.kibanaDashboardTitle, that.kibanaDashboardTitle) && Objects.equals(this.kibanaDashboardUrlParameters, that.kibanaDashboardUrlParameters) && Objects.equals((Object)this.elasticLogsBackend, (Object)that.elasticLogsBackend);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.displayKibanaDashboardLink, this.kibanaBaseUrl, this.kibanaSpaceIdentifier, this.kibanaDashboardTitle, this.kibanaDashboardUrlParameters, this.elasticLogsBackend});
    }

    static {
        IconSet.icons.addIcon(new Icon("icon-otel-elastic icon-sm", "plugin/opentelemetry/images/svgs/elastic.svg", "width: 16px; height: 16px;"));
        IconSet.icons.addIcon(new Icon("icon-otel-elastic icon-md", "plugin/opentelemetry/images/svgs/elastic.svg", "width: 24px; height: 24px;"));
        IconSet.icons.addIcon(new Icon("icon-otel-elastic icon-lg", "plugin/opentelemetry/images/svgs/elastic.svg", "width: 32px; height: 32px;"));
        IconSet.icons.addIcon(new Icon("icon-otel-elastic icon-xlg", "plugin/opentelemetry/images/svgs/elastic.svg", "width: 48px; height: 48px;"));
    }

    public static interface TemplateBindings
    extends ObservabilityBackend.TemplateBindings {
        public static final String KIBANA_BASE_URL = "kibanaBaseUrl";
        public static final String KIBANA_DASHBOARD_TITLE = "kibanaDashboardTitle";
        public static final String KIBANA_SPACE_IDENTIFIER = "kibanaSpaceIdentifier";
    }

    @Extension
    @Symbol(value={"elastic"})
    public static class DescriptorImpl
    extends ObservabilityBackend.ObservabilityBackendDescriptor {
        public String getDisplayName() {
            return ElasticBackend.DEFAULT_BACKEND_NAME;
        }

        public String getDefaultKibanaDashboardUrlParameters() {
            return ElasticBackend.DEFAULT_KIBANA_DASHBOARD_QUERY_PARAMETERS;
        }

        public String getDefaultKibanaDashboardTitle() {
            return ElasticBackend.DEFAULT_KIBANA_DASHBOARD_TITLE;
        }

        public String getDefaultKibanaSpaceIdentifier() {
            return ElasticBackend.DEFAULT_KIBANA_SPACE_IDENTIFIER;
        }

        public FormValidation doCheckKibanaBaseUrl(@QueryParameter(value="kibanaBaseUrl") String kibanaBaseUrl) {
            if (StringUtils.isEmpty((String)kibanaBaseUrl)) {
                return FormValidation.ok();
            }
            try {
                new URL(kibanaBaseUrl);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)("Invalid URL: " + e.getMessage()));
            }
            return FormValidation.ok();
        }
    }
}

