/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.backend;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import io.jenkins.plugins.opentelemetry.backend.ObservabilityBackend;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DynatraceBackend
extends ObservabilityBackend {
    public static final String OTEL_DYNATRACE_URL = "OTEL_DYNATRACE_URL";
    public static final String DEFAULT_NAME = "Dynatrace";
    private final String url;
    private String managementZoneId;
    private String dashboardId;
    private String dashboardTimeRange;

    @DataBoundConstructor
    public DynatraceBackend(String url) {
        if (url != null && !((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        this.url = url;
    }

    public String getManagementZoneId() {
        return this.managementZoneId;
    }

    @DataBoundSetter
    public void setManagementZoneId(String managementZoneId) {
        this.managementZoneId = managementZoneId;
    }

    public String getDashboardId() {
        return this.dashboardId;
    }

    @DataBoundSetter
    public void setDashboardId(String dashboardId) {
        this.dashboardId = dashboardId;
    }

    public String getDashboardTimeRange() {
        return this.dashboardTimeRange;
    }

    @DataBoundSetter
    public void setDashboardTimeRange(String dashboardTimeRange) {
        this.dashboardTimeRange = dashboardTimeRange;
    }

    @Override
    public Map<String, Object> mergeBindings(Map<String, Object> bindings) {
        HashMap<String, Object> mergedBindings = new HashMap<String, Object>(bindings);
        mergedBindings.put("dynatraceBaseUrl", this.url);
        String zoneId = Util.fixEmpty((String)this.getManagementZoneId()) != null ? this.getManagementZoneId() : "all";
        mergedBindings.put("managementZoneId", zoneId);
        mergedBindings.put("dashboardId", Util.fixEmpty((String)this.dashboardId));
        String timeRange = Util.fixEmpty((String)this.getDashboardTimeRange()) != null ? this.getDashboardTimeRange() : "today";
        mergedBindings.put("dashboardTimeRange", Util.fixEmpty((String)timeRange));
        return mergedBindings;
    }

    @Override
    @NonNull
    public String getTraceVisualisationUrlTemplate() {
        return "${dynatraceBaseUrl}#trace;gf=${managementZoneId};traceId=${traceId}";
    }

    @Override
    @CheckForNull
    public String getMetricsVisualizationUrlTemplate() {
        if (Util.fixEmpty((String)this.getDashboardId()) == null) {
            return null;
        }
        return "${dynatraceBaseUrl}#dashboard;id=${dashboardId};gf=${managementZoneId};gtf=${dashboardTimeRange}";
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    @NonNull
    public String getIconPath() {
        return "icon-otel-dynatrace";
    }

    @Override
    @NonNull
    public String getEnvVariableName() {
        return OTEL_DYNATRACE_URL;
    }

    @Override
    @NonNull
    public String getDefaultName() {
        return DEFAULT_NAME;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynatraceBackend that = (DynatraceBackend)o;
        return Objects.equals(this.url, that.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.url);
    }

    @Override
    public Map<String, String> getBindings() {
        LinkedHashMap<String, String> bindings = new LinkedHashMap<String, String>();
        bindings.put("backendName", this.getName());
        bindings.put("backend24x24IconUrl", "/plugin/opentelemetry/images/svgs/dynatrace.svg");
        return bindings;
    }

    static {
        IconSet.icons.addIcon(new Icon("icon-otel-dynatrace icon-sm", "plugin/opentelemetry/images/svgs/dynatrace.svg", "width: 16px; height: 16px;"));
        IconSet.icons.addIcon(new Icon("icon-otel-dynatrace icon-md", "plugin/opentelemetry/images/svgs/dynatrace.svg", "width: 24px; height: 24px;"));
        IconSet.icons.addIcon(new Icon("icon-otel-dynatrace icon-lg", "plugin/opentelemetry/images/svgs/dynatrace.svg", "width: 32px; height: 32px;"));
        IconSet.icons.addIcon(new Icon("icon-otel-dynatrace icon-xlg", "plugin/opentelemetry/images/svgs/dynatrace.svg", "width: 48px; height: 48px;"));
    }

    @Extension
    @Symbol(value={"dynatrace"})
    public static class DescriptorImpl
    extends ObservabilityBackend.ObservabilityBackendDescriptor {
        @NonNull
        public String getDisplayName() {
            return DynatraceBackend.DEFAULT_NAME;
        }
    }
}

