/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.administrativemonitor;

import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import io.jenkins.plugins.opentelemetry.JenkinsOpenTelemetryPluginConfiguration;
import io.jenkins.plugins.opentelemetry.backend.ElasticBackend;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class ElasticBackendDashboardNotEnabledAdministrativeMonitor
extends AdministrativeMonitor {
    private JenkinsOpenTelemetryPluginConfiguration pluginConfiguration;

    public String getDisplayName() {
        return "OpenTelemetry - Elastic - Kibana dashboard link not enabled";
    }

    public boolean isActivated() {
        return this.pluginConfiguration.getObservabilityBackends().stream().filter(backend -> backend instanceof ElasticBackend).map(backend -> (ElasticBackend)backend).filter(backend -> StringUtils.isNotEmpty((String)backend.getKibanaBaseUrl())).anyMatch(elasticBackend -> !elasticBackend.isDisplayKibanaDashboardLink());
    }

    @RequirePOST
    public HttpResponse doAct(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (req.hasParameter("no")) {
            this.disable(true);
        }
        return HttpResponses.redirectViaContextPath((String)"/configure");
    }

    @Inject
    public void setJenkinsOpenTelemetryPluginConfiguration(JenkinsOpenTelemetryPluginConfiguration jenkinsOpenTelemetryPluginConfiguration) {
        this.pluginConfiguration = jenkinsOpenTelemetryPluginConfiguration;
    }
}

