/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.events.EventEmitter;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;

public interface OtelComponent
extends Comparable<OtelComponent> {
    default public void afterSdkInitialized(Meter meter, LoggerProvider loggerProvider, EventEmitter eventEmitter, Tracer tracer, ConfigProperties configProperties) {
    }

    default public void afterSdkInitialized(OpenTelemetry openTelemetry, ConfigProperties configProperties) {
    }

    default public void beforeSdkShutdown() {
    }

    default public int ordinal() {
        return 0;
    }

    @Override
    default public int compareTo(OtelComponent other) {
        if (this.ordinal() == other.ordinal()) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        return Integer.compare(this.ordinal(), other.ordinal());
    }
}

