/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry;

import com.google.common.base.Strings;
import com.google.errorprone.annotations.MustBeClosed;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import groovy.text.GStringTemplateEngine;
import hudson.Extension;
import hudson.PluginWrapper;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.tasks.BuildStep;
import hudson.util.FormValidation;
import io.jenkins.plugins.opentelemetry.OpenTelemetryConfiguration;
import io.jenkins.plugins.opentelemetry.OpenTelemetrySdkProvider;
import io.jenkins.plugins.opentelemetry.OtelUtils;
import io.jenkins.plugins.opentelemetry.TemplateBindingsProvider;
import io.jenkins.plugins.opentelemetry.authentication.NoAuthentication;
import io.jenkins.plugins.opentelemetry.authentication.OtlpAuthentication;
import io.jenkins.plugins.opentelemetry.backend.ObservabilityBackend;
import io.jenkins.plugins.opentelemetry.backend.custom.CustomLogStorageRetriever;
import io.jenkins.plugins.opentelemetry.job.log.LogStorageRetriever;
import io.jenkins.plugins.opentelemetry.opentelemetry.autoconfigure.ConfigPropertiesUtils;
import io.jenkins.plugins.opentelemetry.semconv.JenkinsOtelSemanticAttributes;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import jenkins.model.CauseOfInterruption;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import net.jcip.annotations.Immutable;
import net.sf.json.JSONObject;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.structs.SymbolLookup;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.actions.ArgumentsAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.CoreStep;
import org.jenkinsci.plugins.workflow.support.steps.StageStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
@Symbol(value={"openTelemetry"})
public class JenkinsOpenTelemetryPluginConfiguration
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(JenkinsOpenTelemetryPluginConfiguration.class.getName());
    private String endpoint;
    private String trustedCertificatesPem;
    private OtlpAuthentication authentication;
    private List<ObservabilityBackend> observabilityBackends = new ArrayList<ObservabilityBackend>();
    private Integer exporterTimeoutMillis = null;
    private Integer exporterIntervalMillis = null;
    private String ignoredSteps = "dir,echo,isUnix,pwd,properties";
    private String disabledResourceProviders = OpenTelemetrySdkProvider.DEFAULT_OTEL_JAVA_DISABLED_RESOURCE_PROVIDERS;
    private transient OpenTelemetrySdkProvider openTelemetrySdkProvider;
    private transient LogStorageRetriever logStorageRetriever;
    private boolean exportOtelConfigurationAsEnvironmentVariables;
    private transient ConcurrentMap<String, StepPlugin> loadedStepsPlugins = new ConcurrentHashMap<String, StepPlugin>();
    private String configurationProperties;
    private String serviceName;
    private String serviceNamespace;
    private List<String> statusUnsetCausesOfInterruption = Arrays.asList("org.jenkinsci.plugins.workflow.cps.steps.ParallelStep$FailFastCause", StageStepExecution.CanceledCause.class.getName(), CauseOfInterruption.UserInterruption.class.getName());
    protected transient OpenTelemetryConfiguration currentOpenTelemetryConfiguration;
    private JenkinsLocationConfiguration jenkinsLocationConfiguration;

    @DataBoundConstructor
    public JenkinsOpenTelemetryPluginConfiguration() {
        this.load();
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        LOGGER.log(Level.FINE, "Configure...");
        req.bindJSON((Object)this, json);
        this.observabilityBackends = req.bindJSONToList(ObservabilityBackend.class, json.get("observabilityBackends"));
        this.endpoint = this.sanitizeOtlpEndpoint(this.endpoint);
        this.initializeOpenTelemetry();
        this.save();
        LOGGER.log(Level.FINE, "Configured");
        return true;
    }

    protected Object readResolve() {
        LOGGER.log(Level.FINE, "readResolve()");
        if (this.disabledResourceProviders == null) {
            this.disabledResourceProviders = OpenTelemetrySdkProvider.DEFAULT_OTEL_JAVA_DISABLED_RESOURCE_PROVIDERS;
        }
        return this;
    }

    @NonNull
    public OpenTelemetryConfiguration toOpenTelemetryConfiguration() {
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(Objects.toString(this.configurationProperties)));
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Exception parsing configuration properties", e);
        }
        HashMap<String, String> configurationProperties = new HashMap<String, String>();
        this.getObservabilityBackends().forEach(backend -> configurationProperties.putAll(backend.getOtelConfigurationProperties()));
        configurationProperties.put(JenkinsOtelSemanticAttributes.JENKINS_VERSION.getKey(), OtelUtils.getJenkinsVersion());
        configurationProperties.put(JenkinsOtelSemanticAttributes.JENKINS_URL.getKey(), this.jenkinsLocationConfiguration.getUrl());
        configurationProperties.put(ResourceAttributes.SERVICE_INSTANCE_ID.getKey(), Jenkins.get().getLegacyInstanceId());
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> configurationProperties.put(Objects.toString(k, "#null#"), Objects.toString(v, "#null#"))));
        return new OpenTelemetryConfiguration(Optional.ofNullable(this.getEndpoint()), Optional.ofNullable(this.getTrustedCertificatesPem()), Optional.ofNullable(this.getAuthentication()), Optional.ofNullable(this.getExporterTimeoutMillis()), Optional.ofNullable(this.getExporterIntervalMillis()), Optional.ofNullable(this.getServiceName()), Optional.ofNullable(this.getServiceNamespace()), Optional.ofNullable(this.getDisabledResourceProviders()), configurationProperties);
    }

    @Initializer(after=InitMilestone.SYSTEM_CONFIG_ADAPTED, before=InitMilestone.JOB_LOADED)
    public void initializeOpenTelemetry() {
        LOGGER.log(Level.FINE, "Initialize Jenkins OpenTelemetry Plugin...");
        OpenTelemetryConfiguration newOpenTelemetryConfiguration = this.toOpenTelemetryConfiguration();
        if (Objects.equals(this.currentOpenTelemetryConfiguration, newOpenTelemetryConfiguration)) {
            LOGGER.log(Level.FINE, "Configuration didn't change, skip reconfiguration");
        } else {
            this.openTelemetrySdkProvider.initialize(newOpenTelemetryConfiguration);
            this.currentOpenTelemetryConfiguration = newOpenTelemetryConfiguration;
        }
        if (this.logStorageRetriever != null && this.logStorageRetriever instanceof Closeable) {
            LOGGER.log(Level.FINE, () -> "Close " + this.logStorageRetriever + "...");
            try {
                ((Closeable)((Object)this.logStorageRetriever)).close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Exception closing currently setup logStorageRetriever: " + this.logStorageRetriever, e);
            }
        }
        this.logStorageRetriever = this.resolveLogStorageRetriever();
    }

    @CheckForNull
    public String sanitizeOtlpEndpoint(@Nullable String grpcEndpoint) {
        if (Strings.isNullOrEmpty((String)grpcEndpoint)) {
            return null;
        }
        if (grpcEndpoint.contains("://")) {
            return grpcEndpoint;
        }
        return "http://" + grpcEndpoint;
    }

    @CheckForNull
    public String getEndpoint() {
        return this.sanitizeOtlpEndpoint(this.endpoint);
    }

    @DataBoundSetter
    public void setEndpoint(String endpoint) {
        this.endpoint = this.sanitizeOtlpEndpoint(endpoint);
        LOGGER.log(Level.FINE, () -> "setEndpoint(" + endpoint + ")");
    }

    @NonNull
    public OtlpAuthentication getAuthentication() {
        return this.authentication == null ? new NoAuthentication() : this.authentication;
    }

    @DataBoundSetter
    public void setAuthentication(OtlpAuthentication authentication) {
        this.authentication = authentication;
    }

    @CheckForNull
    public String getTrustedCertificatesPem() {
        return this.trustedCertificatesPem;
    }

    @DataBoundSetter
    public void setTrustedCertificatesPem(String trustedCertificatesPem) {
        this.trustedCertificatesPem = trustedCertificatesPem;
    }

    @DataBoundSetter
    public void setObservabilityBackends(List<ObservabilityBackend> observabilityBackends) {
        this.observabilityBackends = observabilityBackends == null ? Collections.emptyList() : observabilityBackends;
    }

    @NonNull
    public List<ObservabilityBackend> getObservabilityBackends() {
        if (this.observabilityBackends == null) {
            this.observabilityBackends = new ArrayList<ObservabilityBackend>();
        }
        return this.observabilityBackends;
    }

    @Inject
    public void setOpenTelemetrySdkProvider(OpenTelemetrySdkProvider openTelemetrySdkProvider) {
        this.openTelemetrySdkProvider = openTelemetrySdkProvider;
    }

    public Integer getExporterTimeoutMillis() {
        return this.exporterTimeoutMillis;
    }

    @DataBoundSetter
    public void setExporterTimeoutMillis(Integer exporterTimeoutMillis) {
        this.exporterTimeoutMillis = exporterTimeoutMillis;
    }

    public Integer getExporterIntervalMillis() {
        return this.exporterIntervalMillis;
    }

    @DataBoundSetter
    public void setExporterIntervalMillis(Integer exporterIntervalMillis) {
        this.exporterIntervalMillis = exporterIntervalMillis;
    }

    public String getIgnoredSteps() {
        return this.ignoredSteps;
    }

    @DataBoundSetter
    public void setIgnoredSteps(String ignoredSteps) {
        this.ignoredSteps = ignoredSteps;
    }

    public List<String> getStatusUnsetCausesOfInterruption() {
        return this.statusUnsetCausesOfInterruption;
    }

    public String getDisabledResourceProviders() {
        return this.disabledResourceProviders;
    }

    @DataBoundSetter
    public void setDisabledResourceProviders(String disabledResourceProviders) {
        this.disabledResourceProviders = disabledResourceProviders;
    }

    public boolean isExportOtelConfigurationAsEnvironmentVariables() {
        return this.exportOtelConfigurationAsEnvironmentVariables;
    }

    @DataBoundSetter
    public void setExportOtelConfigurationAsEnvironmentVariables(boolean exportOtelConfigurationAsEnvironmentVariables) {
        this.exportOtelConfigurationAsEnvironmentVariables = exportOtelConfigurationAsEnvironmentVariables;
    }

    public String getConfigurationProperties() {
        return this.configurationProperties;
    }

    @DataBoundSetter
    public void setConfigurationProperties(String configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    @NonNull
    public Map<String, String> getOtelConfigurationAsEnvironmentVariables() {
        if (this.endpoint == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> environmentVariables = new HashMap<String, String>();
        environmentVariables.put("OTEL_TRACES_EXPORTER", "otlp");
        environmentVariables.put("OTEL_EXPORTER_OTLP_ENDPOINT", this.endpoint);
        String sanitizeOtlpEndpoint = this.sanitizeOtlpEndpoint(this.endpoint);
        if (sanitizeOtlpEndpoint != null && sanitizeOtlpEndpoint.startsWith("http://")) {
            environmentVariables.put("OTEL_EXPORTER_OTLP_INSECURE", Boolean.TRUE.toString());
        }
        this.authentication.enrichOtelEnvironmentVariables(environmentVariables);
        String trustedCertificatesPem = this.getTrustedCertificatesPem();
        if (trustedCertificatesPem != null && !trustedCertificatesPem.isEmpty()) {
            environmentVariables.put("OTEL_EXPORTER_OTLP_CERTIFICATE", trustedCertificatesPem);
        }
        if (this.exporterTimeoutMillis != null) {
            environmentVariables.put("OTEL_EXPORTER_OTLP_TIMEOUT", Integer.toString(this.exporterTimeoutMillis));
        }
        return environmentVariables;
    }

    @Inject
    public void setJenkinsLocationConfiguration(@NonNull JenkinsLocationConfiguration jenkinsLocationConfiguration) {
        this.jenkinsLocationConfiguration = jenkinsLocationConfiguration;
    }

    @NonNull
    public String getVisualisationObservabilityBackendsString() {
        return "Visualisation observability backends: " + ObservabilityBackend.allDescriptors().stream().sorted().map(d -> d.getDisplayName()).collect(Collectors.joining(", "));
    }

    @NonNull
    public ConcurrentMap<String, StepPlugin> getLoadedStepsPlugins() {
        return this.loadedStepsPlugins;
    }

    public void addStepPlugin(String stepName, StepPlugin c) {
        this.loadedStepsPlugins.put(stepName, c);
    }

    @Nullable
    private Descriptor<? extends Describable> getStepDescriptor(@NonNull FlowNode node, @Nullable Descriptor<? extends Describable> descriptor) {
        UninstantiatedDescribable describable;
        Map arguments;
        if (descriptor instanceof CoreStep.DescriptorImpl && (arguments = ArgumentsAction.getFilteredArguments((FlowNode)node)).get("delegate") instanceof UninstantiatedDescribable && (describable = (UninstantiatedDescribable)arguments.get("delegate")) != null) {
            return SymbolLookup.get().findDescriptor(Describable.class, describable.getSymbol());
        }
        return descriptor;
    }

    @Nullable
    private Descriptor<? extends Describable> getBuildStepDescriptor(@NonNull BuildStep buildStep) {
        return Jenkins.get().getDescriptor(buildStep.getClass());
    }

    @NonNull
    public StepPlugin findStepPluginOrDefault(@NonNull String buildStepName, @NonNull BuildStep buildStep) {
        return this.findStepPluginOrDefault(buildStepName, this.getBuildStepDescriptor(buildStep));
    }

    @NonNull
    public StepPlugin findStepPluginOrDefault(@NonNull String stepName, @NonNull StepAtomNode node) {
        return this.findStepPluginOrDefault(stepName, this.getStepDescriptor((FlowNode)node, (Descriptor<? extends Describable>)node.getDescriptor()));
    }

    @NonNull
    public StepPlugin findStepPluginOrDefault(@NonNull String stepName, @NonNull StepStartNode node) {
        return this.findStepPluginOrDefault(stepName, this.getStepDescriptor((FlowNode)node, (Descriptor<? extends Describable>)node.getDescriptor()));
    }

    @NonNull
    public StepPlugin findStepPluginOrDefault(@NonNull String stepName, @Nullable Descriptor<? extends Describable> descriptor) {
        PluginWrapper wrapper;
        StepPlugin data = (StepPlugin)this.loadedStepsPlugins.get(stepName);
        if (data != null) {
            LOGGER.log(Level.FINEST, " found the plugin for the step '" + stepName + "' - " + data);
            return data;
        }
        data = new StepPlugin();
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null && descriptor != null && (wrapper = jenkins.getPluginManager().whichPlugin(descriptor.clazz)) != null) {
            data = new StepPlugin(wrapper.getShortName(), wrapper.getVersion());
            this.addStepPlugin(stepName, data);
        }
        return data;
    }

    @NonNull
    public String findSymbolOrDefault(@NonNull String buildStepName, @NonNull BuildStep buildStep) {
        return this.findSymbolOrDefault(buildStepName, this.getBuildStepDescriptor(buildStep));
    }

    @NonNull
    public String findSymbolOrDefault(@NonNull String buildStepName, @Nullable Descriptor<? extends Describable> descriptor) {
        String value = buildStepName;
        if (descriptor != null) {
            Set values = SymbolLookup.getSymbolValue(descriptor);
            value = values.stream().findFirst().orElse(buildStepName);
        }
        return value;
    }

    public String getServiceName() {
        return Strings.isNullOrEmpty((String)this.serviceName) ? "jenkins" : this.serviceName;
    }

    @DataBoundSetter
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceNamespace() {
        return Strings.isNullOrEmpty((String)this.serviceNamespace) ? "jenkins" : this.serviceNamespace;
    }

    @DataBoundSetter
    public void setServiceNamespace(String serviceNamespace) {
        this.serviceNamespace = serviceNamespace;
    }

    @NonNull
    public Resource getResource() {
        if (this.openTelemetrySdkProvider == null) {
            return Resource.empty();
        }
        return this.openTelemetrySdkProvider.getResource();
    }

    @NonNull
    public String getResourceAsText() {
        return this.getResource().getAttributes().asMap().entrySet().stream().map(e -> e.getKey() + "=" + e.getValue()).collect(Collectors.joining("\r\n"));
    }

    @NonNull
    public ConfigProperties getConfigProperties() {
        if (this.openTelemetrySdkProvider == null) {
            return ConfigPropertiesUtils.emptyConfig();
        }
        return this.openTelemetrySdkProvider.getConfig();
    }

    @NonNull
    public String getNoteworthyConfigPropertiesAsText() {
        return OtelUtils.noteworthyConfigProperties(this.getConfigProperties()).entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("\r\n"));
    }

    @NonNull
    public LogStorageRetriever getLogStorageRetriever() {
        if (this.logStorageRetriever == null) {
            throw new IllegalStateException("logStorageRetriever NOT loaded");
        }
        return this.logStorageRetriever;
    }

    @NonNull
    @MustBeClosed
    private LogStorageRetriever resolveLogStorageRetriever() {
        ObservabilityBackend templateBindingsProvider;
        ObservabilityBackend backend;
        LogStorageRetriever logStorageRetriever = null;
        Iterator<ObservabilityBackend> iterator = this.getObservabilityBackends().iterator();
        while (iterator.hasNext() && (logStorageRetriever = backend.newLogStorageRetriever(templateBindingsProvider = (backend = iterator.next()))) == null) {
        }
        if (logStorageRetriever == null) {
            try {
                logStorageRetriever = new CustomLogStorageRetriever(new GStringTemplateEngine().createTemplate("https://plugins.jenkins.io/opentelemetry/"), TemplateBindingsProvider.of("backendName", "See documentation on missing logs visualization URL", "backend24x24IconUrl", "/plugin/opentelemetry/svgs/opentelemetry.svg"));
            }
            catch (IOException | ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "resolveStorageRetriever: " + logStorageRetriever);
        }
        return logStorageRetriever;
    }

    public static JenkinsOpenTelemetryPluginConfiguration get() {
        return (JenkinsOpenTelemetryPluginConfiguration)((Object)GlobalConfiguration.all().get(JenkinsOpenTelemetryPluginConfiguration.class));
    }

    public FormValidation doCheckEndpoint(@QueryParameter String endpoint) {
        URL endpointAsUrl;
        if (endpoint == null || endpoint.isEmpty()) {
            return FormValidation.ok();
        }
        try {
            endpointAsUrl = new URL(endpoint);
        }
        catch (MalformedURLException e) {
            return FormValidation.error((String)("Invalid URL: " + e.getMessage() + "."));
        }
        if (!"http".equals(endpointAsUrl.getProtocol()) && !"https".equals(endpointAsUrl.getProtocol())) {
            return FormValidation.error((String)("Unsupported protocol '" + endpointAsUrl.getProtocol() + "'. Expect 'https' or 'http' protocol."));
        }
        List<String> localhosts = Arrays.asList("localhost", "127.0.0.1", "0:0:0:0:0:0:0:1");
        for (String localhost : localhosts) {
            if (!localhost.equals(endpointAsUrl.getHost())) continue;
            return FormValidation.warning((String)("The OTLP Endpoint URL is also used from the Jenkins agents when sending logs through OTLP. Identifying the OTLP endpoint with the `" + localhost + "` hostname is likely to not work from Jenkins agents."));
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckIgnoredSteps(@QueryParameter String ignoredSteps) {
        if (ignoredSteps.matches("[A-Za-z0-9,]*")) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)"Invalid format: \"%s\".", (Object[])new Object[]{ignoredSteps});
    }

    public FormValidation doCheckExportOtelConfigurationAsEnvironmentVariables(@QueryParameter String value) {
        if (value.equals("false")) {
            return FormValidation.ok();
        }
        return FormValidation.warning((String)"Note that OpenTelemetry credentials, if configured, will be exposed as environment variables (likely in OTEL_EXPORTER_OTLP_HEADERS)");
    }

    @PreDestroy
    public void preDestroy() throws Exception {
        if (this.logStorageRetriever != null) {
            LOGGER.log(Level.FINE, () -> "Close " + this.logStorageRetriever + "...");
            this.logStorageRetriever.close();
        }
    }

    static {
        IconSet.icons.addIcon(new Icon("icon-otel icon-sm", "plugin/opentelemetry/images/svgs/opentelemetry.svg", "width: 16px; height: 16px;"));
        IconSet.icons.addIcon(new Icon("icon-otel icon-md", "plugin/opentelemetry/images/svgs/opentelemetry.svg", "width: 24px; height: 24px;"));
        IconSet.icons.addIcon(new Icon("icon-otel icon-lg", "plugin/opentelemetry/images/svgs/opentelemetry.svg", "width: 32px; height: 32px;"));
        IconSet.icons.addIcon(new Icon("icon-otel icon-xlg", "plugin/opentelemetry/images/svgs/opentelemetry.svg", "width: 48px; height: 48px;"));
    }

    @Immutable
    public static class StepPlugin {
        final String name;
        final String version;

        public StepPlugin(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public StepPlugin() {
            this.name = "unknown";
            this.version = "unknown";
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean isUnknown() {
            return this.getName().equals("unknown") && this.getVersion().equals("unknown");
        }

        public String toString() {
            return "StepPlugin{name=" + this.name + ", version=" + this.version + "}";
        }
    }
}

