/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.okhttp.api.internals;

import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ProxyConfiguration;
import hudson.util.Secret;
import java.io.IOException;
import java.util.logging.Logger;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class JenkinsProxyAuthenticator
implements Authenticator {
    private static final Logger LOGGER = Logger.getLogger(JenkinsProxyAuthenticator.class.getName());
    private final ProxyConfiguration proxy;

    public JenkinsProxyAuthenticator(ProxyConfiguration proxy) {
        this.proxy = proxy;
    }

    @Nullable
    @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="Prefer SpotBugs @Nullable")
    public Request authenticate(@Nullable Route route, Response response) throws IOException {
        if (response.request().header("Proxy-Authorization") != null) {
            return null;
        }
        String proxyAuthenticateHeader = response.header("Proxy-Authenticate");
        if (proxyAuthenticateHeader != null) {
            if (proxyAuthenticateHeader.startsWith("Basic")) {
                String credential = Credentials.basic((String)this.proxy.getUserName(), (String)Secret.toString((Secret)this.proxy.getSecretPassword()));
                return response.request().newBuilder().header("Proxy-Authorization", credential).build();
            }
            LOGGER.warning("The proxy authentication scheme is not supported: " + proxyAuthenticateHeader);
        }
        return null;
    }
}

