/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.neuvector;

import com.google.common.base.Strings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.ArtifactArchiver;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.neuvector.Config;
import io.jenkins.plugins.neuvector.ControllerEndpointUrl;
import io.jenkins.plugins.neuvector.Log;
import io.jenkins.plugins.neuvector.Messages;
import io.jenkins.plugins.neuvector.NeuVectorAction;
import io.jenkins.plugins.neuvector.NeuVectorWorker;
import io.jenkins.plugins.neuvector.Registry;
import io.jenkins.plugins.neuvector.model.ScanMeta;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class NeuVectorBuilder
extends Builder
implements SimpleBuildStep {
    private static final String REGISTRY_DROPDOWN_DEFAULT = "Please select a registry:";
    private static final String LOCAL_REGIESTRY = "Local";
    private static final String CONTROLLER_ENDPOINT_DROPDOWN_DEFAULT = "Please select a controller endpoint:";
    private boolean standaloneScanner;
    private boolean sendReportToController;
    private final String repository;
    private String tag;
    private boolean scanLayers;
    private String numberOfHighSeverityToFail;
    private String numberOfMediumSeverityToFail;
    private String nameOfVulnerabilityToFailOne;
    private String nameOfVulnerabilityToFailTwo;
    private String nameOfVulnerabilityToFailThree;
    private String nameOfVulnerabilityToFailFour;
    private String nameOfVulnerabilityToExemptOne;
    private String nameOfVulnerabilityToExemptTwo;
    private String nameOfVulnerabilityToExemptThree;
    private String nameOfVulnerabilityToExemptFour;
    private Integer scanTimeout;
    private String controllerEndpointUrlSelection;
    private String registrySelection;
    private static Integer buildStep;
    private static Integer buildHash;
    private Log logger;
    private boolean isLocal = true;
    private Registry selectRegistry = null;
    private ControllerEndpointUrl selectControllerEndpointUrl = null;

    public static synchronized void setBuildStep(Integer buildStep) {
        NeuVectorBuilder.buildStep = buildStep;
    }

    public static synchronized void setBuildHash(Integer buildHash) {
        NeuVectorBuilder.buildHash = buildHash;
    }

    @DataBoundConstructor
    public NeuVectorBuilder(String repository, String registrySelection) {
        this.repository = repository;
        this.registrySelection = registrySelection != null && !registrySelection.equals(REGISTRY_DROPDOWN_DEFAULT) ? registrySelection : null;
    }

    public boolean getStandaloneScanner() {
        return this.standaloneScanner;
    }

    public boolean getSendReportToController() {
        return this.sendReportToController;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean getScanLayers() {
        return this.scanLayers;
    }

    public Integer getScanTimeout() {
        return this.scanTimeout;
    }

    public String getNumberOfHighSeverityToFail() {
        return this.numberOfHighSeverityToFail;
    }

    public String getNumberOfMediumSeverityToFail() {
        return this.numberOfMediumSeverityToFail;
    }

    public String getNameOfVulnerabilityToFailOne() {
        return this.nameOfVulnerabilityToFailOne;
    }

    public String getNameOfVulnerabilityToFailTwo() {
        return this.nameOfVulnerabilityToFailTwo;
    }

    public String getNameOfVulnerabilityToFailThree() {
        return this.nameOfVulnerabilityToFailThree;
    }

    public String getNameOfVulnerabilityToFailFour() {
        return this.nameOfVulnerabilityToFailFour;
    }

    public String getNameOfVulnerabilityToExemptOne() {
        return this.nameOfVulnerabilityToExemptOne;
    }

    public String getNameOfVulnerabilityToExemptTwo() {
        return this.nameOfVulnerabilityToExemptTwo;
    }

    public String getNameOfVulnerabilityToExemptThree() {
        return this.nameOfVulnerabilityToExemptThree;
    }

    public String getNameOfVulnerabilityToExemptFour() {
        return this.nameOfVulnerabilityToExemptFour;
    }

    public String getRegistrySelection() {
        return this.registrySelection;
    }

    public String getControllerEndpointUrlSelection() {
        return this.controllerEndpointUrlSelection;
    }

    @DataBoundSetter
    public void setStandaloneScanner(boolean standaloneScanner) {
        this.standaloneScanner = standaloneScanner;
    }

    @DataBoundSetter
    public void setSendReportToController(boolean sendReportToController) {
        this.sendReportToController = sendReportToController;
    }

    @DataBoundSetter
    public void setTag(String tag) {
        this.tag = tag.trim();
    }

    @DataBoundSetter
    public void setScanLayers(boolean scanLayers) {
        this.scanLayers = scanLayers;
    }

    @DataBoundSetter
    public void setScanTimeout(Integer scanTimeout) {
        this.scanTimeout = scanTimeout == null ? Integer.valueOf(0) : scanTimeout;
    }

    @DataBoundSetter
    public void setNumberOfHighSeverityToFail(String numberOfHighSeverityToFail) {
        try {
            Integer.parseInt(numberOfHighSeverityToFail.trim());
            this.numberOfHighSeverityToFail = numberOfHighSeverityToFail.trim();
        }
        catch (NumberFormatException e) {
            this.numberOfHighSeverityToFail = "";
        }
    }

    @DataBoundSetter
    public void setNumberOfMediumSeverityToFail(String numberOfMediumSeverityToFail) {
        try {
            Integer.parseInt(numberOfMediumSeverityToFail.trim());
            this.numberOfMediumSeverityToFail = numberOfMediumSeverityToFail.trim();
        }
        catch (NumberFormatException e) {
            this.numberOfMediumSeverityToFail = "";
        }
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToFailOne(String nameOfVulnerabilityToFailOne) {
        this.nameOfVulnerabilityToFailOne = nameOfVulnerabilityToFailOne.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToFailTwo(String nameOfVulnerabilityToFailTwo) {
        this.nameOfVulnerabilityToFailTwo = nameOfVulnerabilityToFailTwo.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToFailThree(String nameOfVulnerabilityToFailThree) {
        this.nameOfVulnerabilityToFailThree = nameOfVulnerabilityToFailThree.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToFailFour(String nameOfVulnerabilityToFailFour) {
        this.nameOfVulnerabilityToFailFour = nameOfVulnerabilityToFailFour.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToExemptOne(String nameOfVulnerabilityToExemptOne) {
        this.nameOfVulnerabilityToExemptOne = nameOfVulnerabilityToExemptOne.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToExemptTwo(String nameOfVulnerabilityToExemptTwo) {
        this.nameOfVulnerabilityToExemptTwo = nameOfVulnerabilityToExemptTwo.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToExemptThree(String nameOfVulnerabilityToExemptThree) {
        this.nameOfVulnerabilityToExemptThree = nameOfVulnerabilityToExemptThree.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToExemptFour(String nameOfVulnerabilityToExemptFour) {
        this.nameOfVulnerabilityToExemptFour = nameOfVulnerabilityToExemptFour.trim();
    }

    @DataBoundSetter
    public void setControllerEndpointUrlSelection(String controllerEndpointUrlSelection) {
        this.controllerEndpointUrlSelection = controllerEndpointUrlSelection != null && !controllerEndpointUrlSelection.equals(CONTROLLER_ENDPOINT_DROPDOWN_DEFAULT) ? controllerEndpointUrlSelection : null;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        this.logger = new Log(listener.getLogger());
        EnvVars env = run.getEnvironment(listener);
        FilePath targetCss = new FilePath(workspace, "styles.css");
        File cssFile = new File((String)env.get((Object)"JENKINS_HOME") + "/plugins/neuvector-vulnerability-scanner/css/", "styles.css");
        FilePath cssFilePath = new FilePath(cssFile);
        cssFilePath.copyTo(targetCss);
        String artifactName = "NeuVectorReport_" + run.getParent().getDisplayName() + "_" + run.getNumber();
        if (run.hashCode() != buildHash.intValue()) {
            NeuVectorBuilder.setBuildHash(run.hashCode());
            NeuVectorBuilder.setBuildStep(1);
        } else {
            NeuVectorBuilder.setBuildStep(buildStep + 1);
        }
        String reportNumber = Integer.toString(buildStep);
        artifactName = artifactName + "-" + reportNumber;
        Config config = null;
        try {
            config = this.printInfoFromUser(run, listener);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        NeuVectorWorker worker = new NeuVectorWorker(this.logger, config, workspace, artifactName);
        try {
            worker.scan(run, launcher);
        }
        catch (Exception ex) {
            this.archiveAndAddAction(run, workspace, launcher, listener, artifactName, reportNumber);
            throw new AbortException(ex.getMessage());
        }
        this.archiveAndAddAction(run, workspace, launcher, listener, artifactName, reportNumber);
    }

    private String getBuildUser(String url) throws IOException {
        StringBuilder result = new StringBuilder();
        URL urlVar = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)urlVar.openConnection();
        conn.setRequestMethod("GET");
        try (BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
        }
        String userName = "";
        try {
            JSONObject json = JSONObject.fromObject((Object)result.toString());
            JSONObject action = (JSONObject)json.getJSONArray("actions").get(0);
            JSONObject cause = (JSONObject)action.getJSONArray("causes").get(0);
            userName = cause.getString("userName");
        }
        catch (JSONException e) {
            userName = "anonymous";
        }
        return userName;
    }

    private void selectRegistryInDropDown(List<Registry> registries) throws AbortException {
        if (this.registrySelection.equalsIgnoreCase(REGISTRY_DROPDOWN_DEFAULT)) {
            throw new AbortException("Please select a registry or choose Local");
        }
        if (this.registrySelection.equalsIgnoreCase(LOCAL_REGIESTRY)) {
            this.logger.println("Local case.");
        } else {
            if (registries == null) {
                throw new AbortException("Registry " + this.registrySelection + " in current project is missing or deleted in global configuration.");
            }
            boolean found = false;
            for (Registry registry : registries) {
                if (registry.getNickname().isEmpty() || registry.getRegUrl().isEmpty()) {
                    throw new AbortException("Registry nickname and URL cannot be empty");
                }
                if (!registry.getNickname().equalsIgnoreCase(this.registrySelection)) continue;
                found = true;
                this.isLocal = false;
                this.selectRegistry = registry;
                this.logger.println("Registry: " + this.registrySelection);
                this.logger.println("Registry URL: " + this.selectRegistry.getRegUrl());
                this.logger.println("Registry Username: " + this.selectRegistry.getRegUsername());
                break;
            }
            if (!found) {
                throw new AbortException("Registry " + this.registrySelection + " in current project is missing or deleted in global configuration.");
            }
        }
    }

    private void selectControllerEndpointUrlInDropDown(List<ControllerEndpointUrl> controllerEndpointUrls) throws AbortException {
        if (Strings.isNullOrEmpty((String)this.controllerEndpointUrlSelection)) {
            this.logger.println("No controller endpoint URL selection provided, proceeding without it.");
            return;
        }
        if (this.controllerEndpointUrlSelection.equalsIgnoreCase(CONTROLLER_ENDPOINT_DROPDOWN_DEFAULT)) {
            throw new AbortException("Please select a Controller Endpoint.");
        }
        if (controllerEndpointUrls == null) {
            throw new AbortException("Controller Endpoint " + this.controllerEndpointUrlSelection + " in current project is missing or deleted in global configuration.");
        }
        boolean found = false;
        for (ControllerEndpointUrl controllerEndpointUrl : controllerEndpointUrls) {
            if (controllerEndpointUrl.getNickname().isEmpty() || controllerEndpointUrl.getControllerEndpointUrl().isEmpty()) {
                throw new AbortException("Controller Endpoint nickname and URL cannot be empty");
            }
            if (!controllerEndpointUrl.getNickname().equalsIgnoreCase(this.controllerEndpointUrlSelection)) continue;
            found = true;
            this.isLocal = false;
            this.selectControllerEndpointUrl = controllerEndpointUrl;
            this.logger.println("Controller Endpoint : " + this.controllerEndpointUrlSelection);
            this.logger.println("Controller Endpoint URL: " + this.selectControllerEndpointUrl.getControllerEndpointUrl());
            this.logger.println("Controller Endpoint Username: " + this.selectControllerEndpointUrl.getControllerUser());
            break;
        }
        if (!found) {
            throw new AbortException("Controller Endpoint " + this.controllerEndpointUrlSelection + " in current project is missing or deleted in global configuration.");
        }
    }

    private Config printInfoFromUser(Run<?, ?> run, TaskListener listener) throws AbortException, URISyntaxException {
        EnvVars env;
        DescriptorImpl globalConfig = this.getDescriptor();
        List<Registry> registries = globalConfig.getRegistries();
        List<ControllerEndpointUrl> controllerEndpointUrls = globalConfig.getControllerEndpointUrls();
        if (this.repository == null || this.registrySelection == null) {
            throw new AbortException("repository and registrySelection both are required.");
        }
        if (this.controllerEndpointUrlSelection == null && globalConfig.getIsDeafultControllerEndpointUrls().booleanValue()) {
            this.controllerEndpointUrlSelection = "default";
        }
        try {
            env = run.getEnvironment(listener);
        }
        catch (IOException | InterruptedException e) {
            throw new AbortException("Error when getting Jenkins project environment.");
        }
        String currentRepository = env.expand(this.repository.trim());
        String currentTag = env.expand(this.tag);
        String buildUrl = (String)env.get((Object)"BUILD_URL") + "api/json";
        String buildUser = "";
        try {
            buildUser = this.getBuildUser(buildUrl);
        }
        catch (IOException e) {
            this.logger.println("Build user not found.");
        }
        this.logger.println("");
        this.logger.println("*************************************************************");
        ScanMeta scanMeta = new ScanMeta();
        scanMeta.setSource(globalConfig.getSource());
        scanMeta.setUser(buildUser);
        scanMeta.setJob((String)env.get((Object)"JOB_NAME"));
        scanMeta.setWorkspace((String)env.get((Object)"WORKSPACE"));
        if (scanMeta.getSource() == null || scanMeta.getSource().isEmpty()) {
            this.logger.println("Scanner Source Name: (Please set a name in Jenkins -> Configure System -> NeuVector Vulnerablity Scanner -> NeuVector Scanner Source Name )");
        } else {
            this.logger.println("Scanner Source Name: " + scanMeta.getSource());
        }
        this.logger.println("Build User: " + scanMeta.getUser());
        this.logger.println("Job Name: " + scanMeta.getJob());
        this.logger.println("Workspace: " + scanMeta.getWorkspace());
        this.selectRegistryInDropDown(registries);
        this.selectControllerEndpointUrlInDropDown(controllerEndpointUrls);
        this.logger.println("selectControllerEndpointUrl: " + this.selectControllerEndpointUrl);
        this.logger.println("selectControllerEndpointUrl: " + this.selectControllerEndpointUrl);
        this.logger.println("selectControllerEndpointUrl: " + this.selectControllerEndpointUrl);
        this.logger.println("Repository: " + currentRepository);
        this.logger.println("Tag: " + currentTag);
        Double highSeverityThreshold = globalConfig.highSeverityThreshold;
        Double mediumSeverityThreshold = globalConfig.mediumSeverityThreshold;
        boolean customizedRatingScale = false;
        if (highSeverityThreshold != null && mediumSeverityThreshold != null && highSeverityThreshold > mediumSeverityThreshold) {
            customizedRatingScale = true;
        }
        return new Config.ConfigBuilder(this.selectControllerEndpointUrl).standaloneScanner(this.standaloneScanner).sendReportToController(this.sendReportToController).scanMeta(scanMeta).isLocal(this.isLocal).scannerRegistryURL(globalConfig.scannerRegistryURL).scannerRegistryUser(globalConfig.scannerRegistryUser).scannerRegistryPassword(globalConfig.scannerRegistryPassword).scannerImage(globalConfig.scannerImage).registry(this.selectRegistry).repository(currentRepository).tag(currentTag).scanLayers(this.scanLayers).scanTimeout(this.scanTimeout).highSeverityThreshold(highSeverityThreshold).mediumSeverityThreshold(mediumSeverityThreshold).customizedRatingScale(customizedRatingScale).numberOfHighSeverityToFail(this.numberOfHighSeverityToFail).numberOfMediumSeverityToFail(this.numberOfMediumSeverityToFail).nameOfVulnerabilityToFailOne(this.nameOfVulnerabilityToFailOne).nameOfVulnerabilityToFailTwo(this.nameOfVulnerabilityToFailTwo).nameOfVulnerabilityToFailThree(this.nameOfVulnerabilityToFailThree).nameOfVulnerabilityToFailFour(this.nameOfVulnerabilityToFailFour).nameOfVulnerabilityToExemptOne(this.nameOfVulnerabilityToExemptOne).nameOfVulnerabilityToExemptTwo(this.nameOfVulnerabilityToExemptTwo).nameOfVulnerabilityToExemptThree(this.nameOfVulnerabilityToExemptThree).nameOfVulnerabilityToExemptFour(this.nameOfVulnerabilityToExemptFour).build();
    }

    private void archiveAndAddAction(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener, String artifactName, String reportNumber) {
        ArtifactArchiver artifactArchiver;
        try {
            ArtifactArchiver artifactArchiver2 = new ArtifactArchiver(artifactName);
            artifactArchiver2.perform(run, workspace, launcher, listener);
        }
        catch (Exception e) {
            this.logger.println("Failed to archive the artifact file: " + artifactName);
        }
        String artifactNameHTML = artifactName + ".html";
        try {
            ArtifactArchiver artifactArchiver3 = new ArtifactArchiver(artifactNameHTML);
            artifactArchiver3.perform(run, workspace, launcher, listener);
        }
        catch (Exception e) {
            this.logger.println("Failed to archive the artifact HTML: " + artifactNameHTML);
        }
        String artifactNameJson = artifactName + ".json";
        try {
            artifactArchiver = new ArtifactArchiver(artifactNameJson);
            artifactArchiver.perform(run, workspace, launcher, listener);
        }
        catch (Exception e) {
            this.logger.println("Failed to archive the artifact Json: " + artifactNameJson);
        }
        try {
            artifactArchiver = new ArtifactArchiver("styles.css");
            artifactArchiver.perform(run, workspace, launcher, listener);
        }
        catch (Exception e) {
            this.logger.println("Failed to archive the artifact css style file. ");
        }
        run.addAction((Action)new NeuVectorAction(run, artifactNameHTML, reportNumber));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    static {
        buildHash = 0;
    }

    @Symbol(value={"neuvector"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String source;
        private String controllerIP;
        private String controllerPort;
        private String controllerApiUrl;
        private String user;
        private Secret password;
        private Integer timeout;
        private Boolean disableTLSCertVerification;
        private String serverCertificate;
        private String scannerRegistryURL;
        private String scannerImage;
        private String scannerRegistryUser;
        private Secret scannerRegistryPassword;
        private Double mediumSeverityThreshold;
        private Double highSeverityThreshold;
        private List<ControllerEndpointUrl> controllerEndpointUrls;
        private List<Registry> registries;
        private Boolean isDeafultControllerEndpointUrls = false;
        private Double thresholdMin = 0.0;
        private Double thresholdMax = 10.0;

        public void setSource(String source) {
            this.source = source;
        }

        public void setScannerRegistryURL(String scannerRegistryURL) {
            this.scannerRegistryURL = scannerRegistryURL;
        }

        public void setScannerImage(String scannerImage) {
            this.scannerImage = scannerImage;
        }

        public void setDisableTLSCertVerification(Boolean disableTLSCertVerification) {
            this.disableTLSCertVerification = disableTLSCertVerification;
        }

        public void setServerCertificate(String serverCertificate) {
            this.serverCertificate = serverCertificate;
        }

        public void setScannerRegistryUser(String scannerRegistryUser) {
            this.scannerRegistryUser = scannerRegistryUser;
        }

        public void setScannerRegistryPassword(Secret scannerRegistryPassword) {
            this.scannerRegistryPassword = scannerRegistryPassword;
        }

        public void setControllerIP(String controllerIP) {
            this.controllerIP = controllerIP;
        }

        public void setControllerPort(String controllerPort) {
            this.controllerPort = controllerPort;
        }

        public void setControllerApiUrl(String controllerApiUrl) {
            this.controllerApiUrl = controllerApiUrl;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setPassword(Secret password) {
            this.password = password;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public void setRegistries(List<Registry> registries) {
            this.registries = registries;
        }

        public void setControllerEndpointUrls(List<ControllerEndpointUrl> controllerEndpointUrls) {
            this.controllerEndpointUrls = controllerEndpointUrls;
        }

        public void setMediumSeverityThreshold(Double mediumSeverityThreshold) {
            this.mediumSeverityThreshold = mediumSeverityThreshold;
        }

        public void setHighSeverityThreshold(Double highSeverityThreshold) {
            this.highSeverityThreshold = highSeverityThreshold;
        }

        public Double getMediumSeverityThreshold() {
            return this.mediumSeverityThreshold;
        }

        public Double getHighSeverityThreshold() {
            return this.highSeverityThreshold;
        }

        public String getSource() {
            return this.source;
        }

        public String getControllerApiUrl() {
            return this.controllerApiUrl;
        }

        public String getUser() {
            return this.user;
        }

        public Secret getPassword() {
            return this.password;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public String getScannerRegistryURL() {
            return this.scannerRegistryURL;
        }

        public String getScannerImage() {
            return this.scannerImage;
        }

        public Boolean getDisableTLSCertVerification() {
            return this.disableTLSCertVerification;
        }

        public String getServerCertificate() {
            return this.serverCertificate;
        }

        public String getScannerRegistryUser() {
            return this.scannerRegistryUser;
        }

        public Secret getScannerRegistryPassword() {
            return this.scannerRegistryPassword;
        }

        public List<Registry> getRegistries() {
            return this.registries;
        }

        public List<ControllerEndpointUrl> getControllerEndpointUrls() {
            return this.controllerEndpointUrls;
        }

        public Boolean getIsDeafultControllerEndpointUrls() {
            return this.isDeafultControllerEndpointUrls;
        }

        public DescriptorImpl() {
            this.load();
        }

        public ListBoxModel doFillRegistrySelectionItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(NeuVectorBuilder.REGISTRY_DROPDOWN_DEFAULT);
            items.add(NeuVectorBuilder.LOCAL_REGIESTRY);
            if (this.registries != null) {
                for (Registry reg : this.registries) {
                    items.add(reg.getNickname());
                }
            }
            return items;
        }

        public ListBoxModel doFillControllerEndpointUrlSelectionItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(NeuVectorBuilder.CONTROLLER_ENDPOINT_DROPDOWN_DEFAULT);
            if (this.controllerEndpointUrls != null) {
                for (ControllerEndpointUrl controllerEndpointUrl : this.controllerEndpointUrls) {
                    items.add(controllerEndpointUrl.getNickname());
                }
            }
            return items;
        }

        public FormValidation doCheckScanTimeout(@QueryParameter(value="scanTimeout") Integer scanTimeout) {
            if (scanTimeout > 0 && scanTimeout <= 60) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_scanTimeout());
        }

        public FormValidation doCheckRegistrySelection(@QueryParameter String value) {
            if (Strings.isNullOrEmpty((String)value) || value.equalsIgnoreCase(NeuVectorBuilder.REGISTRY_DROPDOWN_DEFAULT)) {
                return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_registrySelection());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckControllerEndpointUrlSelection(@QueryParameter String value) {
            if (Strings.isNullOrEmpty((String)value) || value.equalsIgnoreCase(NeuVectorBuilder.CONTROLLER_ENDPOINT_DROPDOWN_DEFAULT)) {
                return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_controllerEndpointUrlSelection());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckMediumSeverityThreshold(@QueryParameter Double value, @QueryParameter Double highSeverityThreshold) {
            if (value != null) {
                if (value < this.thresholdMin || value > this.thresholdMax) {
                    return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_invalidScore());
                }
                if (highSeverityThreshold == null) {
                    return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_missingSeverityScore());
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckHighSeverityThreshold(@QueryParameter Double value, @QueryParameter Double mediumSeverityThreshold) {
            if (value != null) {
                if (value < this.thresholdMin || value > this.thresholdMax) {
                    return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_invalidScore());
                }
                if (mediumSeverityThreshold == null) {
                    return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_missingSeverityScore());
                }
                if (value <= mediumSeverityThreshold) {
                    return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_invalidThreshold());
                }
            }
            return FormValidation.ok();
        }

        private Boolean inRange(Double min, Double max, Double value) {
            if (value != null && value > min && value < max) {
                return true;
            }
            return false;
        }

        private Boolean validThresholds(Double med, Double high) {
            return this.inRange(this.thresholdMin, this.thresholdMax, med) != false && this.inRange(this.thresholdMin, this.thresholdMax, high) != false && med < high;
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.NeuVectorBuilder_DescriptorImpl_DisplayName();
        }

        public void load() {
            super.load();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            formData.put("controllerEndpointUrls", (Object)this.ensureJsonArrayHasNoDuplicateNickname(formData.get("controllerEndpointUrls")));
            formData.put("registries", (Object)this.ensureJsonArrayHasNoDuplicateNickname(formData.get("registries")));
            if (!this.validThresholds(this.mediumSeverityThreshold, this.highSeverityThreshold).booleanValue()) {
                formData.put("highSeverityThreshold", (Object)"");
                formData.put("mediumSeverityThreshold", (Object)"");
            }
            req.bindJSON((Object)this, formData);
            this.save();
            return true;
        }

        private JSONArray ensureJsonArrayHasNoDuplicateNickname(Object data) {
            JSONArray jsonArray = new JSONArray();
            if (data instanceof JSONObject) {
                jsonArray.add(data);
            } else if (data instanceof JSONArray) {
                jsonArray = (JSONArray)data;
            }
            JSONArray filteredJsonArray = new JSONArray();
            HashSet<String> nicknames = new HashSet<String>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String nickname = jsonObject.getString("nickname");
                if (!nicknames.add(nickname)) continue;
                filteredJsonArray.add(jsonArray.get(i));
            }
            return filteredJsonArray;
        }

        protected Object readResolve() {
            if (!(this.controllerApiUrl != null && !this.controllerApiUrl.isEmpty() || this.controllerIP == null || this.controllerIP.isEmpty() || this.controllerPort == null || this.controllerPort.isEmpty())) {
                this.controllerApiUrl = "https://" + this.controllerIP.trim() + ":" + this.controllerPort.trim();
            }
            if (this.controllerEndpointUrls == null && this.controllerApiUrl != null && !this.controllerApiUrl.isEmpty()) {
                this.controllerEndpointUrls = new ArrayList<ControllerEndpointUrl>();
                String defaultNickname = "default";
                try {
                    boolean migratedFromNonTLSVersion;
                    boolean bl = migratedFromNonTLSVersion = this.serverCertificate == null;
                    if (migratedFromNonTLSVersion) {
                        this.disableTLSCertVerification = this.user != null && !this.user.isEmpty();
                    }
                    this.controllerEndpointUrls.add(new ControllerEndpointUrl(defaultNickname, this.controllerApiUrl, this.user, this.password, this.disableTLSCertVerification, this.serverCertificate, this.timeout));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                this.isDeafultControllerEndpointUrls = true;
            }
            return this;
        }
    }
}

