/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.neuvector.model;

import java.net.URI;
import java.net.URISyntaxException;

public class ControllerApiUrl {
    private String protocol;
    private String host;
    private int port;
    private String subpath;

    public ControllerApiUrl(String apiUrl) throws URISyntaxException {
        URI uri = new URI(apiUrl);
        this.protocol = uri.getScheme();
        this.host = uri.getHost();
        this.port = uri.getPort() == -1 ? 443 : uri.getPort();
        this.subpath = uri.getPath();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getSubpath() {
        return this.subpath;
    }

    public String toString() {
        StringBuilder apiUrlBuilder = new StringBuilder();
        apiUrlBuilder.append(this.protocol).append("://").append(this.host).append(":").append(this.port).append(this.subpath);
        return apiUrlBuilder.toString();
    }
}

