/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.neuvector;

import com.google.common.base.Strings;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import io.jenkins.plugins.neuvector.Messages;
import java.io.Serializable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class Registry
extends AbstractDescribableImpl<Registry>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String nickname;
    private String regUrl;
    private String regUsername;
    private Secret regPassword;

    @DataBoundConstructor
    public Registry(String nickname, String regUrl, String regUsername, Secret regPassword) {
        this.nickname = nickname.trim();
        this.regUrl = regUrl.trim();
        this.regUsername = regUsername.trim();
        this.regPassword = regPassword;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getRegUrl() {
        return this.regUrl;
    }

    public String getRegUsername() {
        return this.regUsername;
    }

    public Secret getRegPassword() {
        return this.regPassword;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Registry> {
        public String getDisplayName() {
            return "Add Registry";
        }

        public FormValidation doCheckNickname(@QueryParameter String value) {
            if (Strings.isNullOrEmpty((String)value) || value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.Registry_DescriptorImpl_errors_nickname());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckRegUrl(@QueryParameter String value) {
            if (Strings.isNullOrEmpty((String)value) || value.trim().isEmpty() || !value.trim().matches("^(http|https)://.*$")) {
                return FormValidation.error((String)Messages.Registry_DescriptorImpl_errors_regUrl());
            }
            return FormValidation.ok();
        }
    }
}

