/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.neuvector;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Computer;
import hudson.model.Run;
import hudson.slaves.SlaveComputer;
import hudson.util.ArgumentListBuilder;
import hudson.util.Secret;
import io.jenkins.plugins.neuvector.Config;
import io.jenkins.plugins.neuvector.Log;
import io.jenkins.plugins.neuvector.TrustAllStrategy;
import io.jenkins.plugins.neuvector.model.SeverityRating;
import io.jenkins.plugins.neuvector.model.report.ScanResult;
import io.jenkins.plugins.neuvector.model.report.Vulnerability;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.net.ssl.HostnameVerifier;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class NeuVectorWorker {
    private static final int HTTP_CLIENT_CONFIG_TIMEOUT_SECOND = 60;
    private static final String SCAN_REPORT = "scan_result.json";
    private final Log logger;
    private final Config config;
    private String token;
    private String artifactname;
    private FilePath workspace;

    public NeuVectorWorker(Log logger, Config config) {
        this.logger = logger;
        this.config = config;
    }

    public NeuVectorWorker(Log logger, Config config, @Nonnull FilePath workspace, String artifactName) {
        this.logger = logger;
        this.config = config;
        this.workspace = workspace;
        this.artifactname = artifactName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    public void scan(Run<?, ?> run, Launcher launcher) throws IOException, InterruptedException {
        String scanJson;
        if (this.config.isStandaloneScanner()) {
            int exitCode = 0;
            ArgumentListBuilder args = new ArgumentListBuilder();
            File outFile = new File(run.getRootDir(), "out");
            Launcher.ProcStarter ps = launcher.launch();
            try (PrintStream print_stream = new PrintStream(outFile, "UTF-8");){
                ps.stderr((OutputStream)print_stream);
                ps.stdout((OutputStream)print_stream);
                ps.quiet(true);
                if (!this.config.getScannerRegistryUser().isEmpty()) {
                    args.add(new String[]{"docker", "login"});
                    args.add(new String[]{"-u", this.config.getScannerRegistryUser(), "-p"});
                    args.addMasked(this.config.getScannerRegistryPassword().getPlainText());
                    args.add(this.config.getScannerRegistryURL());
                    ps.cmds(args);
                    this.logger.println("Logging in " + this.config.getScannerRegistryURL() + " with " + this.config.getScannerRegistryUser() + " ... ");
                    exitCode = ps.join();
                }
                if (exitCode != 0) {
                    this.logger.println("docker failed to login " + this.config.getScannerRegistryURL() + " Please check the global configuration.");
                }
                args.clear();
                args.add(new String[]{"docker", "pull"});
                args.add(this.config.getScannerRegistryURL() + "/" + this.config.getScannerImage());
                ps.cmds(args);
                this.logger.println("Pulling NeuVector Scanner from " + this.config.getScannerRegistryURL() + "/" + this.config.getScannerImage() + " ...");
                exitCode = ps.join();
                if (exitCode != 0) {
                    this.logger.println("docker failed to pull " + this.config.getScannerRegistryURL() + "/" + this.config.getScannerImage() + " Please check the global configuration.");
                }
                args.clear();
                String nvScannerName = this.generateScannerName();
                args.add(new String[]{"docker", "run"});
                args.add(new String[]{"--name", nvScannerName, "--rm"});
                EnvVars env = run.getEnvironment(launcher.getListener());
                String nvScannerPath = run.getRootDir().getAbsolutePath();
                if (Objects.nonNull(env.get((Object)"JENKINS_MOUNT_PATH")) && !((String)env.get((Object)"JENKINS_MOUNT_PATH")).isEmpty()) {
                    nvScannerPath = nvScannerPath.replace((CharSequence)env.get((Object)"JENKINS_HOME"), (CharSequence)env.get((Object)"JENKINS_MOUNT_PATH"));
                }
                String regUrl = "";
                if (!this.config.isLocal()) {
                    regUrl = this.config.getRegistry().getRegUrl();
                    args.add(new String[]{"-e", "SCANNER_REGISTRY=" + regUrl, "-e", "SCANNER_REGISTRY_USERNAME=" + this.config.getRegistry().getRegUsername(), "-e", "SCANNER_REGISTRY_PASSWORD=" + this.config.getRegistry().getRegPassword()});
                    regUrl = regUrl + "/";
                }
                args.add(new String[]{"-e", "SCANNER_REPOSITORY=" + this.config.getRepository(), "-e", "SCANNER_TAG=" + this.config.getTag(), "-e", "SCANNER_SCAN_LAYERS=" + this.config.getScanLayers(), "-e", "SCANNER_LICENSE=" + this.config.getLicense(), "-v", "/var/run/docker.sock:/var/run/docker.sock", "-v", nvScannerPath + ":/var/neuvector", this.config.getScannerRegistryURL() + "/" + this.config.getScannerImage()});
                ps.cmds(args);
                this.logger.println("Scanning " + regUrl + this.config.getRepository() + ":" + this.config.getTag());
                exitCode = ps.join();
                if (exitCode != 0) {
                    String causeMessage = "Failed to run the scan. Check the log in " + outFile.getAbsolutePath();
                    this.logger.println(causeMessage);
                    throw new AbortException(causeMessage);
                }
            }
            String scanReportPath = run.getRootDir().getAbsolutePath() + "/" + SCAN_REPORT;
            StringBuilder contentBuilder = new StringBuilder();
            if (Computer.currentComputer() instanceof SlaveComputer) {
                FilePath scanReportFile = new FilePath(launcher.getChannel(), scanReportPath);
                contentBuilder.append(scanReportFile.readToString());
            } else {
                try (Stream<String> stream = Files.lines(Paths.get(scanReportPath, new String[0]), StandardCharsets.UTF_8);){
                    stream.forEach(s -> contentBuilder.append((String)s).append("\n"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            scanJson = contentBuilder.toString();
        } else {
            try (CloseableHttpClient httpclient = this.makeHttpClient();){
                this.getToken(httpclient);
                try {
                    scanJson = this.requestScan(httpclient);
                }
                finally {
                    this.logout(httpclient);
                }
            }
        }
        ScanResult scanResult = this.processScanReport(scanJson, this.config);
        this.printHTMLReport(scanResult);
        this.printTxtReport(scanResult);
        this.makeIfFailDecision(scanResult.getHighSeverityNumber(), scanResult.getMediumSeverityNumber(), scanResult.isBlackListVulExisted(), scanResult.getExistedBlackListVulSet());
    }

    public void printHTMLReport(ScanResult scanResult) throws IOException, InterruptedException {
        FilePath workspaceFP = new FilePath(this.workspace, this.artifactname + ".html");
        try (PrintStream printStream = new PrintStream(workspaceFP.write(), false, "UTF-8");){
            Log logger = new Log(printStream);
            logger.println("");
            logger.println("<!DOCTYPE html>\n<html lang=\"en\">\n<head><link rel=\"stylesheet\" href=\"styles.css\"></head>\n<body>");
            logger.println("<h1>Scan Report </h1>\n");
            logger.println("<h3>Summary</h3>");
            logger.println("<table>\n    <tr>\n        <th>Registry URL</th>\n        <th>Repository</th>\n        <th>Tag</th>\n        <th>High severity VULs</th>\n        <th>High severity threshold</th>\n        <th>Medium severity VULs</th>\n        <th>Medium severity threshold</th>\n        <th>VULs to fail the build</th>\n        <th>Total VULs</th>\n    </tr>");
            logger.println("<tr>");
            if (scanResult.isLocalScan()) {
                logger.println("<td>Local image</td>");
            } else {
                logger.println("<td><a target=\"_parent\" href=\"" + scanResult.getRepository() + "\">" + scanResult.getRegistry() + "</a></td>");
            }
            logger.println("<td> " + scanResult.getRepository() + "</td>");
            logger.println("<td> " + scanResult.getTag() + "</td>");
            logger.println("<td> " + scanResult.getHighVulnerabilitySet().size() + "</td>");
            if (scanResult.getHighSeverityThreshold() != 0) {
                logger.println("<td> " + scanResult.getHighSeverityThreshold() + "</td>");
            } else {
                logger.println("<td> No Limit </td>");
            }
            logger.println("<td> " + scanResult.getMediumVulnerabilitySet().size() + "</td>");
            if (scanResult.getMediumSeverityThreshold() != 0) {
                logger.println("<td> " + scanResult.getMediumSeverityThreshold() + "</td>");
            } else {
                logger.println("<td> No Limit </td>");
            }
            if (scanResult.isBlackListVulExisted()) {
                logger.println("<td> " + String.join((CharSequence)", ", scanResult.getExistedBlackListVulSet()) + "</td>");
            } else {
                logger.println("<td></td>");
            }
            logger.println("<td> " + scanResult.getTotalVulnerabilityNumber() + "</td>");
            logger.println("</tr></table>");
            logger.println("<h3> Vulnerabilities </h3>");
            if (scanResult.getTotalVulnerabilityNumber() == 0) {
                logger.println("<p>Scanned. No vulnerabilities found.</p>");
            } else {
                logger.println("<table>\n    <tr>\n        <th>Name</th>\n        <th>Severity</th>\n        <th>Score</th>\n        <th>Package</th>\n        <th>Fixed_version</th>\n        <th>Vectors</th>\n        <th>Description</th>\n        <th>Feed_rating</th>\n    </tr>");
                for (Vulnerability vulnerability : scanResult.getHighVulnerabilitySet()) {
                    logger.println("<tr>");
                    logger.println("<td><a target=\"_blank\" href=\"" + vulnerability.getLink() + "\">" + vulnerability.getName().toUpperCase() + "</td>");
                    logger.println("<td> High </td>");
                    logger.println("<td> " + vulnerability.getScore() + "</td>");
                    logger.println("<td>" + vulnerability.getPackage_name() + ":" + vulnerability.getPackage_version() + "</td>");
                    logger.println("<td>" + vulnerability.getFixed_version() + "</td>");
                    logger.println("<td>" + vulnerability.getVectors() + "</td>");
                    logger.println("<td>" + vulnerability.getDescription() + "</td>");
                    logger.println("<td>" + vulnerability.getFeed_rating() + "</td>");
                    logger.println("</tr>");
                }
                for (Vulnerability vulnerability : scanResult.getMediumVulnerabilitySet()) {
                    logger.println("<tr>");
                    logger.println("<td><a target=\"_blank\" href=\"" + vulnerability.getLink() + "\">" + vulnerability.getName().toUpperCase() + "</td>");
                    logger.println("<td> Medium </td>");
                    logger.println("<td> " + vulnerability.getScore() + "</td>");
                    logger.println("<td>" + vulnerability.getPackage_name() + ":" + vulnerability.getPackage_version() + "</td>");
                    logger.println("<td>" + vulnerability.getFixed_version() + "</td>");
                    logger.println("<td>" + vulnerability.getVectors() + "</td>");
                    logger.println("<td>" + vulnerability.getDescription() + "</td>");
                    logger.println("<td>" + vulnerability.getFeed_rating() + "</td>");
                    logger.println("</tr>");
                }
                logger.println("</table>\n");
            }
            if (scanResult.isScanLayerConfigured()) {
                if (scanResult.isScanLayerSupported()) {
                    logger.println("<h3> Layer Vulnerability History </h3>");
                    Set<String> keys = scanResult.getLayeredVulsMap().keySet();
                    for (String key : keys) {
                        Set<Vulnerability> vulSet = scanResult.getLayeredVulsMap().get(key);
                        logger.println("<p>Layer digest " + key + " contains " + vulSet.size() + " vulnerabilities.</p>");
                        if (vulSet.size() <= 0) continue;
                        logger.println("<table>\n    <tr>\n        <th>Name</th>\n        <th>Score</th>\n        <th>Package</th>\n        <th>Fixed_version</th>\n        <th>Link</th>\n        <th>Feed_rating</th>\n    </tr>");
                        for (Vulnerability vulnerability : vulSet) {
                            logger.println("<tr>\n");
                            logger.println("<td><a target=\"_parent\" href=\"" + vulnerability.getLink() + "\">" + vulnerability.getName() + "</td>");
                            logger.println("<td> " + vulnerability.getScore() + "</td>");
                            logger.println("<td> " + vulnerability.getPackage_name() + ":" + vulnerability.getPackage_version() + "</td>");
                            logger.println("<td> " + vulnerability.getFixed_version() + "</td>");
                            logger.println("<td> " + vulnerability.getLink() + "</td>");
                            logger.println("<td> " + vulnerability.getFeed_rating() + "</td>");
                            logger.println("</tr>");
                        }
                        logger.println("</table>");
                    }
                } else {
                    logger.println("<p> Your Controller Does Not Support Layer Vulnerability Scan </p>");
                }
            }
            if (scanResult.isWhiteListVulExisted()) {
                logger.println("<h3>Exempted Vulnerabilities</h3");
                if (scanResult.getExistedWhiteListVulSet().size() == 1) {
                    logger.println("<p> " + scanResult.getExistedWhiteListVulSet().iterator().next().toUpperCase() + "</p>");
                } else {
                    logger.println("<p> " + String.join((CharSequence)",", scanResult.getExistedWhiteListVulSet()) + "</p>");
                }
            }
            logger.println("</body>\n</html>");
        }
    }

    public void printTxtReport(ScanResult scanResult) throws IOException, InterruptedException {
        FilePath workspaceFP = new FilePath(this.workspace, this.artifactname);
        try (PrintStream printStream = new PrintStream(workspaceFP.write(), false, "UTF-8");){
            Log logger = new Log(printStream);
            logger.println("");
            logger.println("************************ Scan Report ************************");
            if (!scanResult.isLocalScan()) {
                logger.println("Registry URL: " + scanResult.getRegistry());
            }
            logger.println("Repository: " + scanResult.getRepository());
            logger.println("Tag: " + scanResult.getTag());
            logger.println("High severity vulnerabilities: " + scanResult.getHighSeverityNumber());
            logger.println("Medium severity vulnerabilities: " + scanResult.getMediumSeverityNumber());
            logger.println("Total vulnerabilities: " + scanResult.getTotalVulnerabilityNumber());
            logger.println("********************** Vulnerabilities **********************");
            logger.println("");
            if (scanResult.getTotalVulnerabilityNumber() == 0) {
                logger.println("Scanned. No vulnerabilities found.");
            } else {
                for (Vulnerability vulnerability : scanResult.getHighVulnerabilitySet()) {
                    logger.println("Name: " + vulnerability.getName().toUpperCase());
                    logger.println("Score: " + vulnerability.getScore());
                    logger.println("Severity: High");
                    logger.println("Vectors: " + vulnerability.getVectors());
                    logger.println("Description: " + vulnerability.getDescription());
                    logger.println("Package_name: " + vulnerability.getPackage_name());
                    logger.println("Package_version: " + vulnerability.getPackage_version());
                    logger.println("Fixed_version: " + vulnerability.getFixed_version());
                    logger.println("Link: " + vulnerability.getLink());
                    logger.println("");
                }
                for (Vulnerability vulnerability : scanResult.getMediumVulnerabilitySet()) {
                    logger.println("Name: " + vulnerability.getName().toUpperCase());
                    logger.println("Score: " + vulnerability.getScore());
                    logger.println("Severity: Medium");
                    logger.println("Vectors: " + vulnerability.getVectors());
                    logger.println("Description: " + vulnerability.getDescription());
                    logger.println("Package_name: " + vulnerability.getPackage_name());
                    logger.println("Package_version: " + vulnerability.getPackage_version());
                    logger.println("Fixed_version: " + vulnerability.getFixed_version());
                    logger.println("Link: " + vulnerability.getLink());
                    logger.println("");
                }
                if (scanResult.isScanLayerConfigured()) {
                    logger.println("");
                    if (scanResult.isScanLayerSupported()) {
                        logger.println("**************** Layer Vulnerability History ****************");
                        logger.println("");
                        Set<String> keys = scanResult.getLayeredVulsMap().keySet();
                        for (String key : keys) {
                            Set<Vulnerability> vulSet = scanResult.getLayeredVulsMap().get(key);
                            logger.println("Layer digest " + key + " contains " + vulSet.size() + " vulnerabilities.");
                            logger.println("");
                            for (Vulnerability vulnerability : vulSet) {
                                logger.println("Name: " + vulnerability.getName().toLowerCase() + ", Score: " + vulnerability.getScore() + ", Package_name: " + vulnerability.getPackage_name() + ", Package_version: " + vulnerability.getPackage_version() + ", Fixed_version: " + vulnerability.getFixed_version() + ", Link: " + vulnerability.getLink());
                            }
                        }
                        logger.println("");
                    } else {
                        logger.println("*** Your Controller Does Not Support Layer Vulnerability Scan ***");
                        logger.println("");
                    }
                }
                if (scanResult.isWhiteListVulExisted()) {
                    logger.println("********************** Exempt Vulnerability **********************");
                    if (scanResult.getExistedWhiteListVulSet().size() == 1) {
                        logger.println("The vulnerability " + scanResult.getExistedWhiteListVulSet().iterator().next().toUpperCase() + " is exempt.");
                    } else {
                        logger.println("The vulnerabilities " + String.join((CharSequence)",", scanResult.getExistedWhiteListVulSet()) + " are exempt.");
                    }
                }
            }
        }
    }

    public void testConnection() throws IOException {
        try (CloseableHttpClient httpclient = this.makeHttpClient();){
            this.getToken(httpclient);
            this.logout(httpclient);
        }
    }

    private String getSeverity(Double score, Double highSeverityThreshold, Double mediumSeverityThreshold) {
        String severity = "";
        if (score != null) {
            if (score >= highSeverityThreshold) {
                severity = SeverityRating.High.name();
            } else if (score >= mediumSeverityThreshold) {
                severity = SeverityRating.Medium.name();
            }
        }
        return severity;
    }

    private CloseableHttpClient makeHttpClient() throws AbortException {
        SSLConnectionSocketFactory sslsf;
        SSLContextBuilder builder = new SSLContextBuilder();
        try {
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            sslsf = new SSLConnectionSocketFactory(builder.build(), (HostnameVerifier)new TrustAllStrategy());
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new AbortException("SSL context builder error.");
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).build();
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setDefaultRequestConfig(config).build();
    }

    private void getToken(CloseableHttpClient httpclient) throws AbortException {
        block24: {
            String uriPathForGetToken = "/v1/auth";
            URI uriForGetToken = this.buildUri(this.config.getControllerIP(), this.config.getControllerPort(), uriPathForGetToken);
            HttpPost httpPostForGetToken = new HttpPost(uriForGetToken);
            httpPostForGetToken.addHeader("Content-Type", "application/json");
            JSONObject passwordJson = new JSONObject();
            passwordJson.put("username", (Object)this.config.getUser());
            passwordJson.put("password", (Object)this.config.getPassword());
            JSONObject httpBodyJson = new JSONObject();
            httpBodyJson.put("password", (Object)passwordJson);
            try {
                httpPostForGetToken.setEntity((HttpEntity)new StringEntity(httpBodyJson.toString()));
            }
            catch (UnsupportedEncodingException e) {
                String causeMessage = "Unsupported encoding from NeuVector Username and/or Password in global configuration.";
                if (this.logger != null) {
                    this.logger.println(causeMessage);
                }
                throw new AbortException(causeMessage);
            }
            try (CloseableHttpResponse httpResponseFromGetToken = httpclient.execute((HttpUriRequest)httpPostForGetToken);){
                int statusCode = httpResponseFromGetToken.getStatusLine().getStatusCode();
                HttpEntity httpEntityFromGetToken = httpResponseFromGetToken.getEntity();
                String serverMessageFromGetToken = EntityUtils.toString((HttpEntity)httpEntityFromGetToken);
                EntityUtils.consume((HttpEntity)httpEntityFromGetToken);
                if (statusCode == 200) {
                    this.token = JSONObject.fromObject((Object)serverMessageFromGetToken).getJSONObject("token").getString("token");
                    break block24;
                }
                if (statusCode == 401 || statusCode == 404 || statusCode == 405) {
                    String causeMessage = "Invalid credential of NeuVector controller";
                    if (this.logger != null) {
                        this.logger.println(causeMessage);
                    }
                    throw new AbortException(causeMessage);
                }
                String causeMessage = "Failed to get token. Http status code: " + statusCode + ". Message: " + serverMessageFromGetToken;
                if (this.logger != null) {
                    this.logger.println(causeMessage);
                }
                throw new AbortException(causeMessage);
            }
            catch (ClientProtocolException e) {
                String causeMessage = "Invalid NeuVector controller IP or port.";
                if (this.logger != null) {
                    this.logger.println(causeMessage);
                }
                throw new AbortException(causeMessage);
            }
            catch (IOException e) {
                String causeMessage = "NeuVector controller connection error.";
                if (this.logger != null) {
                    this.logger.println(causeMessage);
                }
                throw new AbortException(causeMessage);
            }
        }
    }

    private String requestScan(CloseableHttpClient httpclient) throws IOException {
        long startTimeMillis = System.currentTimeMillis();
        int timeoutSeconds = this.config.getTimeout() * 60;
        String uriPathForScan = "/v1/scan/repository";
        URI uriForScan = this.buildUri(this.config.getControllerIP(), this.config.getControllerPort(), uriPathForScan);
        HttpPost httpPostForScan = new HttpPost(uriForScan);
        httpPostForScan.addHeader("Content-Type", "application/json");
        httpPostForScan.addHeader("X-Auth-Token", this.token);
        JSONObject httpBodyJson = new JSONObject();
        JSONObject requestJson = new JSONObject();
        requestJson.put("repository", (Object)this.config.getRepository());
        if (this.config.getTag() != null) {
            requestJson.put("tag", (Object)this.config.getTag());
        }
        if (this.config.getScanMeta() != null) {
            JSONObject metaJson = new JSONObject();
            metaJson.put("source", (Object)this.config.getScanMeta().getSource());
            metaJson.put("user", (Object)this.config.getScanMeta().getUser());
            metaJson.put("job", (Object)this.config.getScanMeta().getJob());
            metaJson.put("workspace", (Object)this.config.getScanMeta().getWorkspace());
            requestJson.put("metadata", (Object)metaJson);
        } else {
            requestJson.put("metadata", null);
        }
        if (this.config.isLocal()) {
            requestJson.put("registry", (Object)"");
            requestJson.put("username", (Object)"");
            requestJson.put("password", (Object)"");
        } else {
            requestJson.put("registry", (Object)this.config.getRegistry().getRegUrl());
            requestJson.put("username", (Object)this.config.getRegistry().getRegUsername());
            requestJson.put("password", (Object)Secret.toString((Secret)this.config.getRegistry().getRegPassword()).trim());
        }
        requestJson.put("scan_layers", (Object)this.config.getScanLayers());
        httpBodyJson.put("request", (Object)requestJson);
        try {
            httpPostForScan.setEntity((HttpEntity)new StringEntity(httpBodyJson.toString()));
        }
        catch (UnsupportedEncodingException e) {
            String causeMessage = "Unsupported encoding from registry, repository or tag.";
            this.logger.println(causeMessage);
            throw new AbortException(causeMessage);
        }
        try (CloseableHttpResponse httpResponseFromScan = null;){
            httpResponseFromScan = httpclient.execute((HttpUriRequest)httpPostForScan);
            while (httpResponseFromScan.getStatusLine().getStatusCode() == 304) {
                long elapsedSeconds;
                if (timeoutSeconds > 0 && (elapsedSeconds = (System.currentTimeMillis() - startTimeMillis) / 1000L) > (long)timeoutSeconds) {
                    String causeMessage = "Time out.";
                    this.logger.println(causeMessage);
                    throw new AbortException(causeMessage);
                }
                httpResponseFromScan = httpclient.execute((HttpUriRequest)httpPostForScan);
                this.logger.println("Scanning in progress...");
            }
            int statusCode = httpResponseFromScan.getStatusLine().getStatusCode();
            HttpEntity httpEntityFromScan = httpResponseFromScan.getEntity();
            String serverMessageFromScan = "N/A";
            if (httpEntityFromScan != null) {
                serverMessageFromScan = EntityUtils.toString((HttpEntity)httpEntityFromScan);
                EntityUtils.consume((HttpEntity)httpEntityFromScan);
            }
            if (statusCode != 200 || httpEntityFromScan == null) {
                String causeMessage = "Scan failed. Http status code: " + statusCode + ". Message: " + serverMessageFromScan;
                this.logger.println(causeMessage);
                throw new AbortException(causeMessage);
            }
            String string = serverMessageFromScan;
            return string;
        }
    }

    private void logout(CloseableHttpClient httpclient) throws IOException {
        String uriPathForLogout = "/v1/auth";
        URI uriForLogout = this.buildUri(this.config.getControllerIP(), this.config.getControllerPort(), uriPathForLogout);
        HttpDelete httpDeleteForLogout = new HttpDelete(uriForLogout);
        httpDeleteForLogout.addHeader("Content-Type", "application/json");
        httpDeleteForLogout.addHeader("X-Auth-Token", this.token);
        CloseableHttpResponse httpResponseFromLogout = httpclient.execute((HttpUriRequest)httpDeleteForLogout);
        httpResponseFromLogout.close();
    }

    private URI buildUri(String host, int port, String path) throws AbortException {
        URI uri;
        try {
            uri = new URIBuilder().setScheme("https").setHost(host).setPort(port).setPath(path).build();
        }
        catch (URISyntaxException e) {
            String causeMessage = "URI syntax error from NeuVector Controller IP and/or API port in global configuration.";
            this.logger.println(causeMessage);
            throw new AbortException(causeMessage);
        }
        return uri;
    }

    private ScanResult processScanReport(String serverMessageFromScan, Config config) throws AbortException {
        ScanResult scanResult = new ScanResult();
        if (config.isLocal()) {
            scanResult.setLocalScan(true);
        } else {
            scanResult.setLocalScan(false);
            scanResult.setRegistry(config.getRegistry().getRegUrl());
        }
        scanResult.setRepository(config.getRepository());
        scanResult.setTag(config.getTag());
        int highSeverityThreshold = 0;
        if (Objects.nonNull(config.getNumberOfHighSeverityToFail()) && !config.getNumberOfHighSeverityToFail().isEmpty()) {
            highSeverityThreshold = Integer.parseInt(config.getNumberOfHighSeverityToFail());
        }
        int mediumSeverityThreshold = 0;
        if (Objects.nonNull(config.getNumberOfMediumSeverityToFail()) && !config.getNumberOfMediumSeverityToFail().isEmpty()) {
            mediumSeverityThreshold = Integer.parseInt(config.getNumberOfMediumSeverityToFail());
        }
        scanResult.setHighSeverityThreshold(highSeverityThreshold);
        scanResult.setMediumSeverityThreshold(mediumSeverityThreshold);
        HashSet<String> vulBlackListSet = new HashSet<String>();
        HashSet<String> vulWhiteListSet = new HashSet<String>();
        if (config.getNameOfVulnerabilityToFailOne() != null && !config.getNameOfVulnerabilityToFailOne().isEmpty()) {
            vulBlackListSet.add(config.getNameOfVulnerabilityToFailOne().toLowerCase());
        }
        if (config.getNameOfVulnerabilityToFailTwo() != null && !config.getNameOfVulnerabilityToFailTwo().isEmpty()) {
            vulBlackListSet.add(config.getNameOfVulnerabilityToFailTwo().toLowerCase());
        }
        if (config.getNameOfVulnerabilityToFailThree() != null && !config.getNameOfVulnerabilityToFailThree().isEmpty()) {
            vulBlackListSet.add(config.getNameOfVulnerabilityToFailThree().toLowerCase());
        }
        if (config.getNameOfVulnerabilityToFailFour() != null && !config.getNameOfVulnerabilityToFailFour().isEmpty()) {
            vulBlackListSet.add(config.getNameOfVulnerabilityToFailFour().toLowerCase());
        }
        if (config.getNameOfVulnerabilityToExemptOne() != null && !config.getNameOfVulnerabilityToExemptOne().isEmpty()) {
            vulWhiteListSet.add(config.getNameOfVulnerabilityToExemptOne().toLowerCase());
        }
        if (config.getNameOfVulnerabilityToExemptTwo() != null && !config.getNameOfVulnerabilityToExemptTwo().isEmpty()) {
            vulWhiteListSet.add(config.getNameOfVulnerabilityToExemptTwo().toLowerCase());
        }
        if (config.getNameOfVulnerabilityToExemptThree() != null && !config.getNameOfVulnerabilityToExemptThree().isEmpty()) {
            vulWhiteListSet.add(config.getNameOfVulnerabilityToExemptThree().toLowerCase());
        }
        if (config.getNameOfVulnerabilityToExemptFour() != null && !config.getNameOfVulnerabilityToExemptFour().isEmpty()) {
            vulWhiteListSet.add(config.getNameOfVulnerabilityToExemptFour().toLowerCase());
        }
        scanResult.setBlackListVulSet(vulBlackListSet);
        scanResult.setWhiteListVulSet(vulWhiteListSet);
        JSONObject reportJson = JSONObject.fromObject((Object)serverMessageFromScan).getJSONObject("report");
        if (reportJson.isNullObject()) {
            String causeMessage = "Scan failed. Error Message: " + JSONObject.fromObject((Object)serverMessageFromScan).get("error_message").toString();
            this.logger.println(causeMessage);
            throw new AbortException(causeMessage);
        }
        int totalVulnerabilityNumber = 0;
        int totalHighSeverity = 0;
        int totalMediumSeverity = 0;
        boolean isSeverityScaleCustomized = config.getCustomizedRatingScale();
        Double highSeverityScaleThreshold = config.getHighSeverityThreshold();
        Double mediumSeverityScaleThreshold = config.getMediumSeverityThreshold();
        boolean hasBlackListVuls = false;
        boolean hasWhiteListVuls = false;
        HashSet<String> existedBlackListVulSet = new HashSet<String>();
        HashSet<String> existedWhiteListVulSet = new HashSet<String>();
        HashSet<Vulnerability> highVulnerabilitySet = new HashSet<Vulnerability>();
        HashSet<Vulnerability> mediumVulnerabilitySet = new HashSet<Vulnerability>();
        JSONArray vulnerabilityArray = reportJson.getJSONArray("vulnerabilities");
        if (vulnerabilityArray.size() > 0) {
            for (int i = 0; i < vulnerabilityArray.size(); ++i) {
                JSONObject vulnerabilityObject = vulnerabilityArray.getJSONObject(i);
                String name = vulnerabilityObject.getString("name").toLowerCase();
                if (!vulBlackListSet.isEmpty() && vulBlackListSet.contains(name)) {
                    hasBlackListVuls = true;
                    existedBlackListVulSet.add(name.toUpperCase());
                }
                if (vulWhiteListSet.isEmpty() || !vulWhiteListSet.contains(name)) {
                    String severity;
                    ++totalVulnerabilityNumber;
                    if (isSeverityScaleCustomized) {
                        String s_score = vulnerabilityObject.getString("score");
                        severity = this.getSeverity(Double.parseDouble(s_score), highSeverityScaleThreshold, mediumSeverityScaleThreshold);
                    } else {
                        severity = vulnerabilityObject.getString("severity");
                    }
                    Vulnerability vulnerability = new Vulnerability();
                    vulnerability.setName(name);
                    vulnerability.setLink(vulnerabilityObject.getString("link"));
                    vulnerability.setScore(Float.valueOf(vulnerabilityObject.getString("score")).floatValue());
                    vulnerability.setPackage_name(vulnerabilityObject.getString("package_name"));
                    vulnerability.setPackage_version(vulnerabilityObject.getString("package_version"));
                    vulnerability.setFixed_version(vulnerabilityObject.getString("fixed_version"));
                    vulnerability.setVectors(vulnerabilityObject.getString("vectors"));
                    vulnerability.setDescription(vulnerabilityObject.getString("description"));
                    vulnerability.setFeed_rating(vulnerabilityObject.getString("feed_rating"));
                    if (severity.equalsIgnoreCase("High")) {
                        ++totalHighSeverity;
                        vulnerability.setSeverity("High");
                        highVulnerabilitySet.add(vulnerability);
                        continue;
                    }
                    if (!severity.equalsIgnoreCase("Medium")) continue;
                    ++totalMediumSeverity;
                    vulnerability.setSeverity("Medium");
                    mediumVulnerabilitySet.add(vulnerability);
                    continue;
                }
                hasWhiteListVuls = true;
                existedWhiteListVulSet.add(name.toUpperCase());
            }
            scanResult.setBlackListVulExisted(hasBlackListVuls);
            scanResult.setWhiteListVulExisted(hasWhiteListVuls);
            scanResult.setExistedBlackListVulSet(existedBlackListVulSet);
            scanResult.setExistedWhiteListVulSet(existedWhiteListVulSet);
            scanResult.setTotalVulnerabilityNumber(totalVulnerabilityNumber);
            scanResult.setHighSeverityNumber(totalHighSeverity);
            scanResult.setMediumSeverityNumber(totalMediumSeverity);
            scanResult.setHighVulnerabilitySet(highVulnerabilitySet);
            scanResult.setMediumVulnerabilitySet(mediumVulnerabilitySet);
            if (config.getScanLayers()) {
                scanResult.setScanLayerConfigured(true);
                if (reportJson.has("layers")) {
                    scanResult.setScanLayerSupported(true);
                    JSONArray layerArray = reportJson.getJSONArray("layers");
                    LinkedHashMap<String, Set<Vulnerability>> layeredVulnerabilityMap = new LinkedHashMap<String, Set<Vulnerability>>();
                    for (int i = 0; i < layerArray.size(); ++i) {
                        JSONObject layerObject = layerArray.getJSONObject(i);
                        String layerDigest = layerObject.getString("digest").substring(0, 12);
                        JSONArray layerVulnerabilityArray = layerObject.getJSONArray("vulnerabilities");
                        HashSet<Vulnerability> layeredVulnerabilitySet = new HashSet<Vulnerability>();
                        for (int j = 0; j < layerVulnerabilityArray.size(); ++j) {
                            JSONObject layerVulnerabilityObject = layerVulnerabilityArray.getJSONObject(j);
                            String vulnerabilityName = layerVulnerabilityObject.getString("name").toLowerCase();
                            if (hasWhiteListVuls && vulWhiteListSet.contains(vulnerabilityName)) continue;
                            Vulnerability vulnerability = new Vulnerability();
                            vulnerability.setName(vulnerabilityName);
                            vulnerability.setScore(Float.valueOf(layerVulnerabilityObject.getString("score")).floatValue());
                            vulnerability.setPackage_name(layerVulnerabilityObject.getString("package_name"));
                            vulnerability.setPackage_version(layerVulnerabilityObject.getString("package_version"));
                            vulnerability.setFixed_version(layerVulnerabilityObject.getString("fixed_version"));
                            vulnerability.setLink(layerVulnerabilityObject.getString("link"));
                            vulnerability.setFeed_rating(layerVulnerabilityObject.getString("feed_rating"));
                            layeredVulnerabilitySet.add(vulnerability);
                        }
                        layeredVulnerabilityMap.put(layerDigest, layeredVulnerabilitySet);
                    }
                    scanResult.setLayeredVulsMap(layeredVulnerabilityMap);
                } else {
                    scanResult.setScanLayerSupported(false);
                }
            } else {
                scanResult.setScanLayerConfigured(false);
            }
        } else {
            scanResult.setTotalVulnerabilityNumber(totalVulnerabilityNumber);
            scanResult.setScanSummary("Scanned. No vulnerabilities found.");
        }
        return scanResult;
    }

    private void makeIfFailDecision(int currentHighSeverity, int currentMediumSeverity, boolean foundName, Set<String> namesToPresent) throws AbortException {
        int configNumberOfMedium;
        int configNumberOfHigh;
        boolean numberExceed = false;
        StringBuilder statementBuilder = new StringBuilder();
        if (this.config.getNumberOfHighSeverityToFail() != null && !this.config.getNumberOfHighSeverityToFail().isEmpty() && (configNumberOfHigh = Integer.parseInt(this.config.getNumberOfHighSeverityToFail())) != 0 && configNumberOfHigh <= currentHighSeverity) {
            numberExceed = true;
            statementBuilder.append(currentHighSeverity).append(" High severity vulnerabilities");
        }
        if (this.config.getNumberOfMediumSeverityToFail() != null && !this.config.getNumberOfMediumSeverityToFail().isEmpty() && (configNumberOfMedium = Integer.parseInt(this.config.getNumberOfMediumSeverityToFail())) != 0 && configNumberOfMedium <= currentMediumSeverity) {
            if (numberExceed) {
                statementBuilder.append(", ");
            }
            numberExceed = true;
            statementBuilder.append(currentMediumSeverity).append(" Medium severity vulnerabilities");
        }
        if (foundName) {
            if (numberExceed) {
                statementBuilder.append(", and ");
            }
            statementBuilder.append("vulnerabilities: ").append(namesToPresent.toString());
        }
        this.logger.println("");
        this.logger.println("****************** NeuVector scan summary *******************");
        if (numberExceed || foundName) {
            statementBuilder.append(" are present.");
            String causeMessage = "Build failed because " + statementBuilder;
            this.logger.println(causeMessage);
            throw new AbortException(causeMessage);
        }
        StringBuilder messageBuilder = new StringBuilder();
        if (!this.config.isLocal()) {
            messageBuilder.append("Registry URL: ").append(this.config.getRegistry().getRegUrl()).append(", ");
        }
        messageBuilder.append("Repository: ").append(this.config.getRepository()).append(", ").append("Tag: ").append(this.config.getTag()).append(", ").append("Total vulnerabilities: ").append(currentHighSeverity + currentMediumSeverity).append(", ").append("High severity vulnerabilities: ").append(currentHighSeverity).append(", ").append("Medium severity vulnerabilities: ").append(currentMediumSeverity).toString();
        this.logger.println(messageBuilder.toString());
    }

    private String generateScannerName() {
        String saltChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        StringBuilder salt = new StringBuilder();
        Random rnd = new Random();
        while (salt.length() < 6) {
            int index = (int)(rnd.nextFloat() * (float)saltChars.length());
            salt.append(saltChars.charAt(index));
        }
        return salt.toString();
    }
}

