/*
 * Decompiled with CFR 0.152.
 */
package de.westemeyer.plugins.multiselect.parser;

import com.opencsv.CSVWriter;
import de.westemeyer.plugins.multiselect.MultiselectDecisionItem;
import de.westemeyer.plugins.multiselect.MultiselectDecisionItemVisitor;
import de.westemeyer.plugins.multiselect.MultiselectDecisionTree;
import de.westemeyer.plugins.multiselect.MultiselectVariableDescriptor;
import de.westemeyer.plugins.multiselect.parser.ConfigSerialization;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CsvWriter
implements ConfigSerialization {
    @Override
    public void serialize(MultiselectDecisionTree decisionTree, OutputStream outputStream) throws Exception {
        try (OutputStreamWriter streamWriter = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
             CSVWriter writer = new CSVWriter((Writer)streamWriter);){
            this.writeList("H", decisionTree.getVariableLabels(), writer);
            this.writeList("V", decisionTree.getVariableNames(), writer);
            decisionTree.visitSubTree(new CvwWriterVisitor(writer));
        }
    }

    private void writeList(String prefix, List<String> values, CSVWriter writer) {
        if (values != null && !values.isEmpty()) {
            String[] line = new String[values.size() + 1];
            line[0] = prefix;
            int i = 1;
            Iterator<String> iterator = values.iterator();
            while (iterator.hasNext()) {
                String value;
                line[i] = value = iterator.next();
                ++i;
            }
            writer.writeNext(line, false);
        }
    }

    private static class CvwWriterVisitor
    implements MultiselectDecisionItemVisitor {
        private final CSVWriter writer;

        private CvwWriterVisitor(CSVWriter writer) {
            this.writer = writer;
        }

        @Override
        public boolean visit(MultiselectDecisionItem item, MultiselectVariableDescriptor column) throws Exception {
            if (item.isLeaf()) {
                ArrayList<String> labels = new ArrayList<String>();
                ArrayList<String> values = new ArrayList<String>();
                boolean hasLabels = false;
                do {
                    hasLabels |= this.appendValue(labels, item.getLabel());
                    this.appendValue(values, item.getValue());
                } while ((item = item.getParent()) != null);
                if (hasLabels) {
                    this.reverseAndWrite("T", labels);
                }
                this.reverseAndWrite("C", values);
            }
            return true;
        }

        private void reverseAndWrite(String type, List<String> values) {
            values.add(type);
            Collections.reverse(values);
            String[] labelsArray = values.toArray(new String[0]);
            this.writer.writeNext(labelsArray, false);
        }

        boolean appendValue(List<String> columns, String value) {
            if (value != null) {
                columns.add(value);
                return !value.isEmpty();
            }
            return false;
        }
    }
}

