/*
 * Decompiled with CFR 0.152.
 */
package de.westemeyer.plugins.multiselect.parser;

import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import de.westemeyer.plugins.multiselect.Messages;
import de.westemeyer.plugins.multiselect.MultiselectDecisionItem;
import de.westemeyer.plugins.multiselect.MultiselectDecisionTree;
import de.westemeyer.plugins.multiselect.MultiselectVariableDescriptor;
import de.westemeyer.plugins.multiselect.parser.ConfigParser;
import de.westemeyer.plugins.multiselect.parser.ValueConstructionHelper;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class CsvParser
implements ConfigParser {
    private static final Logger LOGGER = Logger.getLogger(CsvParser.class.getName());
    private String validationResult = null;

    @Override
    public MultiselectDecisionTree analyzeConfiguration(InputStream config) {
        InputStreamReader reader = new InputStreamReader(config, StandardCharsets.UTF_8);
        CSVReader csvReader = new CSVReaderBuilder((Reader)reader).build();
        List<String> headers = null;
        List<String> variableNames = null;
        List<String> titles = null;
        MultiselectDecisionTree decisionTree = new MultiselectDecisionTree();
        ValueConstructionHelper constructionHelper = new ValueConstructionHelper(null);
        int index = 1;
        for (String[] row : csvReader) {
            if (row.length < 2) continue;
            RowType type = RowType.of(row[0]);
            List<String> subList = Arrays.stream(row).skip(1L).collect(Collectors.toList());
            switch (type) {
                case HEADER: {
                    headers = subList;
                    break;
                }
                case VARIABLENAME: {
                    variableNames = subList;
                    break;
                }
                case TITLE: {
                    titles = subList;
                    if (variableNames == null || subList.size() <= variableNames.size()) break;
                    this.validationResult = Messages.FormValidation_NotEnoughColumns(index);
                    break;
                }
                case CONTENT: {
                    if (variableNames != null && subList.size() > variableNames.size()) {
                        this.validationResult = Messages.FormValidation_NotEnoughColumns(index);
                    }
                    this.addItems(constructionHelper, titles, subList);
                    titles = null;
                    break;
                }
                default: {
                    LOGGER.log(Level.INFO, "Invalid configuration value");
                }
            }
            ++index;
        }
        ArrayList<MultiselectVariableDescriptor> variableDescriptions = new ArrayList<MultiselectVariableDescriptor>();
        if (variableNames == null) {
            this.validationResult = Messages.FormValidation_NoVariablesDefined();
        }
        if (variableNames != null || headers != null) {
            int variableNamesSize = this.size(variableNames);
            int headersSize = this.size(headers);
            for (int i = 0; i < Math.max(variableNamesSize, headersSize); ++i) {
                String label = this.get(headers, i);
                String variable = this.get(variableNames, i);
                variableDescriptions.add(new MultiselectVariableDescriptor(label, variable, i));
            }
        }
        decisionTree.setItemList(constructionHelper.createItemList());
        decisionTree.setVariableDescriptions(variableDescriptions);
        return decisionTree;
    }

    private int size(List<String> list) {
        return list == null ? 0 : list.size();
    }

    private String get(List<String> list, int index) {
        return list != null && index < list.size() ? list.get(index) : null;
    }

    @Override
    public String getValidationResult() {
        return this.validationResult;
    }

    private void addItems(ValueConstructionHelper rootHelper, List<String> headers, List<String> values) {
        ValueConstructionHelper currentHelper = rootHelper;
        for (int i = 0; i < values.size(); ++i) {
            ValueConstructionHelper valueHelper;
            String value = values.get(i);
            String title = "";
            if (headers != null && headers.size() > i) {
                title = headers.get(i);
            }
            if ((valueHelper = currentHelper.getValueHelper(value)) == null) {
                valueHelper = new ValueConstructionHelper(new MultiselectDecisionItem(currentHelper.getDecisionItem(), title, value));
                currentHelper.addValueHelper(value, valueHelper);
            }
            currentHelper = valueHelper;
        }
    }

    private static enum RowType {
        HEADER("H"),
        VARIABLENAME("V"),
        TITLE("T"),
        CONTENT("C"),
        UNKNOWN("");

        private final String marker;

        private RowType(String marker) {
            this.marker = marker;
        }

        static RowType of(String marker) {
            for (RowType rowType : RowType.values()) {
                if (!rowType.marker.equals(marker)) continue;
                return rowType;
            }
            return UNKNOWN;
        }
    }
}

