/*
 * Decompiled with CFR 0.152.
 */
package de.westemeyer.plugins.multiselect;

import de.westemeyer.plugins.multiselect.MultiselectConfigurationFormat;
import de.westemeyer.plugins.multiselect.MultiselectDecisionItem;
import de.westemeyer.plugins.multiselect.MultiselectDecisionItemVisitor;
import de.westemeyer.plugins.multiselect.MultiselectParameterDefinition;
import de.westemeyer.plugins.multiselect.MultiselectVariableDescriptor;
import de.westemeyer.plugins.multiselect.parser.ConfigSerialization;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class MultiselectDecisionTree
implements Serializable {
    private static final long serialVersionUID = -5015514196308288683L;
    private static final Logger LOGGER = Logger.getLogger(MultiselectDecisionTree.class.getName());
    private List<MultiselectDecisionItem> itemList = new ArrayList<MultiselectDecisionItem>();
    private List<MultiselectVariableDescriptor> variableDescriptions = new ArrayList<MultiselectVariableDescriptor>();

    public List<MultiselectDecisionItem> getInitialValuesForColumn(int column) {
        List<MultiselectDecisionItem> items = this.getItemList();
        for (int i = 1; i <= column && !items.isEmpty(); ++i) {
            items = items.get(0).getChildren();
        }
        return items;
    }

    public MultiselectDecisionItem getItemByCoordinates(Integer ... coordinates) throws Exception {
        Queue<Integer> itemPath = MultiselectParameterDefinition.createCoordinates(coordinates);
        AtomicReference ref = new AtomicReference();
        this.visitSelectedItems(itemPath, (item, column) -> {
            if (column.getColumnIndex() == coordinates.length - 1) {
                ref.set(item);
                return false;
            }
            return true;
        });
        return (MultiselectDecisionItem)ref.get();
    }

    public void serialize(ConfigSerialization serialization, OutputStream outputStream) throws Exception {
        serialization.serialize(this, outputStream);
    }

    public void visitSubTree(MultiselectDecisionItemVisitor visitor) throws Exception {
        MultiselectDecisionItem.visitSubTree(visitor, this.itemList, new ArrayDeque<MultiselectVariableDescriptor>(this.variableDescriptions));
    }

    public void visitSelectedItems(Queue<Integer> itemPath, MultiselectDecisionItemVisitor visitor) throws Exception {
        MultiselectDecisionItem.visitSelectedItems(visitor, this.itemList, new ArrayDeque<MultiselectVariableDescriptor>(this.variableDescriptions), itemPath);
    }

    public static MultiselectDecisionTree parse(String csvInput) {
        ByteArrayInputStream resourceAsStream = new ByteArrayInputStream(csvInput.getBytes(StandardCharsets.UTF_8));
        return MultiselectConfigurationFormat.CSV.createParser().analyzeConfiguration(resourceAsStream);
    }

    public Map<String, String> resolveValues(Map<String, Integer> selectedValues) throws Exception {
        Queue indexOrder = this.variableDescriptions.stream().map(MultiselectVariableDescriptor::getVariableName).map(selectedValues::get).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayDeque::new));
        HashMap<String, String> properties = new HashMap<String, String>();
        this.visitSelectedItems(indexOrder, (item, column) -> {
            properties.put(column.getVariableName(), item.getValue());
            return true;
        });
        return properties;
    }

    public List<MultiselectDecisionItem> getItemList() {
        return this.itemList;
    }

    public void setItemList(List<MultiselectDecisionItem> itemList) {
        this.itemList = itemList;
    }

    public List<MultiselectVariableDescriptor> getVariableDescriptions() {
        return this.variableDescriptions;
    }

    public List<String> getVariableLabels() {
        return this.extractStrings(MultiselectVariableDescriptor::getLabel);
    }

    public List<String> getVariableNames() {
        return this.extractStrings(MultiselectVariableDescriptor::getVariableName);
    }

    private List<String> extractStrings(Function<MultiselectVariableDescriptor, String> extractor) {
        return this.variableDescriptions.stream().map(extractor).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void setVariableDescriptions(List<MultiselectVariableDescriptor> variableDescriptions) {
        this.variableDescriptions = variableDescriptions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            ConfigSerialization writer = MultiselectConfigurationFormat.CSV.createWriter();
            this.serialize(writer, byteArrayOutputStream);
            String string = byteArrayOutputStream.toString(StandardCharsets.UTF_8.toString());
            return string;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error serializing configuration", e);
            return "";
        }
    }
}

