/*
 * Decompiled with CFR 0.152.
 */
package de.westemeyer.plugins.multiselect;

import de.westemeyer.plugins.multiselect.MultiselectDecisionItemVisitor;
import de.westemeyer.plugins.multiselect.MultiselectVariableDescriptor;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;

public class MultiselectDecisionItem
implements Serializable {
    private static final long serialVersionUID = -7959174754803921973L;
    private final String label;
    private String value;
    private List<MultiselectDecisionItem> children = new ArrayList<MultiselectDecisionItem>();
    private final MultiselectDecisionItem parent;

    public MultiselectDecisionItem(MultiselectDecisionItem parent, String label, String value) {
        this.parent = parent;
        this.label = label;
        this.value = value;
    }

    public void visitSubTree(MultiselectDecisionItemVisitor visitor, Queue<MultiselectVariableDescriptor> columns) throws Exception {
        MultiselectDecisionItem.visitSubTree(visitor, this.children, columns);
    }

    public static void visitSubTree(MultiselectDecisionItemVisitor visitor, List<MultiselectDecisionItem> items, Queue<MultiselectVariableDescriptor> columns) throws Exception {
        MultiselectVariableDescriptor column = columns.poll();
        for (MultiselectDecisionItem subItem : items) {
            if (!visitor.visit(subItem, column)) continue;
            subItem.visitSubTree(visitor, new ArrayDeque<MultiselectVariableDescriptor>(columns));
        }
    }

    public void visitSelectedItems(MultiselectDecisionItemVisitor visitor, Queue<MultiselectVariableDescriptor> columns, Queue<Integer> itemPath) throws Exception {
        MultiselectDecisionItem.visitSelectedItems(visitor, this.children, columns, itemPath);
    }

    public static void visitSelectedItems(MultiselectDecisionItemVisitor visitor, List<MultiselectDecisionItem> items, Queue<MultiselectVariableDescriptor> columns, Queue<Integer> itemPath) throws Exception {
        MultiselectDecisionItem subItem;
        Integer index = itemPath.poll();
        if (index != null && visitor.visit(subItem = items.get(index), columns.poll())) {
            subItem.visitSelectedItems(visitor, new ArrayDeque<MultiselectVariableDescriptor>(columns), itemPath);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public List<MultiselectDecisionItem> getChildren() {
        return this.children;
    }

    public void setChildren(List<MultiselectDecisionItem> children) {
        this.children = children;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public MultiselectDecisionItem getParent() {
        return this.parent;
    }

    public String getDisplayLabel() {
        if (this.label == null || this.label.length() == 0) {
            return this.value;
        }
        return this.label;
    }

    public String toString() {
        return "MultiselectDecisionItem{label='" + this.nvl(this.label) + '\'' + ", value='" + this.value + '\'' + ", children=" + this.children + '}';
    }

    private String nvl(String input) {
        return input == null ? "" : input;
    }
}

