/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.polyspace.jenkins.config;

import com.mathworks.polyspace.jenkins.config.Messages;
import com.mathworks.polyspace.jenkins.config.PolyspaceConfigUtils;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.File;
import java.util.ArrayList;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class PolyspaceBinConfig
extends AbstractDescribableImpl<PolyspaceBinConfig> {
    private String name;
    private String polyspacePath;

    @DataBoundConstructor
    public PolyspaceBinConfig() {
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    @DataBoundSetter
    public void setPolyspacePath(String polyspacePath) {
        this.polyspacePath = polyspacePath;
    }

    public String getName() {
        return this.name;
    }

    public String getPolyspacePath() {
        return this.polyspacePath;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<PolyspaceBinConfig> {
        public String getDisplayName() {
            return Messages.polyspaceBinConfigDisplayName();
        }

        public FormValidation doCheckPolyspacePath(@QueryParameter String polyspacePath) {
            String command;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                PolyspaceConfigUtils.checkPolyspaceBinFolderExists(polyspacePath);
                command = polyspacePath + File.separator + "polyspace-bug-finder" + PolyspaceConfigUtils.exeSuffix();
                try {
                    PolyspaceConfigUtils.checkPolyspaceBinCommandExists(command);
                }
                catch (FormValidation val1) {
                    try {
                        command = polyspacePath + File.separator + "polyspace-bug-finder-server" + PolyspaceConfigUtils.exeSuffix();
                        PolyspaceConfigUtils.checkPolyspaceBinCommandExists(command);
                    }
                    catch (FormValidation val2) {
                        command = polyspacePath + File.separator + "polyspace-bug-finder-nodesktop" + PolyspaceConfigUtils.exeSuffix();
                        PolyspaceConfigUtils.checkPolyspaceBinCommandExists(command);
                    }
                }
            }
            catch (FormValidation val) {
                return val;
            }
            ArrayList<String> polyspace = new ArrayList<String>();
            polyspace.add(command);
            polyspace.add("-h");
            String commandString = StringUtils.join(polyspace, (char)' ');
            if (PolyspaceConfigUtils.checkPolyspaceCommand(polyspace).booleanValue()) {
                return FormValidation.ok((String)Messages.polyspaceCorrectConfig());
            }
            return FormValidation.error((String)(Messages.polyspaceBinWrongConfig() + " '" + commandString + "'"));
        }
    }
}

