/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.polyspace.jenkins;

import com.mathworks.polyspace.jenkins.PolyspaceBuildWrapper;
import com.mathworks.polyspace.jenkins.PolyspaceHelpers;
import com.mathworks.polyspace.jenkins.config.Messages;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Mailer;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.annotation.Nonnull;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.Multipart;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class PolyspacePostBuildActions
extends Notifier
implements SimpleBuildStep {
    public Boolean sendToRecipients;
    public String recipients;
    public String fileToAttach;
    public String mailSubject;
    public String mailBody;
    public Boolean sendToOwners;
    public String queryBaseName;
    public String mailSubjectBaseName;
    public String mailBodyBaseName;
    public String uniqueRecipients;
    private static Pattern ADDRESS_PATTERN = Pattern.compile("\\s*([^<]*)<([^>]+)>\\s*");

    @DataBoundConstructor
    public PolyspacePostBuildActions() {
    }

    @DataBoundSetter
    public void setSendToRecipients(Boolean sendToRecipients) {
        this.sendToRecipients = sendToRecipients;
    }

    @DataBoundSetter
    public void setRecipients(String recipients) {
        this.recipients = recipients;
    }

    @DataBoundSetter
    public void setFileToAttach(String fileToAttach) {
        this.fileToAttach = fileToAttach;
    }

    @DataBoundSetter
    public void setMailSubject(String mailSubject) {
        this.mailSubject = mailSubject;
    }

    @DataBoundSetter
    public void setMailBody(String mailBody) {
        this.mailBody = mailBody;
    }

    @DataBoundSetter
    public void setSendToOwners(Boolean sendToOwners) {
        this.sendToOwners = sendToOwners;
    }

    @DataBoundSetter
    public void setQueryBaseName(String queryBaseName) {
        this.queryBaseName = queryBaseName;
    }

    @DataBoundSetter
    public void setMailSubjectBaseName(String mailSubjectBaseName) {
        this.mailSubjectBaseName = mailSubjectBaseName;
    }

    @DataBoundSetter
    public void setMailBodyBaseName(String mailBodyBaseName) {
        this.mailBodyBaseName = mailBodyBaseName;
    }

    @DataBoundSetter
    public void setUniqueRecipients(String uniqueRecipients) {
        this.uniqueRecipients = uniqueRecipients;
    }

    private JenkinsLocationConfiguration getJenkinsLocationConfiguration() {
        JenkinsLocationConfiguration jlc = JenkinsLocationConfiguration.get();
        if (jlc == null) {
            throw new IllegalStateException("JenkinsLocationConfiguration not available");
        }
        return jlc;
    }

    private String getAttachName(String attachSource) {
        File f;
        if (attachSource != null && !attachSource.equals("") && (f = new File(attachSource)).exists() && !f.isDirectory()) {
            return f.getName();
        }
        return "";
    }

    public void sendMail(@QueryParameter String sendMailTo, @QueryParameter String subject, @QueryParameter String text, @QueryParameter String attachSource, @QueryParameter String attachName) throws IOException {
        try {
            String charset = Mailer.descriptor().getCharset();
            MimeMessage msg = new MimeMessage(Mailer.descriptor().createSession());
            msg.setSubject(subject, charset);
            msg.setFrom((Address)PolyspacePostBuildActions.stringToAddress(this.getJenkinsLocationConfiguration().getAdminAddress(), charset));
            String replyToAddress = Mailer.descriptor().getReplyToAddress();
            if (StringUtils.isNotBlank((String)replyToAddress)) {
                msg.setReplyTo(new Address[]{PolyspacePostBuildActions.stringToAddress(replyToAddress, charset)});
            }
            msg.setSentDate(new Date());
            StringTokenizer tokens = new StringTokenizer(sendMailTo, " ,;");
            while (tokens.hasMoreTokens()) {
                msg.addRecipient(Message.RecipientType.TO, (Address)PolyspacePostBuildActions.stringToAddress(tokens.nextToken(), charset));
            }
            MimeMultipart multipart = new MimeMultipart();
            if (!attachName.equals("")) {
                File file = new File(attachSource);
                if (file.length() > 0xA00000L) {
                    text = (String)text + "\n\nSize of the attached file is too large  -  Not attached\n";
                } else {
                    MimeBodyPart attachmentBodyPart = new MimeBodyPart();
                    FileDataSource source = new FileDataSource(attachSource);
                    attachmentBodyPart.setDataHandler(new DataHandler((DataSource)source));
                    attachmentBodyPart.setFileName(attachName);
                    multipart.addBodyPart((BodyPart)attachmentBodyPart);
                }
            }
            MimeBodyPart textBodyPart = new MimeBodyPart();
            textBodyPart.setText((String)text, charset);
            multipart.addBodyPart((BodyPart)textBodyPart);
            msg.setContent((Multipart)multipart);
            Transport.send((Message)msg);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private String getFilenameOwner(String name, String owner, FilePath workspace) throws IOException {
        String fileName = workspace + File.separator;
        fileName = owner.equals("") ? fileName + name : fileName + name + PolyspaceHelpers.getReportOwner(name, owner);
        FileInputStream inputStream = new FileInputStream(fileName);
        return IOUtils.toString((InputStream)inputStream);
    }

    private String generateMailBody(String body, String owner, String attachName, String attachSource, FilePath workspace, Run<?, ?> build) {
        try {
            if (body != null && !body.equals("")) {
                return this.getFilenameOwner(body, owner, workspace);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Object text = "";
        text = owner.equals("") ? (String)text + "General email sent by Polyspace Jenkins Plugin\n\n" : (String)text + "Dear " + owner + ",\nPlease find attached the findings you own.\n\n";
        if (!attachName.equals("")) {
            text = (String)text + "Please check attached file " + attachName + "\n";
            try {
                text = (String)text + "It contains " + PolyspaceHelpers.reportCountFindings(attachSource) + " finding(s)\n";
            }
            catch (RuntimeException e) {
                text = (String)text + "Cannot count nb of findings";
            }
            catch (Exception e) {
                text = (String)text + "Cannot count nb of findings";
            }
        } else if (!attachSource.equals("")) {
            text = (String)text + "Warning: Could not attach " + attachSource + "\n";
        }
        text = (String)text + "\n";
        text = (String)text + "Check Jenkins console output at " + this.getJenkinsLocationConfiguration().getUrl() + build.getUrl() + "\n";
        text = (String)text + "Polyspace configuration is using\n";
        if (!PolyspaceBuildWrapper.descriptor().getPolyspaceAccessURL().equals("POLYSPACE_ACCESS_URL_IS_UNSET")) {
            text = (String)text + "- Polyspace Access " + PolyspaceBuildWrapper.descriptor().getPolyspaceAccessURL() + "\n";
        }
        if (!PolyspaceBuildWrapper.descriptor().getPolyspaceMetricsURL().equals("")) {
            text = (String)text + "- Polyspace Metrics " + PolyspaceBuildWrapper.descriptor().getPolyspaceMetricsURL() + "\n";
        }
        return text;
    }

    private String generateMailSubject(String subject, String owner, FilePath workspace, Run<?, ?> build) {
        try {
            if (subject != null && !subject.equals("")) {
                return this.getFilenameOwner(subject, owner, workspace);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Object text = "";
        text = (String)text + "Polyspace Jenkins Plugin";
        text = (String)text + " - " + build.getFullDisplayName();
        text = (String)text + " - " + build.getResult();
        text = owner.equals("") ? (String)text + " - General Email" : (String)text + " - Email to Finding Owners";
        return text;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException {
        String ownerList;
        String listName;
        if (this.sendToRecipients.booleanValue() && this.recipients != null && !this.recipients.equals("")) {
            Object attachSource = "";
            String attachName = "";
            if (this.fileToAttach != null && !this.fileToAttach.equals("")) {
                attachSource = workspace + File.separator + this.fileToAttach;
                attachName = this.getAttachName((String)attachSource);
            }
            this.sendMail(this.recipients, this.generateMailSubject(this.mailSubject, "", workspace, build), this.generateMailBody(this.mailBody, "", attachName, (String)attachSource, workspace, build), (String)attachSource, attachName);
        }
        if (this.sendToOwners.booleanValue() && this.queryBaseName != null && !this.queryBaseName.equals("") && !(listName = this.getAttachName(ownerList = workspace + File.separator + PolyspaceHelpers.getReportOwnerList(this.queryBaseName))).equals("")) {
            String owner;
            FileInputStream inputStream = new FileInputStream(ownerList);
            InputStreamReader fr = new InputStreamReader((InputStream)inputStream, Mailer.descriptor().getCharset());
            BufferedReader br = new BufferedReader(fr);
            while ((owner = br.readLine()) != null) {
                String to = this.uniqueRecipients.equals("") ? owner : this.uniqueRecipients;
                String attachSource = workspace + File.separator + PolyspaceHelpers.getReportOwner(this.queryBaseName, owner);
                String attachName = this.getAttachName(attachSource);
                this.sendMail(to, this.generateMailSubject(this.mailSubjectBaseName, owner, workspace, build), this.generateMailBody(this.mailBodyBaseName, owner, attachName, attachSource, workspace, build), attachSource, attachName);
            }
            br.close();
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Nonnull
    public static InternetAddress stringToAddress(@Nonnull String strAddress, @Nonnull String charset) throws AddressException, UnsupportedEncodingException {
        Matcher m = ADDRESS_PATTERN.matcher(strAddress);
        if (!m.matches()) {
            return new InternetAddress(strAddress);
        }
        String personal = m.group(1);
        String address = m.group(2);
        return new InternetAddress(address, personal, charset);
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return Messages.polyspaceNotification();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

