/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.polyspace.jenkins;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class PolyspaceHelpers {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Boolean ownerInFile(File fOwnerList, String owner) throws IOException {
        if (!fOwnerList.exists()) {
            return false;
        }
        FileInputStream inputStream = new FileInputStream(fOwnerList);
        InputStreamReader fr = new InputStreamReader((InputStream)inputStream, "UTF-8");
        try (BufferedReader br = new BufferedReader(fr);){
            String this_line;
            while ((this_line = br.readLine()) != null) {
                if (!this_line.equals(owner)) continue;
                Boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendLineInFile(File f, String line) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(f, true);
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
        try (BufferedWriter bw = new BufferedWriter(fw);){
            bw.write(line);
            bw.newLine();
        }
    }

    public static String getReportOwner(String report, String owner) {
        if (!owner.equals("")) {
            int extensionPos = report.lastIndexOf(46);
            int separatorPos = report.lastIndexOf(File.separatorChar);
            if (separatorPos < extensionPos) {
                return report.substring(0, extensionPos) + "_" + owner + report.substring(extensionPos);
            }
            return report + "_" + owner;
        }
        return report;
    }

    public static String getReportOwnerList(String report) {
        return report + ".owners.list";
    }

    private static int reportGetColId(String[] tokens, String title) throws RuntimeException {
        for (int i = 0; i < tokens.length; ++i) {
            if (!tokens[i].equals(title)) continue;
            return i;
        }
        throw new RuntimeException("Title '" + title + "' does not exist");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reportFilter(String[] arg) throws IOException, RuntimeException {
        if (arg.length < 5) {
            System.out.println("Usage: ps_helper -report-filter <original_report> <filtered_report> [<owner>] [<title> <value>]+");
            return;
        }
        int n = 0;
        int n2 = ++n;
        String originalReport = arg[n2];
        int n3 = ++n;
        ++n;
        String filteredReport = arg[n3];
        String owner = arg.length % 2 == 0 ? arg[n++] : "";
        FileInputStream inputStream = new FileInputStream(originalReport);
        InputStreamReader fr = new InputStreamReader((InputStream)inputStream, "UTF-8");
        BufferedReader br = new BufferedReader(fr);
        BufferedWriter bw = null;
        String this_line = br.readLine();
        Boolean added_one_line = false;
        try {
            if (this_line == null) {
                return;
            }
            int nCriteria = (arg.length - n) / 2;
            String[] tokens = this_line.split("\t");
            int[] colId = new int[nCriteria];
            String[] criteria = new String[nCriteria];
            for (int id = 0; id < nCriteria; ++id) {
                colId[id] = PolyspaceHelpers.reportGetColId(tokens, arg[n++]);
                criteria[id] = arg[n++];
            }
            String filteredReport_owner = PolyspaceHelpers.getReportOwner(filteredReport, owner);
            File fout = new File(filteredReport_owner);
            if (fout.isDirectory()) {
                throw new RuntimeException("Cannot create filtered report as the directory '" + filteredReport_owner + "'");
            }
            Boolean addTitle = !fout.exists();
            FileOutputStream outputStream = new FileOutputStream(fout, true);
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
            bw = new BufferedWriter(fw);
            if (addTitle.booleanValue()) {
                bw.write(this_line);
                bw.newLine();
            }
            while ((this_line = br.readLine()) != null) {
                tokens = this_line.split("\t");
                boolean ok = true;
                for (int id = 0; ok && id < nCriteria; ++id) {
                    ok = tokens[colId[id]].equals(criteria[id]);
                }
                if (!ok) continue;
                added_one_line = true;
                bw.write(this_line);
                bw.newLine();
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (bw != null) {
                bw.close();
            }
        }
        if (added_one_line.booleanValue() && !owner.equals("")) {
            String ownerList = PolyspaceHelpers.getReportOwnerList(filteredReport);
            File fOwnerList = new File(ownerList);
            if (fOwnerList.isDirectory()) {
                throw new RuntimeException("Cannot create owner list as the directory '" + ownerList + "'");
            }
            if (!PolyspaceHelpers.ownerInFile(fOwnerList, owner).booleanValue()) {
                PolyspaceHelpers.appendLineInFile(fOwnerList, owner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AccessUploadResult getAccessUploadResult(String prs_upload_output) throws IOException, RuntimeException {
        AccessUploadResult accessResult = new AccessUploadResult();
        FileInputStream inputStream = new FileInputStream(prs_upload_output);
        InputStreamReader fr = new InputStreamReader((InputStream)inputStream, "UTF-8");
        try (BufferedReader br = new BufferedReader(fr);){
            String this_line;
            while ((this_line = br.readLine()) != null) {
                if (!this_line.startsWith("Upload successful for RUN_ID")) continue;
                String[] tokens = this_line.split(" ");
                accessResult.runId = tokens[4];
                accessResult.projectId = tokens[7];
                break;
            }
        }
        return accessResult;
    }

    private static void prsPrintRunId(String[] arg) throws IOException, RuntimeException {
        if (arg.length != 2) {
            System.out.println("Usage: ps_helper -print-runid <prs upload output>");
            return;
        }
        String prs_upload_output = arg[1];
        AccessUploadResult accessResult = PolyspaceHelpers.getAccessUploadResult(prs_upload_output);
        if (accessResult.runId.equals("")) {
            throw new RuntimeException("Cannot find runId in '" + prs_upload_output + "'");
        }
        System.out.println(accessResult.runId);
    }

    private static void prsPrintProjectId(String[] arg) throws IOException, RuntimeException {
        if (arg.length != 2) {
            System.out.println("Usage: ps_helper -print-projectid <prs upload output>");
            return;
        }
        String prs_upload_output = arg[1];
        AccessUploadResult accessResult = PolyspaceHelpers.getAccessUploadResult(prs_upload_output);
        if (accessResult.projectId.equals("")) {
            throw new RuntimeException("Cannot find projectId in '" + prs_upload_output + "'");
        }
        System.out.println(accessResult.projectId);
    }

    private static void prsPrintProjectURL(String[] arg) throws IOException, RuntimeException {
        if (arg.length != 3) {
            System.out.println("Usage: ps_helper -print-projecturl <prs upload output> <prs_url>");
            return;
        }
        String prs_upload_output = arg[1];
        AccessUploadResult accessResult = PolyspaceHelpers.getAccessUploadResult(prs_upload_output);
        if (accessResult.projectId.equals("") || accessResult.runId.equals("")) {
            throw new RuntimeException("Cannot find project url from '" + prs_upload_output + "'");
        }
        System.out.println(arg[2] + "/metrics/index.html?a=review&p=" + accessResult.projectId + "&r=" + accessResult.runId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reportStatus(String[] arg) throws IOException, NumberFormatException {
        if (arg.length != 3) {
            System.out.println("Usage: ps_helper -report-status <report> <nb_to_fail>");
            return;
        }
        String report = arg[1];
        int max = Integer.parseInt(arg[2]);
        FileInputStream inputStream = new FileInputStream(report);
        InputStreamReader fr = new InputStreamReader((InputStream)inputStream, "UTF-8");
        try (BufferedReader br = new BufferedReader(fr);){
            String this_line;
            int nb = 0;
            while ((this_line = br.readLine()) != null) {
                ++nb;
            }
            if (--nb > max) {
                System.out.println("UNSTABLE");
            } else {
                System.out.println("SUCCESS");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int reportCountFindings(String report) {
        BufferedReader br = null;
        try {
            String this_line;
            FileInputStream inputStream = new FileInputStream(report);
            InputStreamReader fr = new InputStreamReader((InputStream)inputStream, "UTF-8");
            br = new BufferedReader(fr);
            int nb = 0;
            while ((this_line = br.readLine()) != null) {
                ++nb;
            }
            int n = --nb;
            return n;
        }
        catch (IOException e) {
            int n = 0;
            return n;
        }
        catch (Exception e) {
            int n = 0;
            return n;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    return 0;
                }
            }
        }
    }

    private static void reportCountFindings(String[] arg) throws IOException, NumberFormatException {
        if (arg.length != 2) {
            System.out.println("Usage: ps_helper -report-count-findings <report>");
            return;
        }
        int nb = PolyspaceHelpers.reportCountFindings(arg[1]);
        System.out.println(nb);
    }

    public static void main(String[] arg) throws IOException, RuntimeException, NumberFormatException {
        Boolean usage = false;
        if (arg.length == 0) {
            usage = true;
        } else if (arg[0].equals("-report-filter") || arg[0].equals("report_filter")) {
            PolyspaceHelpers.reportFilter(arg);
        } else if (arg[0].equals("-report-status") || arg[0].equals("report_status")) {
            PolyspaceHelpers.reportStatus(arg);
        } else if (arg[0].equals("-report-count-findings") || arg[0].equals("report_count_findings")) {
            PolyspaceHelpers.reportCountFindings(arg);
        } else if (arg[0].equals("-print-runid") || arg[0].equals("prs_print_runid")) {
            PolyspaceHelpers.prsPrintRunId(arg);
        } else if (arg[0].equals("-print-projectid") || arg[0].equals("prs_print_projectid")) {
            PolyspaceHelpers.prsPrintProjectId(arg);
        } else if (arg[0].equals("-print-projecturl") || arg[0].equals("prs_print_projecturl")) {
            PolyspaceHelpers.prsPrintProjectURL(arg);
        } else {
            usage = true;
        }
        if (usage.booleanValue()) {
            String[] empty = new String[]{};
            PolyspaceHelpers.reportFilter(empty);
            PolyspaceHelpers.reportStatus(empty);
            PolyspaceHelpers.reportCountFindings(empty);
            PolyspaceHelpers.prsPrintRunId(empty);
            PolyspaceHelpers.prsPrintProjectId(empty);
            PolyspaceHelpers.prsPrintProjectURL(empty);
        }
    }

    public static class AccessUploadResult {
        String runId = "";
        String projectId = "";
    }
}

