/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.orka.helpers;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.ProxyConfiguration;
import hudson.util.Secret;
import io.jenkins.plugins.orka.client.ConfigurationResponse;
import io.jenkins.plugins.orka.client.DeletionResponse;
import io.jenkins.plugins.orka.client.DeploymentResponse;
import io.jenkins.plugins.orka.client.HealthCheckResponse;
import io.jenkins.plugins.orka.client.OrkaClient;
import io.jenkins.plugins.orka.client.OrkaClientV2;
import io.jenkins.plugins.orka.client.OrkaNode;
import io.jenkins.plugins.orka.client.OrkaVM;
import io.jenkins.plugins.orka.client.OrkaVMConfig;
import io.jenkins.plugins.orka.helpers.CredentialsHelper;
import io.jenkins.plugins.orka.helpers.Utils;
import java.io.IOException;
import java.net.Proxy;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

public class OrkaClientProxy {
    private static String firstVersionWithSingleToken = "2.1.1";
    private StandardUsernamePasswordCredentials credentials;
    private String endpoint;
    private int httpClientTimeout;
    private boolean ignoreSSLErrors;
    private Proxy proxy;
    private String serverVersion;

    public OrkaClientProxy(String endpoint, String credentialsId, int httpClientTimeout, boolean useJenkinsProxySettings) {
        this(endpoint, credentialsId, httpClientTimeout, useJenkinsProxySettings, false);
    }

    public OrkaClientProxy(String endpoint, String credentialsId, int httpClientTimeout, boolean useJenkinsProxySettings, boolean ignoreSSLErrors) {
        this(endpoint, credentialsId, httpClientTimeout, useJenkinsProxySettings, ignoreSSLErrors, null);
    }

    public OrkaClientProxy(String endpoint, String credentialsId, int httpClientTimeout, boolean useJenkinsProxySettings, boolean ignoreSSLErrors, String serverVersion) {
        this.credentials = CredentialsHelper.lookupSystemCredentials(credentialsId);
        this.endpoint = endpoint;
        this.httpClientTimeout = httpClientTimeout;
        this.proxy = this.getProxy(useJenkinsProxySettings);
        this.ignoreSSLErrors = ignoreSSLErrors;
        this.serverVersion = serverVersion;
    }

    public List<OrkaVM> getVMs() throws IOException {
        try (OrkaClient client = this.getOrkaClient();){
            List<OrkaVM> list = client.getVMs().getVMs();
            return list;
        }
    }

    public List<OrkaVMConfig> getVMConfigs() throws IOException {
        try (OrkaClient client = this.getOrkaClient();){
            List<OrkaVMConfig> list = client.getVMConfigs().getConfigs();
            return list;
        }
    }

    public List<OrkaNode> getNodes() throws IOException {
        try (OrkaClient client = this.getOrkaClient();){
            List<OrkaNode> list = client.getNodes().getNodes();
            return list;
        }
    }

    public List<String> getImages() throws IOException {
        try (OrkaClient client = this.getOrkaClient();){
            List<String> list = client.getImages().getImages();
            return list;
        }
    }

    public ConfigurationResponse createConfiguration(String vmName, String image, String baseImage, String configTemplate, int cpuCount) throws IOException {
        return this.createConfiguration(vmName, image, baseImage, configTemplate, cpuCount, null);
    }

    public ConfigurationResponse createConfiguration(String vmName, String image, String baseImage, String configTemplate, int cpuCount, String scheduler) throws IOException {
        return this.createConfiguration(vmName, image, baseImage, configTemplate, cpuCount, scheduler, "auto");
    }

    public ConfigurationResponse createConfiguration(String vmName, String image, String baseImage, String configTemplate, int cpuCount, String scheduler, String memory) throws IOException {
        return this.createConfiguration(vmName, image, baseImage, configTemplate, cpuCount, false, scheduler, memory);
    }

    public ConfigurationResponse createConfiguration(String vmName, String image, String baseImage, String configTemplate, int cpuCount, boolean useNetBoost, String scheduler, String memory) throws IOException {
        return this.createConfiguration(vmName, image, baseImage, configTemplate, cpuCount, false, scheduler, memory, null, null);
    }

    public ConfigurationResponse createConfiguration(String vmName, String image, String baseImage, String configTemplate, int cpuCount, boolean useNetBoost, String scheduler, String memory, String tag, Boolean tagRequired) throws IOException {
        try (OrkaClient client = this.getOrkaClient();){
            ConfigurationResponse configurationResponse = client.createConfiguration(vmName, image, baseImage, configTemplate, cpuCount, useNetBoost, scheduler, memory, tag, tagRequired);
            return configurationResponse;
        }
    }

    public DeploymentResponse deployVM(String vmName) throws IOException {
        return this.deployVM(vmName, null);
    }

    public DeploymentResponse deployVM(String vmName, String node) throws IOException {
        return this.deployVM(vmName, node, null);
    }

    public DeploymentResponse deployVM(String vmName, String node, String scheduler) throws IOException {
        return this.deployVM(vmName, node, scheduler, null, null);
    }

    public DeploymentResponse deployVM(String vmName, String node, String scheduler, String tag, Boolean tagRequired) throws IOException {
        try (OrkaClient client = this.getOrkaClient();){
            DeploymentResponse deploymentResponse = client.deployVM(vmName, node, scheduler, tag, tagRequired);
            return deploymentResponse;
        }
    }

    public DeletionResponse deleteVM(String vmName) throws IOException {
        try (OrkaClient client = this.getOrkaClient();){
            DeletionResponse deletionResponse = client.deleteVM(vmName);
            return deletionResponse;
        }
    }

    public DeletionResponse deleteVM(String vmName, String node) throws IOException {
        try (OrkaClient client = this.getOrkaClient();){
            DeletionResponse deletionResponse = client.deleteVM(vmName, node);
            return deletionResponse;
        }
    }

    public HealthCheckResponse getHealthCheck() throws IOException {
        try (OrkaClient client = this.getOrkaClient(false);){
            HealthCheckResponse healthCheckResponse = client.getHealthCheck();
            return healthCheckResponse;
        }
    }

    private OrkaClient getOrkaClient() throws IOException {
        return this.getOrkaClient(true);
    }

    private OrkaClient getOrkaClient(boolean initToken) throws IOException {
        if (!StringUtils.isBlank((String)this.serverVersion) && Utils.compareVersions(this.serverVersion, firstVersionWithSingleToken) < 0) {
            return new OrkaClient(this.endpoint, this.credentials.getUsername(), Secret.toString((Secret)this.credentials.getPassword()), this.httpClientTimeout, this.proxy, this.ignoreSSLErrors, initToken);
        }
        return new OrkaClientV2(this.endpoint, this.credentials.getUsername(), Secret.toString((Secret)this.credentials.getPassword()), this.httpClientTimeout, this.proxy, this.ignoreSSLErrors);
    }

    private Proxy getProxy(boolean useJenkinsProxySettings) {
        if (useJenkinsProxySettings) {
            ProxyConfiguration proxyConfig = Jenkins.get().proxy;
            return proxyConfig == null ? Proxy.NO_PROXY : proxyConfig.createProxy(this.endpoint);
        }
        return Proxy.NO_PROXY;
    }
}

