/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.orka.helpers;

import hudson.util.FormValidation;
import io.jenkins.plugins.orka.client.HealthCheckResponse;
import io.jenkins.plugins.orka.client.OrkaNode;
import io.jenkins.plugins.orka.helpers.OrkaClientProxy;
import io.jenkins.plugins.orka.helpers.OrkaClientProxyFactory;
import io.jenkins.plugins.orka.helpers.ProvisioningHelper;
import io.jenkins.plugins.orka.helpers.Utils;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

public class FormValidator {
    private static final Logger logger = Logger.getLogger(FormValidator.class.getName());
    private static final String NOT_ENOUGH_RESOURCES_FORMAT = "Not enough resources on node. Required %s CPU, available %s";
    private OrkaClientProxyFactory clientProxyFactory;

    public FormValidator(OrkaClientProxyFactory clientProxyFactory) {
        this.clientProxyFactory = clientProxyFactory;
    }

    public FormValidation doCheckConfigName(String configName, String orkaEndpoint, String orkaCredentialsId, boolean useJenkinsProxySettings, boolean ignoreSSLErrors, boolean createNewVMConfig) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (createNewVMConfig) {
            if (configName.length() < 5) {
                return FormValidation.error((String)"Configuration name should NOT be shorter than 5 characters");
            }
            try {
                OrkaClientProxy clientProxy;
                boolean alreadyInUse;
                if (StringUtils.isNotBlank((String)orkaEndpoint) && orkaCredentialsId != null && (alreadyInUse = (clientProxy = this.clientProxyFactory.getOrkaClientProxy(orkaEndpoint, orkaCredentialsId, useJenkinsProxySettings, ignoreSSLErrors)).getVMs().stream().anyMatch(vm -> vm.getVMName().equalsIgnoreCase(configName)))) {
                    return FormValidation.error((String)"Configuration name is already in use");
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception in doCheckConfigName", e);
            }
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckNode(String node, String orkaEndpoint, String orkaCredentialsId, boolean useJenkinsProxySettings, boolean ignoreSSLErrors, String vm, boolean createNewConfig, int numCPUs) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        boolean hasAvailableNodes = true;
        boolean canDeployVM = true;
        int requiredCPU = 0;
        int availableCPU = 0;
        try {
            OrkaClientProxy clientProxy;
            if (StringUtils.isNotBlank((String)orkaEndpoint) && orkaCredentialsId != null && (hasAvailableNodes = (clientProxy = this.clientProxyFactory.getOrkaClientProxy(orkaEndpoint, orkaCredentialsId, useJenkinsProxySettings, ignoreSSLErrors)).getNodes().stream().filter(ProvisioningHelper::canDeployOnNode).anyMatch(n -> true))) {
                requiredCPU = numCPUs;
                if (!createNewConfig) {
                    requiredCPU = clientProxy.getVMs().stream().filter(v -> v.getVMName().equals(vm)).findFirst().get().getCPUCount();
                }
                OrkaNode nodeDetails = clientProxy.getNodes().stream().filter(n -> n.getHostname().equals(node)).findFirst().get();
                canDeployVM = ProvisioningHelper.canDeployOnNode(nodeDetails, requiredCPU);
                availableCPU = nodeDetails.getAvailableCPU();
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception in doCheckNode", e);
        }
        if (hasAvailableNodes) {
            return canDeployVM ? FormValidation.ok() : FormValidation.error((String)String.format(NOT_ENOUGH_RESOURCES_FORMAT, requiredCPU, availableCPU));
        }
        return FormValidation.error((String)"There are no available nodes");
    }

    public FormValidation doCheckMemory(String memory) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        try {
            if (StringUtils.isBlank((String)memory) || StringUtils.equals((String)memory, (String)"auto")) {
                return FormValidation.ok();
            }
            if (Float.parseFloat(memory) <= 0.0f) {
                return FormValidation.error((String)"Memory should be greater than 0");
            }
            return FormValidation.ok();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception in doCheckMemory", e);
            return FormValidation.error((String)"Memory should be greater than 0");
        }
    }

    public FormValidation doTestConnection(String credentialsId, String endpoint, boolean useJenkinsProxySettings, boolean ignoreSSLErrors) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        try {
            HealthCheckResponse response = new OrkaClientProxyFactory().getOrkaClientProxy(endpoint, credentialsId, useJenkinsProxySettings, ignoreSSLErrors).getHealthCheck();
            if (!response.isSuccessful()) {
                return FormValidator.failedConnection(Utils.getErrorMessage(response));
            }
        }
        catch (IOException e) {
            return FormValidator.failedConnection(e.getMessage());
        }
        return FormValidation.ok((String)"Connection Successful");
    }

    private static FormValidation failedConnection(String message) {
        return FormValidation.error((String)("Connection failed with: " + message));
    }
}

