/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.orka.client;

import io.jenkins.plugins.orka.client.HttpResponse;
import io.jenkins.plugins.orka.client.OrkaError;
import java.util.Arrays;

public class ResponseBase {
    private HttpResponse httpResponse;
    private String message;
    private OrkaError[] errors;

    public ResponseBase(String message, OrkaError[] errors) {
        this.message = message;
        this.errors = errors != null ? (OrkaError[])errors.clone() : new OrkaError[]{};
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    void setHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public String getMessage() {
        return this.message;
    }

    public OrkaError[] getErrors() {
        return (OrkaError[])this.errors.clone();
    }

    public boolean isSuccessful() {
        return this.httpResponse != null ? this.httpResponse.getIsSuccessful() : !this.hasErrors();
    }

    public String getErrorMessage() {
        if (!this.isSuccessful()) {
            return this.hasErrors() ? Arrays.toString(this.getErrors()) : this.httpResponse.getBody();
        }
        return null;
    }

    private boolean hasErrors() {
        return this.errors != null && this.errors.length > 0;
    }
}

