/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.javax.activation;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.util.Objects;
import java.util.function.Supplier;
import javax.activation.FileTypeMap;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class DelegatingFileTypeMap
extends FileTypeMap {
    private final FileTypeMap delegate;

    public DelegatingFileTypeMap(@NonNull FileTypeMap delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> T runWithContextClassLoader(Supplier<T> supplier) {
        Thread t = Thread.currentThread();
        ClassLoader orig = t.getContextClassLoader();
        t.setContextClassLoader(DelegatingFileTypeMap.class.getClassLoader());
        try {
            T t2 = supplier.get();
            return t2;
        }
        finally {
            t.setContextClassLoader(orig);
        }
    }

    public String getContentType(File file) {
        return DelegatingFileTypeMap.runWithContextClassLoader(() -> this.delegate.getContentType(file));
    }

    public String getContentType(String filename) {
        return DelegatingFileTypeMap.runWithContextClassLoader(() -> this.delegate.getContentType(filename));
    }
}

