/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabserverconfig.servers;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.PersistentDescriptor;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.gitlabserverconfig.servers.GitLabServer;
import io.jenkins.plugins.gitlabserverconfig.servers.Messages;
import io.jenkins.plugins.gitlabserverconfig.servers.helpers.GitLabPersonalAccessTokenCreator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

@Extension
public class GitLabServers
extends GlobalConfiguration
implements PersistentDescriptor {
    public static final Logger LOGGER = Logger.getLogger(GitLabServers.class.getName());
    private List<GitLabServer> servers;

    public static GitLabServers get() {
        return (GitLabServers)((Object)ExtensionList.lookup(GlobalConfiguration.class).get(GitLabServers.class));
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public ListBoxModel getServerItems() {
        ListBoxModel result = new ListBoxModel();
        for (GitLabServer server : this.getServers()) {
            String serverUrl = server.getServerUrl();
            String serverName = server.getName();
            result.add((String)(StringUtils.isBlank((String)serverName) ? serverUrl : serverName + " (" + serverUrl + ")"), serverName);
        }
        return result;
    }

    @NonNull
    public List<GitLabServer> getServers() {
        if (this.servers == null || this.servers.isEmpty()) {
            this.servers = new ArrayList<GitLabServer>();
            this.servers.add(new GitLabServer("https://gitlab.com", "default", ""));
        }
        return Collections.unmodifiableList(this.servers);
    }

    public void setServers(@CheckForNull List<? extends GitLabServer> servers) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        this.servers = Util.fixNull(servers).stream().filter(GitLabServers.distinctByKey(GitLabServer::getName)).collect(Collectors.toList());
        this.save();
    }

    @NonNull
    public String getDisplayName() {
        return Messages.GitLabServers_displayName();
    }

    public List<Descriptor> actions() {
        return Collections.singletonList(Jenkins.get().getDescriptor(GitLabPersonalAccessTokenCreator.class));
    }

    public boolean addServer(@NonNull GitLabServer server) {
        ArrayList<GitLabServer> servers = new ArrayList<GitLabServer>(this.getServers());
        GitLabServer gitLabServer = servers.stream().filter(s -> s.getName().equals(server.getName())).findAny().orElse(null);
        if (gitLabServer != null) {
            return false;
        }
        servers.add(server);
        this.setServers(servers);
        return true;
    }

    public boolean updateServer(@NonNull GitLabServer server) {
        List<GitLabServer> servers = new ArrayList<GitLabServer>(this.getServers());
        if (!servers.contains((Object)server)) {
            return false;
        }
        servers = servers.stream().map(oldServer -> oldServer.getName().equals(server.getName()) ? server : oldServer).collect(Collectors.toList());
        this.setServers(servers);
        return true;
    }

    public boolean removeServer(@CheckForNull String name) {
        ArrayList<GitLabServer> servers = new ArrayList<GitLabServer>(this.getServers());
        boolean removed = servers.removeIf(s -> s.getName().equals(name));
        if (removed) {
            this.setServers(servers);
        }
        return removed;
    }

    @CheckForNull
    public GitLabServer findServer(@CheckForNull String serverName) {
        ArrayList<GitLabServer> servers = new ArrayList<GitLabServer>(this.getServers());
        return servers.stream().filter(server -> server.getName().equals(serverName)).findAny().orElse(null);
    }
}

