/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabserverconfig.servers;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.gitlabbranchsource.helpers.GitLabHelper;
import io.jenkins.plugins.gitlabserverconfig.credentials.helpers.GitLabCredentialMatcher;
import io.jenkins.plugins.gitlabserverconfig.servers.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMName;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.models.User;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.plaincredentials.impl.StringCredentialsImpl;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class GitLabServer
extends AbstractDescribableImpl<GitLabServer> {
    public static final CredentialsMatcher CREDENTIALS_MATCHER = new GitLabCredentialMatcher();
    public static final String GITLAB_SERVER_DEFAULT_NAME = "default";
    public static final String GITLAB_SERVER_URL = "https://gitlab.com";
    public static final String EMPTY_TOKEN = "";
    public static final Logger LOGGER = Logger.getLogger(GitLabServer.class.getName());
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final int SHORT_NAME_LENGTH = 4;
    private static final String[] COMMON_PREFIX_HOSTNAMES = new String[]{"git.", "gitlab.", "vcs.", "scm.", "source."};
    @NonNull
    private final String name;
    @NonNull
    private final String serverUrl;
    private boolean manageWebHooks;
    private boolean manageSystemHooks;
    @NonNull
    private String credentialsId;
    private String hooksRootUrl;
    private transient Secret secretToken;
    @NonNull
    private String webhookSecretCredentialsId;
    public static final CredentialsMatcher WEBHOOK_SECRET_CREDENTIALS_MATCHER = CredentialsMatchers.instanceOf(StringCredentials.class);
    private boolean immediateHookTrigger;
    private Integer hookTriggerDelay;

    @DataBoundConstructor
    public GitLabServer(@NonNull String serverUrl, @NonNull String name, @NonNull String credentialsId) {
        this.serverUrl = StringUtils.defaultIfBlank((String)StringUtils.trim((String)serverUrl), (String)GITLAB_SERVER_URL);
        this.name = StringUtils.isBlank((String)name) ? this.getRandomName() : StringUtils.trim((String)name);
        this.credentialsId = credentialsId;
        this.webhookSecretCredentialsId = EMPTY_TOKEN;
    }

    private String getRandomName() {
        return String.format("%s-%s", SCMName.fromUrl((String)this.serverUrl, (String[])COMMON_PREFIX_HOSTNAMES), RandomStringUtils.randomNumeric((int)4));
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getServerUrl() {
        return this.serverUrl;
    }

    public boolean isManageWebHooks() {
        return this.manageWebHooks;
    }

    @DataBoundSetter
    public void setManageWebHooks(boolean manageWebHooks) {
        this.manageWebHooks = manageWebHooks;
    }

    public boolean isManageSystemHooks() {
        return this.manageSystemHooks;
    }

    @DataBoundSetter
    public void setManageSystemHooks(boolean manageSystemHooks) {
        this.manageSystemHooks = manageSystemHooks;
    }

    @NonNull
    public String getCredentialsId() {
        return this.credentialsId;
    }

    public StandardCredentials getCredentials(AccessControlled context) {
        Jenkins jenkins = Jenkins.get();
        if (context == null) {
            jenkins.checkPermission(CredentialsProvider.USE_OWN);
        } else {
            context.checkPermission(CredentialsProvider.USE_OWN);
        }
        return StringUtils.isBlank((String)this.credentialsId) ? null : (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)jenkins, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)StringUtils.defaultIfBlank((String)this.serverUrl, (String)GITLAB_SERVER_URL)).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)this.credentialsId));
    }

    @DataBoundSetter
    public void setHooksRootUrl(String hooksRootUrl) {
        this.hooksRootUrl = Util.fixEmptyAndTrim((String)hooksRootUrl);
    }

    @CheckForNull
    public String getHooksRootUrl() {
        return Util.ensureEndsWith((String)Util.fixEmptyAndTrim((String)this.hooksRootUrl), (String)"/");
    }

    @DataBoundSetter
    @Deprecated
    public void setSecretToken(Secret token) {
        this.secretToken = token;
    }

    @DataBoundSetter
    public void setWebhookSecretCredentialsId(String token) {
        this.webhookSecretCredentialsId = token;
    }

    public String getWebhookSecretCredentialsId() {
        return this.webhookSecretCredentialsId;
    }

    public StringCredentials getWebhookSecretCredentials(AccessControlled context) {
        Jenkins jenkins = Jenkins.get();
        if (context == null) {
            jenkins.checkPermission(CredentialsProvider.USE_OWN);
            return StringUtils.isBlank((String)this.webhookSecretCredentialsId) ? null : (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (ItemGroup)jenkins, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)StringUtils.defaultIfBlank((String)this.serverUrl, (String)GITLAB_SERVER_URL)).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)this.webhookSecretCredentialsId));
        }
        context.checkPermission(CredentialsProvider.USE_OWN);
        if (context instanceof ItemGroup) {
            return StringUtils.isBlank((String)this.webhookSecretCredentialsId) ? null : (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (ItemGroup)((ItemGroup)context), (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)StringUtils.defaultIfBlank((String)this.serverUrl, (String)GITLAB_SERVER_URL)).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)this.webhookSecretCredentialsId));
        }
        return StringUtils.isBlank((String)this.webhookSecretCredentialsId) ? null : (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)((Item)context), (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)StringUtils.defaultIfBlank((String)this.serverUrl, (String)GITLAB_SERVER_URL)).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)this.webhookSecretCredentialsId));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Deprecated
    public Secret getSecretToken() {
        return this.secretToken;
    }

    private StringCredentials getWebhookSecretCredentials(String webhookSecretCredentialsId) {
        Jenkins jenkins = Jenkins.get();
        return StringUtils.isBlank((String)webhookSecretCredentialsId) ? null : (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (ItemGroup)jenkins, (Authentication)ACL.SYSTEM, new ArrayList()), (CredentialsMatcher)CredentialsMatchers.withId((String)webhookSecretCredentialsId));
    }

    public String getSecretTokenAsPlainText() {
        StringCredentials credentials = this.getWebhookSecretCredentials(this.webhookSecretCredentialsId);
        String secretToken = EMPTY_TOKEN;
        if (credentials == null) {
            return null;
        }
        secretToken = credentials.getSecret().getPlainText();
        return secretToken;
    }

    private Object readResolve() {
        if (StringUtils.isBlank((String)this.webhookSecretCredentialsId) && this.secretToken != null) {
            this.migrateWebhookSecretCredentials();
        }
        return this;
    }

    private void migrateWebhookSecretCredentials() {
        List credentials = CredentialsProvider.lookupCredentials(StringCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList());
        for (StringCredentials cred : credentials) {
            if (!StringUtils.equals((String)this.secretToken.getPlainText(), (String)Secret.toString((Secret)cred.getSecret()))) continue;
            this.webhookSecretCredentialsId = cred.getId();
            break;
        }
        if (StringUtils.isBlank((String)this.webhookSecretCredentialsId)) {
            StringCredentialsImpl newCredentials = new StringCredentialsImpl(CredentialsScope.GLOBAL, null, "Migrated from gitlab-branch-source-plugin webhook secret", this.secretToken);
            SystemCredentialsProvider.getInstance().getCredentials().add(newCredentials);
            this.webhookSecretCredentialsId = newCredentials.getId();
        }
        this.secretToken = null;
    }

    public boolean isImmediateHookTrigger() {
        return this.immediateHookTrigger;
    }

    @DataBoundSetter
    public void setImmediateHookTrigger(boolean immediateHookTrigger) {
        this.immediateHookTrigger = immediateHookTrigger;
    }

    @DataBoundSetter
    public void setHookTriggerDelay(String hookTriggerDelay) {
        try {
            this.hookTriggerDelay = Integer.parseInt(hookTriggerDelay);
        }
        catch (NumberFormatException e) {
            this.hookTriggerDelay = null;
        }
    }

    @CheckForNull
    public Integer getHookTriggerDelay() {
        return this.hookTriggerDelay;
    }

    @Symbol(value={"gitLabServer"})
    @Extension
    public static class DescriptorImpl
    extends Descriptor<GitLabServer> {
        public static FormValidation doCheckServerUrl(@QueryParameter String serverUrl) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                new URL(serverUrl);
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.SEVERE, "Incorrect url: %s", serverUrl);
                return FormValidation.error((String)"Malformed url (%s)", (Object[])new Object[]{e.getMessage()});
            }
            if (GitLabServer.GITLAB_SERVER_URL.equals(serverUrl)) {
                LOGGER.log(Level.FINEST, String.format("Community version of GitLab: %s", serverUrl));
            }
            GitLabApi gitLabApi = new GitLabApi(serverUrl, GitLabServer.EMPTY_TOKEN, null, GitLabHelper.getProxyConfig(serverUrl));
            try {
                gitLabApi.getProjectApi().getProjects(1, 1);
                return FormValidation.ok();
            }
            catch (GitLabApiException e) {
                LOGGER.log(Level.FINEST, String.format("Invalid GitLab Server Url: %s", serverUrl));
                return FormValidation.error((String)Messages.GitLabServer_invalidUrl(serverUrl));
            }
        }

        public static FormValidation doCheckHooksRootUrl(@QueryParameter String hooksRootUrl) {
            if (StringUtils.isBlank((String)hooksRootUrl)) {
                return FormValidation.ok();
            }
            try {
                new URL(hooksRootUrl);
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.FINEST, "Malformed hooks root URL: {0}", hooksRootUrl);
                return FormValidation.error((String)"Malformed url (%s)", (Object[])new Object[]{e.getMessage()});
            }
            if (hooksRootUrl.endsWith("/post") || hooksRootUrl.contains("/gitlab-webhook") || hooksRootUrl.contains("/gitlab-systemhook")) {
                LOGGER.log(Level.FINEST, "Dubious hooks root URL: {0}", hooksRootUrl);
                return FormValidation.warning((String)"This looks like a full webhook URL, it should only be a root URL.");
            }
            return FormValidation.ok();
        }

        public static FormValidation doCheckHookTriggerDelay(@QueryParameter String hookTriggerDelay) {
            try {
                if (!hookTriggerDelay.isEmpty()) {
                    Integer.parseInt(hookTriggerDelay);
                }
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.FINEST, "Invalid hook trigger delay: {0}", hookTriggerDelay);
                return FormValidation.error((String)"Invalid hook trigger delay (%s)", (Object[])new Object[]{e.getMessage()});
            }
        }

        @NonNull
        public String getDisplayName() {
            return Messages.GitLabServer_displayName();
        }

        @RequirePOST
        @Restricted(value={DoNotUse.class})
        public FormValidation doTestConnection(@QueryParameter String serverUrl, @QueryParameter String credentialsId) {
            StandardCredentials credentials = this.getCredentials(serverUrl, credentialsId);
            String privateToken = GitLabHelper.getPrivateTokenAsPlainText(credentials);
            if (privateToken.equals(GitLabServer.EMPTY_TOKEN)) {
                GitLabApi gitLabApi = new GitLabApi(serverUrl, GitLabServer.EMPTY_TOKEN, null, GitLabHelper.getProxyConfig(serverUrl));
                try {
                    gitLabApi.getProjectApi().getProjects(1, 1);
                    return FormValidation.ok((String)"Valid GitLab Server but no credentials specified");
                }
                catch (GitLabApiException e) {
                    LOGGER.log(Level.SEVERE, "Invalid GitLab Server Url");
                    return FormValidation.errorWithMarkup((String)Messages.GitLabServer_credentialsNotResolved(Util.escape((String)credentialsId)));
                }
            }
            GitLabApi gitLabApi = new GitLabApi(serverUrl, privateToken, null, GitLabHelper.getProxyConfig(serverUrl));
            try {
                User user = gitLabApi.getUserApi().getCurrentUser();
                LOGGER.log(Level.FINEST, String.format("Connection established with the GitLab Server for %s", user.getUsername()));
                return FormValidation.ok((String)String.format("Credentials verified for user %s", user.getUsername()));
            }
            catch (GitLabApiException e) {
                LOGGER.log(Level.SEVERE, "Failed to connect with GitLab Server - %s", e.getMessage());
                return FormValidation.error((Throwable)e, (String)Messages.GitLabServer_failedValidation(Util.escape((String)e.getMessage())));
            }
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillCredentialsIdItems(@QueryParameter String serverUrl, @QueryParameter String credentialsId) {
            Jenkins jenkins = Jenkins.get();
            if (!jenkins.hasPermission(Jenkins.ADMINISTER)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)jenkins, StandardCredentials.class, URIRequirementBuilder.fromUri((String)serverUrl).build(), CREDENTIALS_MATCHER);
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillWebhookSecretCredentialsIdItems(@QueryParameter String serverUrl, @QueryParameter String webhookSecretCredentialsId) {
            Jenkins jenkins = Jenkins.get();
            if (!jenkins.hasPermission(Jenkins.ADMINISTER)) {
                return new StandardListBoxModel().includeCurrentValue(webhookSecretCredentialsId);
            }
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)jenkins, StringCredentials.class, URIRequirementBuilder.fromUri((String)serverUrl).build(), WEBHOOK_SECRET_CREDENTIALS_MATCHER);
        }

        private StandardCredentials getCredentials(String serverUrl, String credentialsId) {
            Jenkins jenkins = Jenkins.get();
            jenkins.checkPermission(Jenkins.ADMINISTER);
            return StringUtils.isBlank((String)credentialsId) ? null : (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)jenkins, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)StringUtils.defaultIfBlank((String)serverUrl, (String)GitLabServer.GITLAB_SERVER_URL)).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        }
    }
}

