/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabserverconfig.credentials;

import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.FormValidation;
import hudson.util.Secret;
import io.jenkins.plugins.gitlabserverconfig.credentials.Messages;
import io.jenkins.plugins.gitlabserverconfig.credentials.PersonalAccessToken;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class PersonalAccessTokenImpl
extends BaseStandardCredentials
implements PersonalAccessToken {
    @NonNull
    private final Secret token;

    @DataBoundConstructor
    public PersonalAccessTokenImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @NonNull String token) {
        super(scope, id, description);
        this.token = Secret.fromString((String)token);
    }

    @Override
    @NonNull
    public Secret getToken() {
        return this.token;
    }

    @Extension
    @Symbol(value={"gitlabPersonalAccessToken"})
    public static class DescriptorImpl
    extends CredentialsDescriptor {
        private static final int GITLAB_ACCESS_TOKEN_MINIMAL_LENGTH = 20;

        @NonNull
        public String getDisplayName() {
            return Messages.PersonalAccessTokenImpl_displayName();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckToken(@QueryParameter String value) {
            Secret secret = Secret.fromString((String)value);
            if (StringUtils.equals((String)value, (String)secret.getPlainText()) ? value.length() < 20 : secret.getPlainText().length() < 20) {
                return FormValidation.error((String)Messages.PersonalAccessTokenImpl_tokenWrongLength());
            }
            return FormValidation.ok();
        }
    }
}

