/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabserverconfig.action;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.model.RootAction;
import hudson.security.AccessControlled;
import hudson.util.HttpResponses;
import io.jenkins.plugins.gitlabbranchsource.helpers.GitLabHelper;
import io.jenkins.plugins.gitlabserverconfig.servers.GitLabServers;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMSourceOwner;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.models.Project;
import org.gitlab4j.api.models.ProjectFilter;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@Restricted(value={NoExternalUse.class})
public class GitlabAction
implements RootAction {
    public static final Logger LOGGER = Logger.getLogger(GitlabAction.class.getName());

    @RequirePOST
    public HttpResponse doServerList() {
        if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            return HttpResponses.errorJSON((String)"no permission to get Gitlab server list");
        }
        JSONArray servers = new JSONArray();
        GitLabServers.get().getServers().forEach(server -> {
            JSONObject serverObj = new JSONObject();
            serverObj.put("name", (Object)server.getName());
            serverObj.put("url", (Object)server.getServerUrl());
            servers.add((Object)serverObj);
        });
        return HttpResponses.okJSON((JSONArray)servers);
    }

    @RequirePOST
    public HttpResponse doProjectList(@AncestorInPath SCMSourceOwner context, @QueryParameter String server, @QueryParameter String owner) {
        if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            return HttpResponses.errorJSON((String)"no permission to get Gitlab server list");
        }
        if (StringUtils.isEmpty((String)server) || StringUtils.isEmpty((String)owner)) {
            return HttpResponses.errorJSON((String)"server or owner is empty");
        }
        JSONArray servers = new JSONArray();
        GitLabApi gitLabApi = GitLabHelper.apiBuilder((AccessControlled)context, server);
        try {
            for (Project project : gitLabApi.getProjectApi().getUserProjects((Object)owner, new ProjectFilter().withOwned(Boolean.valueOf(true)))) {
                servers.add((Object)project.getPathWithNamespace());
            }
        }
        catch (GitLabApiException e) {
            LOGGER.log(Level.FINE, String.format("errors when get projects from %s/%s as a user", server, owner), e);
        }
        try {
            for (Project project : gitLabApi.getGroupApi().getProjects((Object)owner)) {
                servers.add((Object)project.getPathWithNamespace());
            }
        }
        catch (GitLabApiException e) {
            LOGGER.log(Level.FINE, String.format("errors when get projects from %s/%s as a group", server, owner), e);
        }
        return HttpResponses.okJSON((JSONArray)servers);
    }

    @CheckForNull
    public String getIconFileName() {
        return null;
    }

    @CheckForNull
    public String getDisplayName() {
        return null;
    }

    @CheckForNull
    public String getUrlName() {
        return "/gitlab";
    }
}

