/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMNavigator;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMNavigatorContext;
import io.jenkins.plugins.gitlabbranchsource.Messages;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.trait.SCMNavigatorContext;
import jenkins.scm.api.trait.SCMNavigatorTrait;
import jenkins.scm.api.trait.SCMNavigatorTraitDescriptor;
import jenkins.scm.impl.trait.Discovery;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ProjectNamingStrategyTrait
extends SCMNavigatorTrait {
    private int strategyId = 1;

    @DataBoundConstructor
    public ProjectNamingStrategyTrait() {
    }

    public int getStrategyId() {
        return this.strategyId;
    }

    @DataBoundSetter
    public void setStrategyId(int strategyId) {
        this.strategyId = strategyId;
    }

    protected void decorateContext(SCMNavigatorContext<?, ?> context) {
        if (context instanceof GitLabSCMNavigatorContext) {
            GitLabSCMNavigatorContext ctx = (GitLabSCMNavigatorContext)context;
            ctx.withProjectNamingStrategy(this.getStrategyId());
        }
    }

    @Symbol(value={"gitLabProjectNamingStrategy"})
    @Extension
    @Discovery
    public static class DescriptorImpl
    extends SCMNavigatorTraitDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.ProjectNamingStrategyTrait_displayName();
        }

        public Class<? extends SCMNavigator> getNavigatorClass() {
            return GitLabSCMNavigator.class;
        }

        @Restricted(value={NoExternalUse.class})
        @NonNull
        public ListBoxModel doFillStrategyIdItems() {
            ListBoxModel result = new ListBoxModel();
            result.add(Messages.ProjectNamingStrategyTrait_fullProjectPath(), "1");
            result.add(Messages.ProjectNamingStrategyTrait_projectName(), "2");
            result.add(Messages.ProjectNamingStrategyTrait_contextualProjectPath(), "3");
            result.add(Messages.ProjectNamingStrategyTrait_simpleProjectPath(), "4");
            return result;
        }
    }
}

