/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.gitlabbranchsource.BranchSCMRevision;
import io.jenkins.plugins.gitlabbranchsource.MergeRequestSCMHead;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.mixin.ChangeRequestSCMRevision;
import org.kohsuke.stapler.export.Exported;

public class MergeRequestSCMRevision
extends ChangeRequestSCMRevision<MergeRequestSCMHead> {
    @NonNull
    private final String baseHash;
    @NonNull
    private final String headHash;
    private BranchSCMRevision origin;

    public MergeRequestSCMRevision(@NonNull MergeRequestSCMHead head, @NonNull BranchSCMRevision target, @NonNull BranchSCMRevision origin) {
        super((SCMHead)head, (SCMRevision)target);
        this.baseHash = target.getHash();
        this.headHash = origin.getHash();
        this.origin = origin;
    }

    @NonNull
    public String getBaseHash() {
        return this.baseHash;
    }

    @NonNull
    public String getHeadHash() {
        return this.headHash;
    }

    @Exported
    @NonNull
    public final BranchSCMRevision getOrigin() {
        return this.origin;
    }

    public boolean equivalent(ChangeRequestSCMRevision<?> revision) {
        return revision instanceof MergeRequestSCMRevision && this.origin.equals((Object)((MergeRequestSCMRevision)revision).getOrigin());
    }

    protected int _hashCode() {
        return this.origin.hashCode();
    }

    public String toString() {
        return (String)(this.isMerge() ? ((BranchSCMRevision)this.getTarget()).getHash() + "+" : "") + this.origin.getHash();
    }
}

