/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.jenkins.plugins.gitlabbranchsource.AbstractGitLabJobTrigger;
import io.jenkins.plugins.gitlabbranchsource.GitLabMergeRequestCommentTrigger;
import io.jenkins.plugins.gitlabbranchsource.GitLabMergeRequestTrigger;
import io.jenkins.plugins.gitlabbranchsource.GitLabPushSCMEvent;
import io.jenkins.plugins.gitlabbranchsource.GitLabTagPushSCMEvent;
import io.jenkins.plugins.gitlabserverconfig.servers.GitLabServer;
import io.jenkins.plugins.gitlabserverconfig.servers.GitLabServers;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMHeadEvent;
import org.gitlab4j.api.webhook.MergeRequestEvent;
import org.gitlab4j.api.webhook.NoteEvent;
import org.gitlab4j.api.webhook.PushEvent;
import org.gitlab4j.api.webhook.TagPushEvent;
import org.gitlab4j.api.webhook.WebHookListener;

public class GitLabWebHookListener
implements WebHookListener {
    public static final Logger LOGGER = Logger.getLogger(GitLabWebHookListener.class.getName());
    private static final long GITLAB_CACHING_TIMEOUT = 30L;
    private String origin;

    public GitLabWebHookListener(String origin) {
        this.origin = origin;
    }

    public void onNoteEvent(NoteEvent noteEvent) {
        LOGGER.log(Level.FINE, noteEvent.toString());
        if (noteEvent.getObjectAttributes().getNoteableType() == NoteEvent.NoteableType.MERGE_REQUEST) {
            GitLabMergeRequestCommentTrigger trigger = new GitLabMergeRequestCommentTrigger(noteEvent);
            AbstractGitLabJobTrigger.fireNow(trigger);
        }
    }

    public void onMergeRequestEvent(MergeRequestEvent mrEvent) {
        LOGGER.log(Level.FINE, mrEvent.toString());
        GitLabMergeRequestTrigger trigger = new GitLabMergeRequestTrigger(mrEvent, this.origin);
        this.fireTrigger(trigger, mrEvent.getProject().getWebUrl());
    }

    public void onPushEvent(PushEvent pushEvent) {
        LOGGER.log(Level.FINE, pushEvent.toString());
        GitLabPushSCMEvent trigger = new GitLabPushSCMEvent(pushEvent, this.origin);
        this.fireTrigger(trigger, pushEvent.getProject().getWebUrl());
    }

    public void onTagPushEvent(TagPushEvent tagPushEvent) {
        LOGGER.log(Level.FINE, tagPushEvent.toString());
        GitLabTagPushSCMEvent trigger = new GitLabTagPushSCMEvent(tagPushEvent, this.origin);
        this.fireTrigger(trigger, tagPushEvent.getProject().getWebUrl());
    }

    private void fireTrigger(SCMHeadEvent<?> trigger, String projectUrl) {
        GitLabServer projectServer = this.findProjectServer(projectUrl);
        if (this.findImmediateHookTrigger(projectServer)) {
            SCMHeadEvent.fireNow(trigger);
        }
        long triggerDelay = this.findTriggerDelay(projectServer);
        SCMHeadEvent.fireLater(trigger, (long)triggerDelay, (TimeUnit)TimeUnit.SECONDS);
    }

    private boolean findImmediateHookTrigger(@Nullable GitLabServer projectServer) {
        if (projectServer == null) {
            LOGGER.log(Level.WARNING, "Falling back to no immediate trigger");
            return false;
        }
        return projectServer.isImmediateHookTrigger();
    }

    private long findTriggerDelay(@Nullable GitLabServer projectServer) {
        if (projectServer == null) {
            LOGGER.log(Level.WARNING, "Falling back to default trigger delay equal GitLab caching timeout");
            return 30L;
        }
        Integer configuredDelay = projectServer.getHookTriggerDelay();
        if (configuredDelay != null) {
            return configuredDelay.intValue();
        }
        return 30L;
    }

    private GitLabServer findProjectServer(String projectUrl) {
        for (GitLabServer server : GitLabServers.get().getServers()) {
            if (!projectUrl.startsWith(server.getServerUrl())) continue;
            return server;
        }
        LOGGER.log(Level.WARNING, String.format("No GitLab server for project URL: %s", projectUrl));
        return null;
    }
}

