/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.security.AccessControlled;
import io.jenkins.plugins.gitlabbranchsource.BranchSCMHead;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMFile;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSource;
import io.jenkins.plugins.gitlabbranchsource.GitLabTagSCMHead;
import io.jenkins.plugins.gitlabbranchsource.MergeRequestSCMHead;
import io.jenkins.plugins.gitlabbranchsource.helpers.GitLabHelper;
import java.io.IOException;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;

public class GitLabSCMFileSystem
extends SCMFileSystem {
    private final GitLabApi gitLabApi;
    private final String projectPath;
    private final String ref;

    protected GitLabSCMFileSystem(GitLabApi gitLabApi, String projectPath, String ref, @CheckForNull SCMRevision rev) throws IOException {
        super(rev);
        this.gitLabApi = gitLabApi;
        this.projectPath = projectPath;
        this.ref = ref;
    }

    public long lastModified() throws IOException {
        try {
            return this.gitLabApi.getCommitsApi().getCommit((Object)this.projectPath, this.ref).getCommittedDate().getTime();
        }
        catch (GitLabApiException e) {
            throw new IOException("Failed to retrieve last modified time", e);
        }
    }

    @NonNull
    public SCMFile getRoot() {
        return new GitLabSCMFile(this.gitLabApi, this.projectPath, this.ref);
    }

    @Extension
    public static class BuilderImpl
    extends SCMFileSystem.Builder {
        public boolean supports(SCM source) {
            return false;
        }

        public boolean supports(SCMSource source) {
            return source instanceof GitLabSCMSource;
        }

        protected boolean supportsDescriptor(SCMDescriptor scmDescriptor) {
            return false;
        }

        protected boolean supportsDescriptor(SCMSourceDescriptor scmSourceDescriptor) {
            return false;
        }

        public SCMFileSystem build(@NonNull Item owner, @NonNull SCM scm, @CheckForNull SCMRevision rev) {
            return null;
        }

        public SCMFileSystem build(@NonNull SCMSource source, @NonNull SCMHead head, @CheckForNull SCMRevision rev) throws IOException, InterruptedException {
            GitLabSCMSource gitlabScmSource = (GitLabSCMSource)source;
            GitLabApi gitLabApi = GitLabHelper.apiBuilder((AccessControlled)source.getOwner(), gitlabScmSource.getServerName());
            String projectPath = gitlabScmSource.getProjectPath();
            return this.build(head, rev, gitLabApi, projectPath);
        }

        public SCMFileSystem build(@NonNull SCMHead head, @CheckForNull SCMRevision rev, @NonNull GitLabApi gitLabApi, @NonNull String projectPath) throws IOException, InterruptedException {
            String ref;
            if (head instanceof MergeRequestSCMHead) {
                String mrRef;
                MergeRequestSCMHead mrHead = (MergeRequestSCMHead)head;
                ChangeRequestCheckoutStrategy checkoutStrategy = mrHead.getCheckoutStrategy();
                if (checkoutStrategy == ChangeRequestCheckoutStrategy.HEAD) {
                    mrRef = "head";
                } else if (checkoutStrategy == ChangeRequestCheckoutStrategy.MERGE) {
                    mrRef = "merge";
                } else {
                    return null;
                }
                ref = String.format("merge-requests/%s/%s", mrHead.getId(), mrRef);
            } else if (head instanceof BranchSCMHead) {
                ref = head.getName();
            } else if (head instanceof GitLabTagSCMHead) {
                ref = head.getName();
            } else {
                return null;
            }
            return new GitLabSCMFileSystem(gitLabApi, projectPath, ref, rev);
        }
    }
}

