/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.gitlabbranchsource.AbstractGitLabSCMHeadEvent;
import io.jenkins.plugins.gitlabbranchsource.BranchSCMHead;
import io.jenkins.plugins.gitlabbranchsource.BranchSCMRevision;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMNavigator;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSource;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSourceContext;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSourceRequest;
import io.jenkins.plugins.gitlabbranchsource.GitLabWebHookCause;
import io.jenkins.plugins.gitlabbranchsource.MergeRequestSCMHead;
import io.jenkins.plugins.gitlabbranchsource.MergeRequestSCMRevision;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import org.gitlab4j.api.webhook.MergeRequestEvent;

public class GitLabMergeRequestSCMEvent
extends AbstractGitLabSCMHeadEvent<MergeRequestEvent> {
    public static final Logger LOGGER = Logger.getLogger(GitLabMergeRequestSCMEvent.class.getName());

    public GitLabMergeRequestSCMEvent(MergeRequestEvent mrEvent, String origin) {
        super(GitLabMergeRequestSCMEvent.typeOf(mrEvent), mrEvent, origin);
    }

    private static SCMEvent.Type typeOf(MergeRequestEvent mrEvent) {
        if (mrEvent.getObjectAttributes().getState().equals("closed")) {
            return SCMEvent.Type.REMOVED;
        }
        if (mrEvent.getObjectAttributes().getState().equals("opened") && mrEvent.getObjectAttributes().getCreatedAt().equals(mrEvent.getObjectAttributes().getUpdatedAt())) {
            return SCMEvent.Type.CREATED;
        }
        return SCMEvent.Type.UPDATED;
    }

    public String descriptionFor(@NonNull SCMNavigator navigator) {
        String state = ((MergeRequestEvent)this.getPayload()).getObjectAttributes().getState();
        LOGGER.log(Level.FINE, "descriptionFor() event:{0} state:{1} action:{2} project:{3}", new Object[]{((MergeRequestEvent)this.getPayload()).getObjectAttributes().getIid(), String.valueOf(state), ((MergeRequestEvent)this.getPayload()).getObjectAttributes().getAction(), ((MergeRequestEvent)this.getPayload()).getProject().getName()});
        if (state != null) {
            switch (state) {
                case "opened": 
                case "reopened": 
                case "closed": {
                    return "Merge request !" + ((MergeRequestEvent)this.getPayload()).getObjectAttributes().getIid() + " state:" + state + " action:" + ((MergeRequestEvent)this.getPayload()).getObjectAttributes().getAction() + " in project " + ((MergeRequestEvent)this.getPayload()).getProject().getName() + " changes:" + ((MergeRequestEvent)this.getPayload()).getChanges().toString();
                }
            }
        }
        return "Merge request !" + ((MergeRequestEvent)this.getPayload()).getObjectAttributes().getIid() + " event in project " + ((MergeRequestEvent)this.getPayload()).getProject().getName();
    }

    @Override
    public boolean isMatch(@NonNull GitLabSCMNavigator navigator) {
        return navigator.getNavigatorProjects().contains(((MergeRequestEvent)this.getPayload()).getProject().getPathWithNamespace());
    }

    @Override
    public boolean isMatch(@NonNull GitLabSCMSource source) {
        return ((MergeRequestEvent)this.getPayload()).getObjectAttributes().getTargetProjectId().equals(source.getProjectId());
    }

    @NonNull
    public String getSourceName() {
        return ((MergeRequestEvent)this.getPayload()).getProject().getPathWithNamespace();
    }

    public String descriptionFor(@NonNull SCMSource source) {
        String state = ((MergeRequestEvent)this.getPayload()).getObjectAttributes().getState();
        LOGGER.log(Level.FINE, "descriptionFor() event:{0} state:{1} action:{2}", new Object[]{((MergeRequestEvent)this.getPayload()).getObjectAttributes().getIid(), String.valueOf(state), ((MergeRequestEvent)this.getPayload()).getObjectAttributes().getAction()});
        if (state != null) {
            switch (state) {
                case "opened": 
                case "reopened": 
                case "closed": {
                    return "Merge request !" + ((MergeRequestEvent)this.getPayload()).getObjectAttributes().getIid() + " state:" + state + " action:" + ((MergeRequestEvent)this.getPayload()).getObjectAttributes().getAction() + " changes:" + ((MergeRequestEvent)this.getPayload()).getChanges().toString();
                }
            }
        }
        return "Merge request !" + ((MergeRequestEvent)this.getPayload()).getObjectAttributes().getIid() + " event";
    }

    public String description() {
        String state = ((MergeRequestEvent)this.getPayload()).getObjectAttributes().getState();
        LOGGER.log(Level.FINE, "description() event:{0} state:{1} action:{2} project:{3}", new Object[]{((MergeRequestEvent)this.getPayload()).getObjectAttributes().getIid(), String.valueOf(state), ((MergeRequestEvent)this.getPayload()).getObjectAttributes().getAction(), ((MergeRequestEvent)this.getPayload()).getProject().getPathWithNamespace()});
        if (state != null) {
            switch (state) {
                case "opened": 
                case "reopened": 
                case "closed": {
                    return "Merge request !" + ((MergeRequestEvent)this.getPayload()).getObjectAttributes().getIid() + " state:" + state + " action:" + ((MergeRequestEvent)this.getPayload()).getObjectAttributes().getAction() + " in project " + ((MergeRequestEvent)this.getPayload()).getProject().getPathWithNamespace() + " changes:" + ((MergeRequestEvent)this.getPayload()).getChanges().toString();
                }
            }
        }
        return "Merge request !" + ((MergeRequestEvent)this.getPayload()).getObjectAttributes().getIid() + " event";
    }

    @Override
    @NonNull
    public Map<SCMHead, SCMRevision> headsFor(GitLabSCMSource source) {
        HashMap<SCMHead, SCMRevision> result = new HashMap<SCMHead, SCMRevision>();
        try (GitLabSCMSourceRequest request = ((GitLabSCMSourceContext)new GitLabSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(source.getTraits())).newRequest((SCMSource)source, null);){
            MergeRequestEvent.ObjectAttributes m = ((MergeRequestEvent)this.getPayload()).getObjectAttributes();
            Map<Boolean, Set<ChangeRequestCheckoutStrategy>> strategies = request.getMRStrategies();
            boolean fork = !((MergeRequestEvent)this.getPayload()).getObjectAttributes().getSourceProjectId().equals(((MergeRequestEvent)this.getPayload()).getObjectAttributes().getTargetProjectId());
            String originOwner = ((MergeRequestEvent)this.getPayload()).getUser().getUsername();
            String originProjectPath = m.getSource().getPathWithNamespace();
            for (ChangeRequestCheckoutStrategy strategy : strategies.get(fork)) {
                MergeRequestSCMHead h = new MergeRequestSCMHead("MR-" + m.getIid() + (String)(strategies.get(fork).size() > 1 ? "-" + strategy.name().toLowerCase(Locale.ENGLISH) : ""), m.getIid(), new BranchSCMHead(m.getTargetBranch()), strategy, (SCMHeadOrigin)(fork ? new SCMHeadOrigin.Fork(originProjectPath) : SCMHeadOrigin.DEFAULT), originOwner, originProjectPath, m.getSourceBranch(), m.getTitle());
                result.put(h, (SCMRevision)(m.getState().equals("closed") ? null : new MergeRequestSCMRevision(h, new BranchSCMRevision(h.getTarget(), "HEAD"), new BranchSCMRevision(new BranchSCMHead(h.getOriginName()), m.getLastCommit().getId()))));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Exception caught: " + e, e);
        }
        return result;
    }

    @Override
    public GitLabWebHookCause getCause() {
        return new GitLabWebHookCause().fromMergeRequest((MergeRequestEvent)this.getPayload());
    }
}

