/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource.Cause;

import io.jenkins.plugins.gitlabbranchsource.Cause.GitLabCauseUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.gitlab4j.api.webhook.EventLabel;
import org.gitlab4j.api.webhook.MergeRequestEvent;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class GitLabMergeRequestCauseData {
    private Map<String, String> variables = new HashMap<String, String>();

    public GitLabMergeRequestCauseData(MergeRequestEvent mergeRequestEvent) {
        this.variables.put("GITLAB_OBJECT_KIND", StringUtils.defaultString((String)"merge_request"));
        this.variables.put("GITLAB_USER_NAME", StringUtils.defaultString((String)mergeRequestEvent.getUser().getName()));
        this.variables.put("GITLAB_USER_USERNAME", StringUtils.defaultString((String)mergeRequestEvent.getUser().getUsername()));
        this.variables.put("GITLAB_USER_AVATAR_URL", StringUtils.defaultString((String)mergeRequestEvent.getUser().getAvatarUrl()));
        this.variables.put("GITLAB_PROJECT_ID", GitLabCauseUtils.defaultLongString(mergeRequestEvent.getProject().getId()));
        this.variables.put("GITLAB_PROJECT_NAME", StringUtils.defaultString((String)mergeRequestEvent.getProject().getName()));
        this.variables.put("GITLAB_PROJECT_DESCRIPTION", StringUtils.defaultString((String)mergeRequestEvent.getProject().getDescription()));
        this.variables.put("GITLAB_PROJECT_WEB_URL", StringUtils.defaultString((String)mergeRequestEvent.getProject().getWebUrl()));
        this.variables.put("GITLAB_PROJECT_AVATAR_URL", StringUtils.defaultString((String)mergeRequestEvent.getProject().getAvatarUrl()));
        this.variables.put("GITLAB_PROJECT_GIT_SSH_URL", StringUtils.defaultString((String)mergeRequestEvent.getProject().getGitSshUrl()));
        this.variables.put("GITLAB_PROJECT_GIT_HTTP_URL", StringUtils.defaultString((String)mergeRequestEvent.getProject().getGitHttpUrl()));
        this.variables.put("GITLAB_PROJECT_NAMESPACE", StringUtils.defaultString((String)mergeRequestEvent.getProject().getNamespace()));
        this.variables.put("GITLAB_PROJECT_VISIBILITY_LEVEL", GitLabCauseUtils.defaultVisibilityString(mergeRequestEvent.getProject().getVisibilityLevel()));
        this.variables.put("GITLAB_PROJECT_PATH_NAMESPACE", StringUtils.defaultString((String)mergeRequestEvent.getProject().getPathWithNamespace()));
        this.variables.put("GITLAB_PROJECT_CI_CONFIG_PATH", StringUtils.defaultString((String)mergeRequestEvent.getProject().getCiConfigPath()));
        this.variables.put("GITLAB_PROJECT_DEFAULT_BRANCH", StringUtils.defaultString((String)mergeRequestEvent.getProject().getDefaultBranch()));
        this.variables.put("GITLAB_PROJECT_HOMEPAGE", StringUtils.defaultString((String)mergeRequestEvent.getProject().getHomepage()));
        this.variables.put("GITLAB_PROJECT_URL", StringUtils.defaultString((String)mergeRequestEvent.getProject().getUrl()));
        this.variables.put("GITLAB_PROJECT_SSH_URL", StringUtils.defaultString((String)mergeRequestEvent.getProject().getSshUrl()));
        this.variables.put("GITLAB_PROJECT_HTTP_URL", StringUtils.defaultString((String)mergeRequestEvent.getProject().getHttpUrl()));
        this.variables.put("GITLAB_REPO_NAME", StringUtils.defaultString((String)mergeRequestEvent.getRepository().getName()));
        this.variables.put("GITLAB_REPO_URL", StringUtils.defaultString((String)mergeRequestEvent.getRepository().getUrl()));
        this.variables.put("GITLAB_REPO_DESCRIPTION", StringUtils.defaultString((String)mergeRequestEvent.getRepository().getDescription()));
        this.variables.put("GITLAB_REPO_HOMEPAGE", StringUtils.defaultString((String)mergeRequestEvent.getRepository().getHomepage()));
        this.variables.put("GITLAB_REPO_GIT_SSH_URL", StringUtils.defaultString((String)mergeRequestEvent.getRepository().getGit_ssh_url()));
        this.variables.put("GITLAB_REPO_GIT_HTTP_URL", StringUtils.defaultString((String)mergeRequestEvent.getRepository().getGit_http_url()));
        this.variables.put("GITLAB_REPO_VISIBILITY_LEVEL", GitLabCauseUtils.defaultVisibilityString(mergeRequestEvent.getRepository().getVisibility_level()));
        this.variables.put("GITLAB_OA_ID", GitLabCauseUtils.defaultLongString(mergeRequestEvent.getObjectAttributes().getId()));
        this.variables.put("GITLAB_OA_TARGET_BRANCH", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getTargetBranch()));
        this.variables.put("GITLAB_OA_SOURCE_BRANCH", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getSourceBranch()));
        this.variables.put("GITLAB_OA_SOURCE_PROJECT_ID", GitLabCauseUtils.defaultLongString(mergeRequestEvent.getObjectAttributes().getSourceProjectId()));
        this.variables.put("GITLAB_OA_AUTHOR_ID", GitLabCauseUtils.defaultLongString(mergeRequestEvent.getObjectAttributes().getAuthorId()));
        this.variables.put("GITLAB_OA_ASSIGNEE_ID", GitLabCauseUtils.defaultLongString(mergeRequestEvent.getObjectAttributes().getAssigneeId()));
        this.variables.put("GITLAB_OA_TITLE", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getTitle()));
        this.variables.put("GITLAB_OA_CREATED_AT", GitLabCauseUtils.defaultDateString(mergeRequestEvent.getObjectAttributes().getCreatedAt()));
        this.variables.put("GITLAB_OA_UPDATED_AT", GitLabCauseUtils.defaultDateString(mergeRequestEvent.getObjectAttributes().getUpdatedAt()));
        this.variables.put("GITLAB_OA_MILESTONE_ID", GitLabCauseUtils.defaultLongString(mergeRequestEvent.getObjectAttributes().getMilestoneId()));
        this.variables.put("GITLAB_OA_STATE", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getState()));
        this.variables.put("GITLAB_OA_MERGE_STATUS", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getMergeStatus()));
        this.variables.put("GITLAB_OA_TARGET_PROJECT_ID", GitLabCauseUtils.defaultLongString(mergeRequestEvent.getObjectAttributes().getTargetProjectId()));
        this.variables.put("GITLAB_OA_IID", GitLabCauseUtils.defaultLongString(mergeRequestEvent.getObjectAttributes().getIid()));
        this.variables.put("GITLAB_OA_DESCRIPTION", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getDescription()));
        this.variables.put("GITLAB_OA_SOURCE_NAME", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getSource().getName()));
        this.variables.put("GITLAB_OA_SOURCE_DESCRIPTION", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getSource().getDescription()));
        this.variables.put("GITLAB_OA_SOURCE_WEB_URL", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getSource().getWebUrl()));
        this.variables.put("GITLAB_OA_SOURCE_AVATAR_URL", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getSource().getAvatarUrl()));
        this.variables.put("GITLAB_OA_SOURCE_GIT_SSH_URL", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getSource().getGitSshUrl()));
        this.variables.put("GITLAB_OA_SOURCE_GIT_HTTP_URL", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getSource().getGitHttpUrl()));
        this.variables.put("GITLAB_OA_SOURCE_NAMESPACE", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getSource().getNamespace()));
        this.variables.put("GITLAB_OA_SOURCE_VISIBILITY_LEVEL", GitLabCauseUtils.defaultVisibilityString(mergeRequestEvent.getObjectAttributes().getSource().getVisibilityLevel()));
        this.variables.put("GITLAB_OA_SOURCE_PATH_WITH_NAMESPACE", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getSource().getPathWithNamespace()));
        this.variables.put("GITLAB_OA_SOURCE_DEFAULT_BRANCH", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getSource().getDefaultBranch()));
        this.variables.put("GITLAB_OA_SOURCE_HOMEPAGE", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getSource().getHomepage()));
        this.variables.put("GITLAB_OA_SOURCE_URL", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getSource().getUrl()));
        this.variables.put("GITLAB_OA_SOURCE_SSH_URL", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getSource().getSshUrl()));
        this.variables.put("GITLAB_OA_SOURCE_HTTP_URL", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getSource().getHttpUrl()));
        this.variables.put("GITLAB_OA_TARGET_NAME", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getTarget().getName()));
        this.variables.put("GITLAB_OA_TARGET_DESCRIPTION", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getTarget().getDescription()));
        this.variables.put("GITLAB_OA_TARGET_WEB_URL", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getTarget().getWebUrl()));
        this.variables.put("GITLAB_OA_TARGET_AVATAR_URL", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getTarget().getAvatarUrl()));
        this.variables.put("GITLAB_OA_TARGET_GIT_SSH_URL", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getTarget().getGitSshUrl()));
        this.variables.put("GITLAB_OA_TARGET_GIT_HTTP_URL", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getTarget().getGitHttpUrl()));
        this.variables.put("GITLAB_OA_TARGET_NAMESPACE", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getTarget().getNamespace()));
        this.variables.put("GITLAB_OA_TARGET_VISIBILITY_LEVEL", GitLabCauseUtils.defaultVisibilityString(mergeRequestEvent.getObjectAttributes().getTarget().getVisibilityLevel()));
        this.variables.put("GITLAB_OA_TARGET_PATH_WITH_NAMESPACE", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getTarget().getPathWithNamespace()));
        this.variables.put("GITLAB_OA_TARGET_DEFAULT_BRANCH", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getTarget().getDefaultBranch()));
        this.variables.put("GITLAB_OA_TARGET_HOMEPAGE", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getTarget().getHomepage()));
        this.variables.put("GITLAB_OA_TARGE_URL", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getTarget().getUrl()));
        this.variables.put("GITLAB_OA_TARGET_SSH_URL", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getTarget().getSshUrl()));
        this.variables.put("GITLAB_OA_TARGET_HTTP_URL", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getTarget().getHttpUrl()));
        this.variables.put("GITLAB_OA_LAST_COMMIT_ID", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getLastCommit().getId()));
        this.variables.put("GITLAB_OA_LAST_COMMIT_MESSAGE", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getLastCommit().getMessage()));
        this.variables.put("GITLAB_OA_LAST_COMMIT_TIMESTAMP", GitLabCauseUtils.defaultDateString(mergeRequestEvent.getObjectAttributes().getLastCommit().getTimestamp()));
        this.variables.put("GITLAB_OA_LAST_COMMIT_URL", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getLastCommit().getUrl()));
        this.variables.put("GITLAB_OA_LAST_COMMIT_AUTHOR_NAME", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getLastCommit().getAuthor().getName()));
        this.variables.put("GITLAB_OA_LAST_COMMIT_AUTHOR_EMAIL", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getLastCommit().getAuthor().getEmail()));
        this.variables.put("GITLAB_OA_WIP", GitLabCauseUtils.defaultBooleanString(mergeRequestEvent.getObjectAttributes().getWorkInProgress()));
        this.variables.put("GITLAB_OA_URL", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getUrl()));
        this.variables.put("GITLAB_OA_ACTION", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getAction()));
        if (mergeRequestEvent.getObjectAttributes().getAssignee() != null) {
            this.variables.put("GITLAB_OA_ASSIGNEE_NAME", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getAssignee().getName()));
            this.variables.put("GITLAB_OA_ASSIGNEE_USERNAME", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getAssignee().getUsername()));
            this.variables.put("GITLAB_OA_ASSIGNEE_AVATAR_URL", StringUtils.defaultString((String)mergeRequestEvent.getObjectAttributes().getAssignee().getAvatarUrl()));
        }
        int totalLabels = GitLabCauseUtils.defaultListSize(mergeRequestEvent.getLabels());
        this.variables.put("GITLAB_LABELS_COUNT", GitLabCauseUtils.defaultIntString(totalLabels));
        for (int i = 0; i < totalLabels; ++i) {
            this.variables.put("GITLAB_LABEL_ID_" + i, GitLabCauseUtils.defaultLongString(((EventLabel)mergeRequestEvent.getLabels().get(i)).getId()));
            this.variables.put("GITLAB_LABEL_TITLE_" + i, StringUtils.defaultString((String)((EventLabel)mergeRequestEvent.getLabels().get(i)).getTitle()));
            this.variables.put("GITLAB_LABEL_COLOR_" + i, StringUtils.defaultString((String)((EventLabel)mergeRequestEvent.getLabels().get(i)).getColor()));
            this.variables.put("GITLAB_LABEL_PROJECT_ID_" + i, GitLabCauseUtils.defaultLongString(((EventLabel)mergeRequestEvent.getLabels().get(i)).getProjectId()));
            this.variables.put("GITLAB_LABEL_CREATED_AT_" + i, GitLabCauseUtils.defaultDateString(((EventLabel)mergeRequestEvent.getLabels().get(i)).getCreatedAt()));
            this.variables.put("GITLAB_LABEL_UPDATED_AT_" + i, GitLabCauseUtils.defaultDateString(((EventLabel)mergeRequestEvent.getLabels().get(i)).getUpdatedAt()));
            this.variables.put("GITLAB_LABEL_TEMPLATE_" + i, GitLabCauseUtils.defaultBooleanString(((EventLabel)mergeRequestEvent.getLabels().get(i)).getTemplate()));
            this.variables.put("GITLAB_LABEL_DESCRIPTION_" + i, StringUtils.defaultString((String)((EventLabel)mergeRequestEvent.getLabels().get(i)).getDescription()));
            this.variables.put("GITLAB_LABEL_TYPE_" + i, GitLabCauseUtils.defaultLabelString(((EventLabel)mergeRequestEvent.getLabels().get(i)).getType()));
            this.variables.put("GITLAB_LABEL_GROUP_ID_" + i, GitLabCauseUtils.defaultLongString(((EventLabel)mergeRequestEvent.getLabels().get(i)).getGroupId()));
        }
        if (mergeRequestEvent.getChanges().getUpdatedById() != null) {
            this.variables.put("GITLAB_CHANGES_UPDATED_BY_ID_PREV", GitLabCauseUtils.defaultLongString((Long)mergeRequestEvent.getChanges().getUpdatedById().getPrevious()));
            this.variables.put("GITLAB_CHANGES_UPDATED_BY_ID_CURR", GitLabCauseUtils.defaultLongString((Long)mergeRequestEvent.getChanges().getUpdatedById().getCurrent()));
        }
        if (mergeRequestEvent.getChanges().getUpdatedAt() != null) {
            this.variables.put("GITLAB_CHANGES_UPDATED_AT_PREV", GitLabCauseUtils.defaultDateString((Date)mergeRequestEvent.getChanges().getUpdatedAt().getPrevious()));
            this.variables.put("GITLAB_CHANGES_UPDATED_AT_CURR", GitLabCauseUtils.defaultDateString((Date)mergeRequestEvent.getChanges().getUpdatedAt().getPrevious()));
        }
    }

    @Exported
    public Map<String, String> getBuildVariables() {
        return this.variables;
    }
}

